/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.docmlet.wikitext.core.source;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.statet.docmlet.wikitext.core.markup.IMarkupLanguage;
import org.eclipse.statet.docmlet.wikitext.core.source.IMarkupLanguagePartitioner;
import org.eclipse.statet.ecommons.text.PartitionerDocumentSetupParticipant;

public abstract class MarkupLanguageDocumentSetupParticipant
extends PartitionerDocumentSetupParticipant {
    private final IMarkupLanguage markupLanguage;
    private final int markupLanguageMode;

    public static IMarkupLanguage getMarkupLanguage(IDocument document, String partitioning) {
        IMarkupLanguagePartitioner partitioner = (IMarkupLanguagePartitioner)((IDocumentExtension3)document).getDocumentPartitioner(partitioning);
        return partitioner.getMarkupLanguage();
    }

    public MarkupLanguageDocumentSetupParticipant(IMarkupLanguage markupLanguage, int markupLanguageMode) {
        if (markupLanguage == null) {
            throw new NullPointerException("markupLanguage");
        }
        this.markupLanguage = markupLanguage;
        this.markupLanguageMode = markupLanguageMode;
    }

    public IMarkupLanguage getMarkupLanguage() {
        return this.markupLanguage;
    }

    protected int getMarkupLanguageMode() {
        return this.markupLanguageMode;
    }

    protected void doSetup(IDocument document) {
        this.doSetup(document, this.getMarkupLanguage());
    }

    protected void doSetup(IDocument document, IMarkupLanguage markupLanguage) {
        IDocumentExtension3 extension3 = (IDocumentExtension3)document;
        IMarkupLanguagePartitioner partitioner = (IMarkupLanguagePartitioner)extension3.getDocumentPartitioner(this.getPartitioningId());
        if (partitioner == null) {
            partitioner = this.createDocumentPartitioner(markupLanguage);
            partitioner.connect(document, true);
            extension3.setDocumentPartitioner(this.getPartitioningId(), (IDocumentPartitioner)partitioner);
        } else {
            partitioner.setMarkupLanguage(markupLanguage);
            extension3.setDocumentPartitioner(this.getPartitioningId(), (IDocumentPartitioner)partitioner);
        }
    }

    protected IDocumentPartitioner createDocumentPartitioner() {
        throw new UnsupportedOperationException();
    }

    protected abstract IMarkupLanguagePartitioner createDocumentPartitioner(IMarkupLanguage var1);
}

