/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.collections;

import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.NullDefaultLocation;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault(value={NullDefaultLocation.PARAMETER, NullDefaultLocation.RETURN_TYPE, NullDefaultLocation.FIELD, NullDefaultLocation.TYPE_BOUND, NullDefaultLocation.TYPE_ARGUMENT})
public final class CopyOnWriteList<E>
extends AbstractList<E>
implements List<E> {
    private volatile ImList<E> list;

    private static int indexOf(Object[] array, @Nullable Object e) {
        if (e == null) {
            int i = 0;
            while (i < array.length) {
                if (array[i] == null) {
                    return i;
                }
                ++i;
            }
            return -1;
        }
        int i = 0;
        while (i < array.length) {
            if (e.equals(array[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public CopyOnWriteList() {
        this.list = ImCollections.newList();
    }

    public CopyOnWriteList(List<E> initialList) {
        this.list = ImCollections.toList(initialList);
    }

    @Override
    public synchronized boolean add(E element) {
        this.list = ImCollections.addElement(this.list, element);
        return true;
    }

    @Override
    public synchronized void add(int index, E element) {
        this.list = ImCollections.addElement(this.list, index, element);
    }

    @Override
    public synchronized E set(int index, E element) {
        ImList<E> l = this.list;
        this.list = ImCollections.setElement(l, index, element);
        return l.get(index);
    }

    @Override
    public synchronized boolean remove(@Nullable Object element) {
        ImList<E> l = ImCollections.removeElement(this.list, element);
        if (l != this.list) {
            this.list = l;
            return true;
        }
        return false;
    }

    @Override
    public synchronized E remove(int index) {
        ImList<E> l = this.list;
        this.list = ImCollections.removeElement(l, index);
        return l.get(index);
    }

    @Override
    public synchronized boolean addAll(Collection<? extends E> c) {
        if (!c.isEmpty()) {
            this.list = ImCollections.concatList(this.list, c);
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean addAll(int index, Collection<? extends E> c) {
        if (!c.isEmpty()) {
            ImList<E> l = this.list;
            this.list = ImCollections.concatList(l.subList(0, index), c, l.subList(index, l.size()));
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean retainAll(Collection<?> c) {
        Object[] array = this.list.toArray();
        Object[] toRetain = c.toArray();
        int end = array.length;
        int i = 0;
        while (i < end) {
            if (CopyOnWriteList.indexOf(toRetain, array[i]) >= 0) {
                ++i;
                continue;
            }
            System.arraycopy(array, i + 1, array, i, end - i - 1);
            --end;
        }
        if (end < array.length) {
            this.list = ImCollections.newList(array, 0, end);
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean removeAll(Collection<?> c) {
        Object[] array = this.list.toArray();
        Object[] toRemove = c.toArray();
        int end = array.length;
        int i = 0;
        while (i < end) {
            if (CopyOnWriteList.indexOf(toRemove, array[i]) >= 0) {
                ++i;
                continue;
            }
            System.arraycopy(array, i + 1, array, i, end - i - 1);
            --end;
        }
        if (end < array.length) {
            this.list = ImCollections.newList(array, 0, end);
            return true;
        }
        return false;
    }

    @Override
    public synchronized void clear() {
        if (!this.list.isEmpty()) {
            this.list = ImCollections.newList();
        }
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public E get(int index) {
        return this.list.get(index);
    }

    @Override
    public boolean contains(@Nullable Object o) {
        return this.list.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.list.containsAll(c);
    }

    @Override
    public int indexOf(@Nullable Object o) {
        return this.list.indexOf(o);
    }

    @Override
    public int lastIndexOf(@Nullable Object o) {
        return this.list.lastIndexOf(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.list.iterator();
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.list.listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return this.list.listIterator(index);
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.list.toArray(a);
    }

    public ImList<E> toList() {
        return this.list;
    }

    public synchronized ImList<E> clearToList() {
        ImList<E> list = this.list;
        if (!list.isEmpty()) {
            this.list = ImCollections.newList();
        }
        return list;
    }

    @Override
    public int hashCode() {
        return this.list.hashCode();
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        return this == obj || this.list.equals(obj);
    }

    @Override
    public String toString() {
        return this.list.toString();
    }
}

