/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.resources.core;

import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;

@NonNullByDefault
public class ProjectUtils {
    private static int indexOf(String[] ids, String id) {
        int idx = 0;
        while (idx < ids.length) {
            if (ids[idx].equals(id)) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    private static int indexOf(ICommand[] commands, String id) {
        int idx = 0;
        while (idx < commands.length) {
            if (commands[idx].getBuilderName().equals(id)) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    public static boolean addNature(IProjectDescription description, String natureId) {
        String[] prevNatures = description.getNatureIds();
        int idx = ProjectUtils.indexOf(prevNatures, natureId);
        if (idx == -1) {
            String[] newNatures = new String[prevNatures.length + 1];
            System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
            newNatures[prevNatures.length] = natureId;
            description.setNatureIds(newNatures);
            return true;
        }
        return false;
    }

    public static boolean removeNature(IProjectDescription description, String natureId) {
        String[] prevNatures = description.getNatureIds();
        int idx = ProjectUtils.indexOf(prevNatures, natureId);
        if (idx >= 0) {
            String[] newNatures = new String[prevNatures.length - 1];
            System.arraycopy(prevNatures, 0, newNatures, 0, idx);
            System.arraycopy(prevNatures, idx + 1, newNatures, idx, prevNatures.length - idx - 1);
            description.setNatureIds(newNatures);
            return true;
        }
        return false;
    }

    public static boolean addBuilder(IProjectDescription description, String builderId) {
        ICommand[] prevCommands = description.getBuildSpec();
        int idx = ProjectUtils.indexOf(prevCommands, builderId);
        if (idx == -1) {
            ICommand newCommand = description.newCommand();
            newCommand.setBuilderName(builderId);
            ICommand[] newCommands = new ICommand[prevCommands.length + 1];
            System.arraycopy(prevCommands, 0, newCommands, 0, prevCommands.length);
            newCommands[prevCommands.length] = newCommand;
            description.setBuildSpec(newCommands);
            return true;
        }
        return false;
    }

    public static boolean removeBuilder(IProjectDescription description, String builderId) {
        ICommand[] prevCommands = description.getBuildSpec();
        int idx = ProjectUtils.indexOf(prevCommands, builderId);
        if (idx >= 0) {
            ICommand[] newCommands = new ICommand[prevCommands.length - 1];
            System.arraycopy(prevCommands, 0, newCommands, 0, idx);
            System.arraycopy(prevCommands, idx + 1, newCommands, idx, prevCommands.length - idx - 1);
            description.setBuildSpec(newCommands);
            return true;
        }
        return false;
    }

    private ProjectUtils() {
    }
}

