/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.yaml.core.model;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.statet.internal.yaml.core.model.CompositeSourceElement;
import org.eclipse.statet.internal.yaml.core.model.YamlReconciler;
import org.eclipse.statet.internal.yaml.core.model.YamlSourceUnitModelInfo;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.ltk.ast.core.AstInfo;
import org.eclipse.statet.ltk.model.core.IModelElementDelta;
import org.eclipse.statet.ltk.model.core.elements.IModelElement;
import org.eclipse.statet.ltk.model.core.elements.ISourceUnit;
import org.eclipse.statet.ltk.model.core.elements.ISourceUnitModelInfo;
import org.eclipse.statet.ltk.model.core.impl.AbstractModelEventJob;
import org.eclipse.statet.ltk.model.core.impl.AbstractModelManager;
import org.eclipse.statet.ltk.model.core.impl.SourceUnitModelContainer;
import org.eclipse.statet.yaml.core.model.IYamlModelInfo;
import org.eclipse.statet.yaml.core.model.IYamlModelManager;
import org.eclipse.statet.yaml.core.model.IYamlSourceElement;
import org.eclipse.statet.yaml.core.model.YamlChunkElement;
import org.eclipse.statet.yaml.core.model.YamlSuModelContainer;

public class YamlModelManager
extends AbstractModelManager
implements IYamlModelManager {
    private final EventJob eventJob = new EventJob(this);
    private final YamlReconciler reconciler = new YamlReconciler(this);

    public YamlModelManager() {
        super("Yaml");
    }

    public void dispose() {
        this.eventJob.dispose();
    }

    public EventJob getEventJob() {
        return this.eventJob;
    }

    public void reconcile(SourceUnitModelContainer<?, ?> adapter, int level, IProgressMonitor monitor) {
        if (adapter instanceof YamlSuModelContainer) {
            this.reconciler.reconcile((YamlSuModelContainer)adapter, level, monitor);
        }
    }

    @Override
    public IYamlModelInfo reconcile(ISourceUnit sourceUnit, ISourceUnitModelInfo modelInfo, List<? extends YamlChunkElement> chunks, int level, IProgressMonitor monitor) {
        if (sourceUnit == null) {
            throw new NullPointerException("sourceUnit");
        }
        if (chunks == null) {
            chunks = ImCollections.emptyList();
        }
        CompositeSourceElement unitElement = new CompositeSourceElement((List<? extends IYamlSourceElement>)chunks, sourceUnit, modelInfo.getSourceElement().getSourceRange());
        return new YamlSourceUnitModelInfo(modelInfo.getAst(), unitElement, null);
    }

    protected static class EventJob
    extends AbstractModelEventJob<ISourceUnit, IYamlModelInfo> {
        public EventJob(YamlModelManager manager) {
            super((AbstractModelManager)manager);
        }

        protected IModelElementDelta createDelta(AbstractModelEventJob.Task task) {
            return new ModelDelta(task.getElement(), task.getOldInfo(), task.getNewInfo());
        }

        protected void dispose() {
            super.dispose();
        }
    }

    private static class ModelDelta
    implements IModelElementDelta {
        private final int level;
        private final IModelElement element;
        private final ISourceUnitModelInfo oldInfo;
        private final AstInfo oldAst;
        private final ISourceUnitModelInfo newInfo;
        private final AstInfo newAst;

        public ModelDelta(IModelElement element, ISourceUnitModelInfo oldInfo, ISourceUnitModelInfo newInfo) {
            this.level = 2;
            this.element = element;
            this.oldInfo = oldInfo;
            this.oldAst = oldInfo != null ? oldInfo.getAst() : null;
            this.newInfo = newInfo;
            this.newAst = newInfo != null ? newInfo.getAst() : null;
        }

        public IModelElement getModelElement() {
            return this.element;
        }

        public AstInfo getOldAst() {
            return this.oldAst;
        }

        public AstInfo getNewAst() {
            return this.newAst;
        }
    }
}

