/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.docmlet.wikitext.ui.editors;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.statet.docmlet.wikitext.core.ast.WikitextAst;
import org.eclipse.statet.docmlet.wikitext.core.ast.WikitextAstNode;
import org.eclipse.statet.docmlet.wikitext.core.model.WikitextNameAccess;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.ltk.ast.core.util.AstSelection;
import org.eclipse.statet.ltk.model.core.elements.ISourceUnitModelInfo;
import org.eclipse.statet.ltk.ui.sourceediting.AbstractMarkOccurrencesProvider;
import org.eclipse.swt.graphics.Point;

public class WikitextMarkOccurrencesLocator {
    public void run(AbstractMarkOccurrencesProvider.RunData run, ISourceUnitModelInfo info, AstSelection astSelection, ITextSelection orgSelection) throws BadLocationException, BadPartitioningException, UnsupportedOperationException {
        WikitextAstNode node = (WikitextAstNode)astSelection.getCovering();
        if (this.checkForAccess(run, node)) {
            return;
        }
    }

    private boolean checkForAccess(AbstractMarkOccurrencesProvider.RunData run, WikitextAstNode node) throws BadLocationException {
        if (node == null || node.getNodeType() != WikitextAst.NodeType.LABEL) {
            return false;
        }
        do {
            for (Object attachment : node.getAttachments()) {
                WikitextNameAccess access;
                Map<Annotation, Position> annotations;
                if (!(attachment instanceof WikitextNameAccess) || (annotations = this.checkDefault(run, access = (WikitextNameAccess)attachment)) == null) continue;
                run.set(annotations);
                return true;
            }
        } while ((node = node.getWikitextParent()) != null);
        return false;
    }

    private Map<Annotation, Position> checkDefault(AbstractMarkOccurrencesProvider.RunData run, WikitextNameAccess access) throws BadLocationException {
        while (access != null) {
            WikitextAstNode nameNode = (WikitextAstNode)access.getNameNode();
            if (nameNode == null) {
                return null;
            }
            if (run.accept(new Point(nameNode.getStartOffset(), nameNode.getEndOffset()))) {
                ImList accessList = access.getAllInUnit();
                LinkedHashMap<Annotation, Position> annotations = new LinkedHashMap<Annotation, Position>(accessList.size());
                for (WikitextNameAccess occurrence : accessList) {
                    String message = run.doc.get(((WikitextAstNode)occurrence.getNode()).getStartOffset(), ((WikitextAstNode)occurrence.getNode()).getLength());
                    annotations.put(new Annotation(occurrence.isWriteAccess() ? "org.eclipse.statet.ecommons.text.editorAnnotations.WriteOccurrences" : "org.eclipse.statet.ecommons.text.editorAnnotations.CommonOccurrences", false, message), WikitextNameAccess.getTextPosition((WikitextAstNode)((WikitextAstNode)occurrence.getNameNode())));
                }
                return annotations;
            }
            access = null;
        }
        return null;
    }
}

