/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.ui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.SortedMap;
import org.eclipse.mylyn.internal.wikitext.ui.WikiTextUiPlugin;
import org.eclipse.mylyn.internal.wikitext.ui.editor.help.HelpContent;
import org.eclipse.mylyn.wikitext.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.ui.WikiText;
import org.eclipse.statet.docmlet.base.ui.markuphelp.IMarkupHelpContentProvider;
import org.eclipse.statet.docmlet.base.ui.markuphelp.MarkupHelpContent;

public class WikitextMarkupHelpProvider
implements IMarkupHelpContentProvider {
    public static final String NS = "wikitext";
    private static final String NS_ = "wikitext:";

    public static String getContentIdFor(MarkupLanguage markupLanguage) {
        SortedMap mylynHelps = WikiTextUiPlugin.getDefault().getCheatSheets();
        while (markupLanguage != null && !mylynHelps.containsKey(markupLanguage.getName())) {
            markupLanguage = WikiText.getMarkupLanguage((String)markupLanguage.getExtendsLanguage());
        }
        return markupLanguage != null ? NS_ + markupLanguage.getName() : null;
    }

    public synchronized Collection<MarkupHelpContent> getHelpTopics() {
        SortedMap mylynHelps = WikiTextUiPlugin.getDefault().getCheatSheets();
        ArrayList<MarkupHelpContent> topics = new ArrayList<MarkupHelpContent>(mylynHelps.size());
        for (HelpContent mylynHelp : mylynHelps.values()) {
            topics.add(new WikitextHelpTopic(mylynHelp));
        }
        return topics;
    }

    private static class WikitextHelpTopic
    extends MarkupHelpContent {
        private HelpContent mylynHelp;
        private String content;

        public WikitextHelpTopic(HelpContent mylynHelp) {
            super(WikitextMarkupHelpProvider.NS_ + mylynHelp.getMarkupLanguageName(), mylynHelp.getMarkupLanguageName());
            this.mylynHelp = mylynHelp;
        }

        public String getContent() throws IOException {
            if (this.mylynHelp != null) {
                try {
                    this.content = this.mylynHelp.getContent();
                }
                finally {
                    this.mylynHelp = null;
                }
            }
            return this.content;
        }
    }
}

