/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.search;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.statet.ecommons.workbench.search.ui.LineElement;
import org.eclipse.statet.internal.r.ui.search.RElementMatch;
import org.eclipse.statet.internal.r.ui.search.RElementSearchResult;
import org.eclipse.statet.jcommons.text.core.TextLineInformation;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.core.SourceContent;
import org.eclipse.statet.ltk.model.core.elements.ISourceUnit;
import org.eclipse.statet.r.core.RProject;
import org.eclipse.statet.r.core.model.IRFrame;
import org.eclipse.statet.r.core.model.IRFrameInSource;
import org.eclipse.statet.r.core.model.IRModelInfo;
import org.eclipse.statet.r.core.model.IRSourceUnit;
import org.eclipse.statet.r.core.model.RElementAccess;
import org.eclipse.statet.r.core.model.RElementName;
import org.eclipse.statet.r.core.refactoring.RElementSearchProcessor;
import org.eclipse.statet.r.core.rsource.ast.RAst;
import org.eclipse.statet.r.core.rsource.ast.RAstNode;

public class RElementSearch
extends RElementSearchProcessor {
    private final boolean searchWrite;
    RElementSearchResult result;
    private final StringBuilder sb = new StringBuilder();

    public RElementSearch(RElementName name, IRSourceUnit sourceUnit, RElementAccess mainAccess, RElementSearchProcessor.Mode mode, boolean searchWrite) {
        super(name, sourceUnit, mainAccess, mode, 4096);
        this.searchWrite = searchWrite;
    }

    public final boolean searchWrite() {
        return this.searchWrite;
    }

    protected void begin(SubMonitor progress) {
        super.begin(progress);
        this.result.removeAll();
    }

    protected void process(RProject project, List<ISourceUnit> sus, SubMonitor progress) throws BadLocationException {
        if (sus != null) {
            int remaining = sus.size();
            for (ISourceUnit su : sus) {
                progress.setWorkRemaining(remaining--);
                this.process((IRSourceUnit)su, progress.newChild(1));
            }
        }
    }

    protected void process(IRSourceUnit sourceUnit, SubMonitor progress) throws BadLocationException {
        progress.setWorkRemaining(10);
        sourceUnit.connect((IProgressMonitor)progress.newChild(1));
        try {
            IRSourceUnit bestUnit = sourceUnit;
            if (bestUnit.getUnderlyingUnit() != null && bestUnit.isSynchronized()) {
                bestUnit = sourceUnit;
            }
            IRModelInfo modelInfo = (IRModelInfo)sourceUnit.getModelInfo("R", 2, (IProgressMonitor)progress.newChild(1));
            SourceContent content = sourceUnit.getContent((IProgressMonitor)progress.newChild(1));
            ArrayList<List> allFrameAccess = new ArrayList<List>();
            for (String frameId : this.definitionFrameIds) {
                List allAccess;
                Object frame = frameId == null ? modelInfo.getTopFrame() : (IRFrame)modelInfo.getReferencedFrames().get(frameId);
                if (!(frame instanceof IRFrameInSource) || (allAccess = frame.getAllAccessOf(this.mainName.getSegmentName(), true)) == null || allAccess.size() <= 0) continue;
                allFrameAccess.add(allAccess);
            }
            String contentText = content.getText();
            TextLineInformation lineInformation = content.getLines();
            HashMap<Integer, LineElement> lineElements = new HashMap<Integer, LineElement>();
            for (List allAccess : allFrameAccess) {
                for (RElementAccess access : allAccess) {
                    if ((access = this.include(access)) == null) continue;
                    RAstNode nameNode = access.getNameNode();
                    TextRegion nameRegion = RAst.getElementNameRegion((RAstNode)nameNode);
                    Integer lineNumber = lineInformation.getLineOfOffset(nameRegion.getStartOffset());
                    LineElement lineElement = (LineElement)lineElements.get(lineNumber);
                    if (lineElement == null) {
                        int lineOffset = lineInformation.getStartOffset(lineNumber.intValue());
                        lineElement = new LineElement((Object)bestUnit, lineNumber.intValue(), lineOffset, this.getContent(contentText, lineOffset, lineOffset + lineInformation.getLength(lineNumber.intValue())));
                        lineElements.put(lineNumber, lineElement);
                    }
                    this.result.addMatch(new RElementMatch((LineElement<IRSourceUnit>)lineElement, nameRegion.getStartOffset(), nameRegion.getLength(), access.isWriteAccess() && access.getNextSegment() == null));
                }
            }
            progress.setWorkRemaining(1);
        }
        finally {
            sourceUnit.disconnect((IProgressMonitor)progress.newChild(1));
        }
    }

    private RElementAccess include(RElementAccess access) {
        return (access = this.searchMatch(access)) != null && access.isMaster() && (!this.searchWrite() || access.isWriteAccess()) ? access : null;
    }

    private String getContent(String text, int start, int end) {
        this.sb.setLength(0);
        int idx = start;
        while (idx < end) {
            char c = text.charAt(idx);
            if (Character.isWhitespace(c) || Character.isISOControl(c)) {
                this.sb.append(' ');
            } else {
                this.sb.append(c);
            }
            ++idx;
        }
        return this.sb.toString();
    }
}

