/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.nico.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.statet.internal.nico.ui.NicoUIPlugin;
import org.eclipse.statet.internal.nico.ui.ToolRegistry;
import org.eclipse.statet.nico.core.runtime.ToolProcess;
import org.eclipse.statet.nico.ui.IToolRegistryListener;
import org.eclipse.statet.nico.ui.ToolSessionUIData;
import org.eclipse.ui.AbstractSourceProvider;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ToolSourceProvider
extends AbstractSourceProvider
implements IWindowListener {
    public static final String ACTIVE_TOOL_NAME = "org.eclipse.statet.activeTool";
    private final ToolRegistry fRegistry;
    private final List<RegistryListerner> fCreatedListeners = new ArrayList<RegistryListerner>();
    private IWorkbenchWindow fActiveWindow;
    private ToolProcess fCurrentTool;

    public ToolSourceProvider() {
        this.fRegistry = NicoUIPlugin.getInstance().getToolRegistry();
        PlatformUI.getWorkbench().addWindowListener((IWindowListener)this);
        IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            this.windowOpened(window);
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        List<RegistryListerner> list = this.fCreatedListeners;
        synchronized (list) {
            Iterator<RegistryListerner> iter = this.fCreatedListeners.iterator();
            while (iter.hasNext()) {
                this.fRegistry.removeListener(iter.next());
                iter.remove();
            }
            this.fCreatedListeners.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void windowOpened(IWorkbenchWindow window) {
        RegistryListerner listener = new RegistryListerner(window);
        List<RegistryListerner> list = this.fCreatedListeners;
        synchronized (list) {
            this.fCreatedListeners.add(listener);
        }
        this.fRegistry.addListener(listener, window.getActivePage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void windowClosed(IWorkbenchWindow window) {
        List<RegistryListerner> list = this.fCreatedListeners;
        synchronized (list) {
            Iterator<RegistryListerner> iter = this.fCreatedListeners.iterator();
            while (iter.hasNext()) {
                if (iter.next().fWindow != window) continue;
                iter.remove();
            }
        }
        this.fActiveWindow = null;
    }

    public void windowActivated(IWorkbenchWindow window) {
        this.fActiveWindow = window;
        this.handleActivated(this.fRegistry.getActiveToolSession(window.getActivePage()).getProcess());
    }

    public void windowDeactivated(IWorkbenchWindow window) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleActivated(ToolProcess tool) {
        ToolSourceProvider toolSourceProvider = this;
        synchronized (toolSourceProvider) {
            if (this.fCurrentTool == tool || this.fCurrentTool == null && tool == null) {
                return;
            }
            this.fCurrentTool = tool;
        }
        if (DEBUG) {
            System.out.println("[tool source] changed:" + (tool != null ? tool.getLabel() : "-"));
        }
        Object value = tool != null ? tool : IEvaluationContext.UNDEFINED_VARIABLE;
        this.fireSourceChanged(0, ACTIVE_TOOL_NAME, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleTerminated(ToolProcess tool) {
        ToolSourceProvider toolSourceProvider = this;
        synchronized (toolSourceProvider) {
            if (this.fCurrentTool == tool) {
                if (DEBUG) {
                    System.out.println("[tool source] terminated:" + (tool != null ? tool.getLabel() : "-"));
                }
                this.fireSourceChanged(0, ACTIVE_TOOL_NAME, tool);
            }
        }
    }

    public String[] getProvidedSourceNames() {
        return new String[]{ACTIVE_TOOL_NAME};
    }

    public Map getCurrentState() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Object tool = null;
        if (this.fActiveWindow != null) {
            tool = this.fRegistry.getActiveToolSession(this.fActiveWindow.getActivePage()).getProcess();
        }
        if (tool == null) {
            tool = IEvaluationContext.UNDEFINED_VARIABLE;
        }
        map.put(ACTIVE_TOOL_NAME, tool);
        return map;
    }

    private class RegistryListerner
    implements IToolRegistryListener {
        private final IWorkbenchWindow fWindow;

        public RegistryListerner(IWorkbenchWindow window) {
            this.fWindow = window;
        }

        @Override
        public void toolSessionActivated(ToolSessionUIData info) {
            if (ToolSourceProvider.this.fActiveWindow == this.fWindow) {
                ToolSourceProvider.this.handleActivated(info.getProcess());
            }
        }

        @Override
        public void toolTerminated(ToolSessionUIData sessionData) {
            if (ToolSourceProvider.this.fActiveWindow == this.fWindow) {
                ToolSourceProvider.this.handleTerminated(sessionData.getProcess());
            }
        }
    }
}

