/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.debug.core.eval;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IExpressionManager;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.statet.ecommons.debug.core.eval.IEvaluationListener;
import org.eclipse.statet.ecommons.debug.core.eval.IEvaluationResult;
import org.eclipse.statet.internal.r.debug.core.Messages;
import org.eclipse.statet.internal.r.debug.core.eval.EvalExpressionRunnable;
import org.eclipse.statet.internal.r.debug.core.eval.ExpressionValidator;
import org.eclipse.statet.internal.r.debug.core.eval.REvalExpressionTask;
import org.eclipse.statet.internal.r.debug.core.eval.REvaluationExpression;
import org.eclipse.statet.internal.r.debug.core.eval.REvaluationResult;
import org.eclipse.statet.internal.r.debug.core.model.RDebugTarget;
import org.eclipse.statet.internal.r.debug.core.model.RMainThread;
import org.eclipse.statet.internal.r.debug.core.model.RStackFrame;
import org.eclipse.statet.jcommons.collections.CopyOnWriteList;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.jcommons.ts.core.SystemRunnable;
import org.eclipse.statet.jcommons.ts.core.Tool;
import org.eclipse.statet.jcommons.ts.core.ToolRunnable;
import org.eclipse.statet.jcommons.ts.core.ToolService;
import org.eclipse.statet.r.console.core.RProcess;
import org.eclipse.statet.r.core.tool.TmpUtils;
import org.eclipse.statet.r.debug.core.IRDebugTarget;
import org.eclipse.statet.r.debug.core.IRStackFrame;
import org.eclipse.statet.r.nico.AbstractRDbgController;

@NonNullByDefault
public class ExpressionManager {
    private final Map<REvalExpressionTask.Key, @Nullable REvaluationResult> evalResults = new HashMap<REvalExpressionTask.Key, REvaluationResult>();
    private final List<@NonNull REvaluationResult> oldEvalResults = new ArrayList<REvaluationResult>();
    private final CopyOnWriteList<@NonNull REvaluationExpression> expressions = new CopyOnWriteList();
    private final RMainThread thread;
    private final CleanRunnable cleanRunnable = new CleanRunnable();

    public ExpressionManager(RMainThread thread) {
        this.thread = thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache(int stamp, @Nullable ProgressMonitor m) {
        ExpressionManager expressionManager = this;
        synchronized (expressionManager) {
            if (!this.evalResults.isEmpty()) {
                Iterator<Map.Entry<REvalExpressionTask.Key, @Nullable REvaluationResult>> iter = this.evalResults.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry<REvalExpressionTask.Key, @Nullable REvaluationResult> entry = iter.next();
                    REvaluationResult result = entry.getValue();
                    if (result != null) {
                        this.oldEvalResults.add(result);
                        entry.setValue(null);
                        continue;
                    }
                    iter.remove();
                }
            }
        }
        int cleanCounter = 0;
        for (REvaluationResult result : this.oldEvalResults) {
            if (result.isLocked()) {
                if (stamp == 0) continue;
                result.reset(stamp, m);
                continue;
            }
            ++cleanCounter;
        }
        if (cleanCounter > 0) {
            this.scheduleClean();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evaluate(String expressionText, IRStackFrame stackFrame, boolean forceReevaluate, IEvaluationListener listener) {
        REvaluationResult result;
        if (!this.checkExpression(expressionText, listener)) {
            return;
        }
        REvalExpressionTask task = new REvalExpressionTask(expressionText, (RStackFrame)stackFrame);
        ExpressionManager expressionManager = this;
        synchronized (expressionManager) {
            if (forceReevaluate) {
                result = null;
                this.evalResults.put(task.getKey(), null);
            } else {
                result = this.evalResults.get(task.getKey());
                if (result != null) {
                    result.lock();
                }
            }
        }
        if (result == null) {
            int stamp = this.thread.checkStackFrame(stackFrame);
            if (stamp != 0) {
                EvalExpressionRunnable runnable;
                RProcess tool = this.thread.getTool();
                EvalExpressionRunnable evalExpressionRunnable = runnable = new EvalExpressionRunnable(task, stamp, listener);
                synchronized (evalExpressionRunnable) {
                    if (tool.getQueue().add((ToolRunnable)runnable).getSeverity() == 0) {
                        return;
                    }
                }
            }
            result = new REvaluationResult(expressionText, this.thread);
        }
        listener.evaluationFinished((IEvaluationResult)result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkExpression(String rExpression, IEvaluationListener listener) {
        String errorMessage;
        ExpressionValidator expressionValidator;
        IRDebugTarget debugTarget = this.thread.getDebugTarget();
        ExpressionValidator expressionValidator2 = expressionValidator = ((RDebugTarget)debugTarget).getExpressionValidator();
        synchronized (expressionValidator2) {
            errorMessage = expressionValidator.checkExpression(rExpression);
        }
        if (errorMessage != null) {
            listener.evaluationFinished((IEvaluationResult)new REvaluationResult(rExpression, this.thread, 4, errorMessage));
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEvalResult(REvalExpressionTask.Key evalKey, REvaluationResult result) {
        REvaluationResult prev;
        ExpressionManager expressionManager = this;
        synchronized (expressionManager) {
            prev = this.evalResults.put(evalKey, result);
        }
        if (prev != null) {
            prev.free();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable REvaluationResult getEvalResult(REvalExpressionTask.Key evalKey) {
        ExpressionManager expressionManager = this;
        synchronized (expressionManager) {
            REvaluationResult result = this.evalResults.get(evalKey);
            if (result != null) {
                result.lock();
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleClean() {
        CleanRunnable cleanRunnable = this.cleanRunnable;
        synchronized (cleanRunnable) {
            if (this.cleanRunnable.scheduled) {
                return;
            }
            this.thread.getTool().getQueue().addHot((ToolRunnable)this.cleanRunnable);
            this.cleanRunnable.scheduled = true;
        }
    }

    private void cleanEvalResults(AbstractRDbgController r, ProgressMonitor m) {
        Iterator<REvaluationResult> iter = this.oldEvalResults.iterator();
        while (iter.hasNext()) {
            REvaluationResult result = iter.next();
            if (result.isLocked()) continue;
            iter.remove();
            TmpUtils.Item tmpId = result.getTmpItem();
            if (tmpId == null) continue;
            tmpId.disposeChecked(m);
        }
    }

    public void register(REvaluationExpression expression) {
        this.expressions.add((Object)expression);
    }

    public void unregister(REvaluationExpression expression) {
        this.expressions.remove((Object)expression);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void updateExpressions(List<@NonNull DebugEvent> eventCollection) {
        @NonNull ImList list = this.expressions.toList();
        for (REvaluationExpression expression : list) {
            eventCollection.add(new DebugEvent((Object)expression, 16, 512));
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void cleanExpressions(List<@NonNull DebugEvent> eventCollection) {
        @NonNull ImList list = this.expressions.clearToList();
        IExpressionManager manager = DebugPlugin.getDefault().getExpressionManager();
        for (REvaluationExpression expression : list) {
            manager.removeExpression((IExpression)expression);
        }
    }

    private class CleanRunnable
    implements SystemRunnable {
        private boolean scheduled;

        public String getTypeId() {
            return "r/dbg/exprs/clean";
        }

        public String getLabel() {
            return Messages.Expression_Clean_task;
        }

        public boolean canRunIn(Tool tool) {
            return tool == ExpressionManager.this.thread.getTool();
        }

        public boolean changed(int event, Tool process) {
            switch (event) {
                case 288: 
                case 289: {
                    return false;
                }
                case 290: {
                    break;
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(ToolService service, ProgressMonitor m) throws StatusException {
            CleanRunnable cleanRunnable = this;
            synchronized (cleanRunnable) {
                this.scheduled = false;
            }
            ExpressionManager.this.cleanEvalResults((AbstractRDbgController)service, m);
        }
    }
}

