/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.debug.ui.breakpoints;

import java.util.IdentityHashMap;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ltk.core.LTK;
import org.eclipse.statet.ltk.model.core.ISourceUnitManager;
import org.eclipse.statet.ltk.model.core.elements.ISourceUnit;
import org.eclipse.statet.r.core.model.IRWorkspaceSourceUnit;
import org.eclipse.statet.r.debug.core.breakpoints.IRBreakpoint;
import org.eclipse.statet.r.debug.core.breakpoints.IRLineBreakpoint;
import org.eclipse.statet.r.debug.core.breakpoints.RLineBreakpointValidator;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.texteditor.IMarkerUpdater;
import org.eclipse.ui.texteditor.MarkerUtilities;

public class BreakpointMarkerUpdater
implements IMarkerUpdater {
    private static final String[] ATTRIBUTES = new String[]{"lineNumber", "charStart", "charEnd"};

    public String getMarkerType() {
        return IBreakpoint.BREAKPOINT_MARKER;
    }

    public String[] getAttribute() {
        return ATTRIBUTES;
    }

    public boolean updateMarker(IMarker marker, IDocument document, Position position) {
        if (position == null) {
            return true;
        }
        if (position.isDeleted()) {
            return false;
        }
        IBreakpoint breakpoint = DebugPlugin.getDefault().getBreakpointManager().getBreakpoint(marker);
        if (breakpoint == null) {
            return false;
        }
        if (breakpoint instanceof IRLineBreakpoint) {
            return this.update((IRLineBreakpoint)breakpoint, marker, document, position);
        }
        return this.updateBasic(marker, document, position);
    }

    private boolean update(IRLineBreakpoint breakpoint, IMarker marker, IDocument document, Position position) {
        NullProgressMonitor monitor = new NullProgressMonitor();
        ISourceUnitManager suManager = LTK.getSourceUnitManager();
        ISourceUnit su = suManager.getSourceUnit(LTK.PERSISTENCE_CONTEXT, (Object)marker.getResource(), null, true, (IProgressMonitor)monitor);
        if (su != null) {
            try {
                IRWorkspaceSourceUnit rSourceUnit;
                RLineBreakpointValidator validator;
                su = suManager.getSourceUnit(LTK.EDITOR_CONTEXT, (Object)su, null, true, (IProgressMonitor)monitor);
                assert (su.getDocument(null) == document);
                if (su instanceof IRWorkspaceSourceUnit && (validator = new RLineBreakpointValidator(rSourceUnit = (IRWorkspaceSourceUnit)su, breakpoint.getBreakpointType(), position.getOffset(), (IProgressMonitor)monitor)).getType() != null) {
                    validator.updateBreakpoint((IRBreakpoint)breakpoint);
                    return true;
                }
                return false;
            }
            catch (CoreException e) {
                StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.r.ui", 0, NLS.bind((String)"An error occurred when updating an R line breakpoint in ''{0}''.", (Object)su.getElementName().getDisplayName()), (Throwable)e));
                return false;
            }
            finally {
                su.disconnect((IProgressMonitor)monitor);
            }
        }
        return false;
    }

    private boolean updateBasic(IMarker marker, IDocument document, Position position) {
        boolean offsetsInitialized = false;
        int markerStart = MarkerUtilities.getCharStart((IMarker)marker);
        int markerEnd = MarkerUtilities.getCharEnd((IMarker)marker);
        IdentityHashMap<String, Integer> attributes = new IdentityHashMap<String, Integer>(4);
        if (markerStart != -1 && markerEnd != -1) {
            offsetsInitialized = true;
            int offset = position.getOffset();
            if (markerStart != offset) {
                attributes.put("charStart", offset);
            }
            if (markerEnd != (offset += position.getLength())) {
                attributes.put("charEnd", offset);
            }
        }
        if (!offsetsInitialized || !attributes.isEmpty() && MarkerUtilities.getLineNumber((IMarker)marker) != -1) {
            try {
                attributes.put("lineNumber", document.getLineOfOffset(position.getOffset()) + 1);
            }
            catch (BadLocationException offset) {
                // empty catch block
            }
        }
        if (!attributes.isEmpty()) {
            try {
                marker.setAttributes(attributes);
            }
            catch (CoreException e) {
                StatusManager.getManager().handle(e.getStatus());
            }
        }
        return true;
    }
}

