/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.ui.text.r;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.statet.ecommons.text.ICharPairMatcher;
import org.eclipse.statet.r.core.source.RHeuristicTokenScanner;
import org.eclipse.statet.r.ui.text.r.RBracketPairMatcher;

public class RDoubleClickStrategy
implements ITextDoubleClickStrategy {
    private final String fPartitioning;
    private final ICharPairMatcher fPairMatcher;
    private final RHeuristicTokenScanner fScanner;

    public RDoubleClickStrategy(RHeuristicTokenScanner scanner) {
        this.fScanner = scanner;
        this.fPartitioning = scanner.getDocumentPartitioning();
        this.fPairMatcher = new RBracketPairMatcher(this.fScanner);
    }

    public RDoubleClickStrategy(RHeuristicTokenScanner scanner, ICharPairMatcher pairMatcher) {
        this.fScanner = scanner;
        this.fPartitioning = scanner.getDocumentPartitioning();
        this.fPairMatcher = pairMatcher;
    }

    public void doubleClicked(ITextViewer textViewer) {
        int offset = textViewer.getSelectedRange().x;
        if (offset < 0) {
            return;
        }
        IDocument document = textViewer.getDocument();
        try {
            int partitionOffset;
            IRegion region;
            ITypedRegion partition = TextUtilities.getPartition((IDocument)document, (String)this.fPartitioning, (int)offset, (boolean)true);
            String type = partition.getType();
            if (type == "R.Default" && (region = this.fPairMatcher.match(document, offset)) != null && region.getLength() >= 2) {
                textViewer.setSelectedRange(region.getOffset() + 1, region.getLength() - 2);
                return;
            }
            partition = TextUtilities.getPartition((IDocument)document, (String)this.fPartitioning, (int)offset, (boolean)false);
            type = partition.getType();
            if (type == "R.String" || type == "R.QuotedSymbol") {
                int partitionOffset2 = partition.getOffset();
                int partitionEnd = partitionOffset2 + partition.getLength();
                if (offset == partitionOffset2 || offset == partitionOffset2 + 1 || offset == partitionEnd || offset == partitionEnd - 1) {
                    this.selectRegion(textViewer, this.getStringContent(document, partition));
                } else {
                    this.fScanner.configure(document);
                    IRegion region2 = this.fScanner.findCommonWord(offset);
                    if (region2 != null) {
                        textViewer.setSelectedRange(region2.getOffset(), region2.getLength());
                    } else {
                        textViewer.setSelectedRange(offset, 0);
                    }
                }
                return;
            }
            if (!(type != "R.Comment" && type != "R.Roxygen" || offset != (partitionOffset = partition.getOffset()) && offset != partitionOffset + 1)) {
                textViewer.setSelectedRange(partitionOffset, partition.getLength());
                return;
            }
            if (type == "R.Op.Infix") {
                textViewer.setSelectedRange(partition.getOffset(), partition.getLength());
                return;
            }
            if (partition.getOffset() == offset && offset > 0 && (partition = TextUtilities.getPartition((IDocument)document, (String)this.fPartitioning, (int)(offset - 1), (boolean)true)).getType() == "R.String") {
                this.selectRegion(textViewer, this.getStringContent(document, partition));
                return;
            }
            this.fScanner.configure(document);
            region = this.fScanner.findRWord(offset, true, false);
            if (region != null) {
                textViewer.setSelectedRange(region.getOffset(), region.getLength());
                return;
            }
            region = this.fScanner.findBlankRegion(offset, false);
            if (region != null) {
                textViewer.setSelectedRange(region.getOffset(), region.getLength());
                return;
            }
        }
        catch (BadLocationException badLocationException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        textViewer.setSelectedRange(offset, 0);
    }

    private final void selectRegion(ITextViewer viewer, IRegion region) {
        viewer.setSelectedRange(region.getOffset(), region.getLength());
    }

    private final IRegion getStringContent(IDocument document, ITypedRegion partition) throws BadLocationException {
        int partitionOffset = partition.getOffset();
        int partitionLength = partition.getLength();
        if (partitionLength <= 1) {
            return new Region(partitionOffset + 1, 0);
        }
        char c = document.getChar(partitionOffset);
        document.getLength();
        if (document.getChar(partitionOffset + partitionLength - 1) != c) {
            return new Region(partitionOffset + 1, partitionLength - 1);
        }
        return new Region(partitionOffset + 1, partitionLength - 2);
    }
}

