/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rhelp.core.http.jetty;

import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.Enumeration;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.ProtocolHandler;
import org.eclipse.jetty.client.WWWAuthenticationProtocolHandler;
import org.eclipse.jetty.proxy.ProxyServlet;
import org.eclipse.statet.internal.rhelp.core.server.JettyServerClientSupport;
import org.eclipse.statet.internal.rhelp.core.server.ServerClientSupport;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.rhelp.core.http.HttpForwardHandler;
import org.eclipse.statet.rhelp.core.http.jetty.JettyRHelpUtils;

@NonNullByDefault
public class JettyForwardHandler
implements HttpForwardHandler {
    private static final String ATTR_URI = "forward.uri";
    private static final String SERVLET_KEY = "org.eclipse.statet.rhelp.ForwardProxy";
    private volatile @Nullable HttpServlet proxyServlet;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private HttpServlet getServlet(ServletContext servletContext) throws ServletException {
        Object servlet = this.proxyServlet;
        if (servlet != null) return servlet;
        Class<Servlet> clazz = Servlet.class;
        synchronized (Servlet.class) {
            servlet = (HttpServlet)servletContext.getAttribute(SERVLET_KEY);
            if (servlet == null) {
                servlet = new Servlet();
                servlet.init(new ServletConfig(servletContext){
                    private final ServletContext context;
                    {
                        this.context = servletContext;
                    }

                    public String getServletName() {
                        return JettyForwardHandler.SERVLET_KEY;
                    }

                    public ServletContext getServletContext() {
                        return this.context;
                    }

                    public Enumeration<String> getInitParameterNames() {
                        return Collections.emptyEnumeration();
                    }

                    public @Nullable String getInitParameter(String name) {
                        return null;
                    }
                });
                servletContext.setAttribute(SERVLET_KEY, servlet);
            }
            this.proxyServlet = servlet;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return servlet;
        }
    }

    @Override
    public void forward(URI url, HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        req.setAttribute(ATTR_URI, (Object)url);
        this.getServlet(req.getServletContext()).service((ServletRequest)req, (ServletResponse)resp);
    }

    private static class Servlet
    extends ProxyServlet {
        private static final long serialVersionUID = 1L;

        public void init(ServletConfig config) throws ServletException {
            JettyRHelpUtils.ensureExecutor(config.getServletContext());
            super.init(config);
            try {
                HttpClient httpClient = (HttpClient)ObjectUtils.nonNullAssert((Object)this.getHttpClient());
                ((JettyServerClientSupport)ServerClientSupport.getInstance()).configureAdditional(httpClient);
                httpClient.getProtocolHandlers().put((ProtocolHandler)new WWWAuthenticationProtocolHandler(httpClient));
            }
            catch (StatusException statusException) {
                // empty catch block
            }
        }

        protected String rewriteTarget(HttpServletRequest clientRequest) {
            URI url = (URI)clientRequest.getAttribute(JettyForwardHandler.ATTR_URI);
            return url.toString();
        }
    }
}

