/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.server.client;

import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.rj.data.RJIOExternalizable;
import org.eclipse.statet.rj.server.client.AbstractRJComClient;
import org.eclipse.statet.rj.server.client.RClientGraphicActions;
import org.eclipse.statet.rj.server.gr.Coord;

public abstract class AbstractRJComClientGraphicActions
implements RClientGraphicActions {
    protected final AbstractRJComClient rjs;

    protected AbstractRJComClientGraphicActions(AbstractRJComClient rjs) {
        if (rjs == null) {
            throw new NullPointerException("rjs");
        }
        this.rjs = rjs;
    }

    public void doResizeGraphic(int devId, ProgressMonitor m) throws StatusException {
        this.rjs.execSyncGraphicOp(devId, (byte)8, m);
    }

    public void doCloseGraphic(int devId, ProgressMonitor m) throws StatusException {
        this.rjs.execSyncGraphicOp(devId, (byte)1, m);
    }

    @Override
    public void copy(int devId, String toDev, String toDevFile, String toDevArgs, ProgressMonitor m) throws StatusException {
        StringBuilder sb = new StringBuilder(64);
        sb.append("rj:::gr.copyGraphic(");
        sb.append("devNr=").append(devId + 1).append("L,");
        sb.append("device=").append(toDev).append(",");
        if (toDevFile != null) {
            sb.append("file=\"").append(toDevFile).append("\",");
        }
        if (toDevArgs != null && toDevArgs.length() > 0) {
            sb.append(toDevArgs);
            sb.append(",");
        }
        sb.replace(sb.length() - 1, sb.length(), ")");
        this.rjs.evalVoid(sb.toString(), null, m);
    }

    @Override
    public double[] convertGraphic2User(int devId, double[] xy, ProgressMonitor m) throws StatusException {
        if (xy == null) {
            throw new NullPointerException("xy");
        }
        if (xy.length != 2) {
            throw new IllegalArgumentException("length of xy");
        }
        Coord coord = (Coord)this.rjs.execSyncGraphicOp(devId, (byte)16, (RJIOExternalizable)new Coord(xy[0], xy[1]), m);
        if (coord != null && !Double.isNaN(coord.getX()) && !Double.isNaN(coord.getY())) {
            return new double[]{coord.getX(), coord.getY()};
        }
        return null;
    }

    @Override
    public double[] convertUser2Graphic(int devId, double[] xy, ProgressMonitor m) throws StatusException {
        if (xy == null) {
            throw new NullPointerException("xy");
        }
        if (xy.length != 2) {
            throw new IllegalArgumentException("length of xy");
        }
        Coord coord = (Coord)this.rjs.execSyncGraphicOp(devId, (byte)17, (RJIOExternalizable)new Coord(xy[0], xy[1]), m);
        if (coord != null && !Double.isNaN(coord.getX()) && !Double.isNaN(coord.getY())) {
            return new double[]{coord.getX(), coord.getY()};
        }
        return null;
    }

    public static interface Factory {
        public AbstractRJComClientGraphicActions create(AbstractRJComClient var1, Object var2);
    }
}

