/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.databinding.jface;

import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.statet.ecommons.databinding.jface.AbstractSWTObservableValue;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class SWTTextNullableObservableValue
extends AbstractSWTObservableValue {
    private final Text fTextWidget;
    private Object fValue;
    private boolean fUpdating = false;
    private final ModifyListener fListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            if (!SWTTextNullableObservableValue.this.fUpdating) {
                Object oldValue = SWTTextNullableObservableValue.this.fValue;
                Object newValue = SWTTextNullableObservableValue.this.doGetValue();
                if (newValue != null ? !newValue.equals(SWTTextNullableObservableValue.this.fValue) : SWTTextNullableObservableValue.this.fValue != null) {
                    SWTTextNullableObservableValue.this.fireValueChange(Diffs.createValueDiff((Object)oldValue, (Object)newValue));
                }
            }
        }
    };

    public SWTTextNullableObservableValue(Text text) {
        super((Widget)text);
        this.fTextWidget = text;
        this.fTextWidget.addModifyListener(this.fListener);
    }

    public synchronized void dispose() {
        this.fTextWidget.removeModifyListener(this.fListener);
        super.dispose();
    }

    public Object getValueType() {
        return String.class;
    }

    protected Object doGetValue() {
        String text = this.fTextWidget.getText();
        if (text.trim().isEmpty()) {
            this.fValue = null;
            return null;
        }
        this.fValue = text;
        return this.fValue;
    }

    protected void doSetValue(Object value) {
        try {
            this.fUpdating = true;
            this.fValue = value;
            if (value == null) {
                this.fTextWidget.setText("");
            } else {
                this.fTextWidget.setText((String)value);
            }
        }
        finally {
            this.fUpdating = false;
        }
    }
}

