/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionInfo;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.internal.expressions.AndExpression;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.ActiveShellExpression;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.swt.IFocusService;

public class ControlServicesUtil {
    private final String fId;
    private final IServiceLocator fServiceLocator;
    private Expression fDefaultExpression;
    private boolean fRequireDeactivation;
    private IHandlerService fHandlerService;
    private List<IHandlerActivation> fActivatedHandlers;

    public ControlServicesUtil(IServiceLocator serviceLocator, String id, Control parentControl) {
        assert (serviceLocator != null);
        assert (id != null);
        assert (parentControl != null);
        this.fId = id;
        this.fServiceLocator = serviceLocator;
        this.init(parentControl);
    }

    private void init(Control control) {
        this.fDefaultExpression = new FocusExpression();
        if (this.fServiceLocator instanceof IWorkbench) {
            AndExpression and = new AndExpression();
            and.add((Expression)new ActiveShellExpression(control.getShell()));
            and.add(this.fDefaultExpression);
            this.fDefaultExpression = and;
            this.fRequireDeactivation = true;
        } else if (this.fServiceLocator instanceof IWorkbenchPage && !control.getShell().equals(((IWorkbenchPage)this.fServiceLocator).getWorkbenchWindow().getShell())) {
            AndExpression and = new AndExpression();
            and.add((Expression)new ActiveShellExpression(control.getShell()));
            and.add(this.fDefaultExpression);
            this.fDefaultExpression = and;
            this.fRequireDeactivation = true;
        } else {
            this.fRequireDeactivation = false;
        }
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ControlServicesUtil.this.dispose();
            }
        });
    }

    public void addControl(Control control) {
        IFocusService focusService = (IFocusService)this.fServiceLocator.getService(IFocusService.class);
        focusService.addFocusTracker(control, this.fId);
    }

    public Expression getExpression() {
        return this.fDefaultExpression;
    }

    public void activateHandler(String commandId, IHandler handler) {
        if (this.fHandlerService == null) {
            this.fHandlerService = (IHandlerService)this.fServiceLocator.getService(IHandlerService.class);
            if (this.fRequireDeactivation) {
                this.fActivatedHandlers = new ArrayList<IHandlerActivation>();
            }
        }
        IHandlerActivation handlerActivation = this.fHandlerService.activateHandler(commandId, handler, this.fDefaultExpression);
        if (this.fActivatedHandlers != null) {
            this.fActivatedHandlers.add(handlerActivation);
        }
    }

    protected void dispose() {
        if (this.fHandlerService != null) {
            if (this.fActivatedHandlers != null) {
                this.fHandlerService.deactivateHandlers(this.fActivatedHandlers);
                this.fActivatedHandlers = null;
            }
            this.fHandlerService = null;
        }
    }

    private class FocusExpression
    extends Expression {
        private FocusExpression() {
        }

        String getFocusControlId() {
            return ControlServicesUtil.this.fId;
        }

        public EvaluationResult evaluate(IEvaluationContext context) throws CoreException {
            Object id = context.getVariable("activeFocusControlId");
            return ControlServicesUtil.this.fId == id ? EvaluationResult.TRUE : EvaluationResult.FALSE;
        }

        public void collectExpressionInfo(ExpressionInfo info) {
            info.addVariableNameAccess("activeFocusControlId");
        }

        protected int computeHashCode() {
            return FocusExpression.class.hashCode() * 89 + FocusExpression.hashCode((Object)ControlServicesUtil.this.fId) * 89;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof FocusExpression)) {
                return false;
            }
            FocusExpression other = (FocusExpression)((Object)obj);
            return ControlServicesUtil.this.fId.equals(other.getFocusControlId());
        }
    }
}

