/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.components;

import com.ibm.icu.text.DecimalFormat;
import org.eclipse.statet.ecommons.collections.FastList;
import org.eclipse.statet.ecommons.ui.components.IObjValueListener;
import org.eclipse.statet.ecommons.ui.components.IObjValueWidget;
import org.eclipse.statet.ecommons.ui.components.ObjValueEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class IntText
implements IObjValueWidget<Integer> {
    private final Text fText;
    private Integer fValue;
    private final FastList<IObjValueListener<Integer>> fValueListeners = new FastList(IObjValueListener.class);
    private int fIncrement;
    private int fMin = Integer.MIN_VALUE;
    private int fMax = Integer.MAX_VALUE;
    private DecimalFormat fFormat;

    public IntText(Composite parent, int flags) {
        this.fText = new Text(parent, 0x4004 | flags);
        SWTListener swtListener = new SWTListener();
        this.fText.addListener(24, (Listener)swtListener);
        this.fText.addListener(1, (Listener)swtListener);
    }

    public Text getControl() {
        return this.fText;
    }

    @Override
    public Class<Integer> getValueType() {
        return Integer.class;
    }

    public void setIncrement(int v) {
        this.fIncrement = v;
    }

    public void setMinMax(int min, int max) {
        this.fMin = min;
        this.fMax = max;
    }

    public void setFormat(DecimalFormat format) {
        this.fFormat = format;
    }

    @Override
    public void addValueListener(IObjValueListener<Integer> listener) {
        this.fValueListeners.add(listener);
    }

    @Override
    public void removeValueListener(IObjValueListener<Integer> listener) {
        this.fValueListeners.remove(listener);
    }

    @Override
    public Integer getValue(int idx) {
        return this.fValue;
    }

    @Override
    public void setValue(int idx, Integer value) {
        this.fText.setText(this.formatValue(value));
    }

    private void incrementValue(int increment) {
        int newValue;
        int n = newValue = this.fValue != null ? this.fValue + increment : this.fMin;
        if (newValue < this.fMin) {
            newValue = this.fMin;
        } else if (newValue > this.fMax) {
            newValue = this.fMax;
        }
        this.fText.setText(this.formatValue(newValue));
    }

    protected Integer parseValue(String text) {
        try {
            return Integer.valueOf(text);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    protected String formatValue(Integer value) {
        if (value == null) {
            return "";
        }
        if (this.fFormat != null) {
            return this.fFormat.format((long)value.intValue());
        }
        return value.toString();
    }

    private void updateValue(int time) {
        Integer newValue = this.parseValue(this.fText.getText());
        if (newValue != null ? newValue.equals(this.fValue) : this.fValue == null) {
            return;
        }
        IObjValueListener[] listeners = (IObjValueListener[])this.fValueListeners.toArray();
        ObjValueEvent<Integer> event = new ObjValueEvent<Integer>(this, time, 0, this.fValue, newValue, 0);
        this.fValue = newValue;
        int i = 0;
        while (i < listeners.length) {
            event.newValue = newValue;
            listeners[i].valueChanged(event);
            ++i;
        }
    }

    private class SWTListener
    implements Listener {
        private SWTListener() {
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 24: {
                    IntText.this.updateValue(event.time);
                    return;
                }
                case 1: {
                    switch (event.keyCode) {
                        case 0x1000001: {
                            IntText.this.incrementValue(IntText.this.fIncrement);
                            event.doit = false;
                            return;
                        }
                        case 0x1000002: {
                            IntText.this.incrementValue(-IntText.this.fIncrement);
                            event.doit = false;
                            return;
                        }
                        case 0x1000005: {
                            IntText.this.incrementValue(IntText.this.fIncrement * 10);
                            event.doit = false;
                            return;
                        }
                        case 0x1000006: {
                            IntText.this.incrementValue(-IntText.this.fIncrement * 10);
                            event.doit = false;
                            return;
                        }
                    }
                }
            }
        }
    }
}

