/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.nico.core.util;

import java.util.EnumSet;
import org.eclipse.statet.ecommons.models.AbstractSettingsModelObject;
import org.eclipse.statet.nico.core.runtime.SubmitType;

public class TrackingConfiguration
extends AbstractSettingsModelObject {
    static int DEFAULT_FILE_MODE = 1;
    private final String fId;
    private String fName;
    private boolean fTrackStreamInfo;
    private boolean fTrackStreamInput;
    private boolean fTrackStreamInputHistoryOnly;
    private boolean fTrackStreamOutput;
    private boolean fTrackStreamOutputTruncate;
    private int fTrackStreamOutputTruncateLines;
    private EnumSet<SubmitType> fSubmitTypes;
    private String fFilePath;
    private int fFileMode;
    private boolean fPrependTimestamp;

    public TrackingConfiguration(String id) {
        this.fId = id;
        this.fName = "";
        this.loadDefaults();
    }

    public TrackingConfiguration(String id, TrackingConfiguration template) {
        this.fId = id;
        this.fName = template.fName;
        this.fTrackStreamInfo = template.fTrackStreamInfo;
        this.fTrackStreamInput = template.fTrackStreamInput;
        this.fTrackStreamInputHistoryOnly = template.fTrackStreamInputHistoryOnly;
        this.fTrackStreamOutput = template.fTrackStreamOutput;
        this.fTrackStreamOutputTruncate = template.fTrackStreamOutputTruncate;
        this.fTrackStreamOutputTruncateLines = template.fTrackStreamOutputTruncateLines;
        this.fSubmitTypes = template.fSubmitTypes;
        this.fFilePath = template.fFilePath;
        this.fFileMode = template.fFileMode;
        this.fPrependTimestamp = template.fPrependTimestamp;
    }

    public void loadDefaults() {
        this.setTrackStreamInfo(true);
        this.setTrackStreamInput(true);
        this.setTrackStreamInputHistoryOnly(false);
        this.setTrackStreamOutput(true);
        this.setTrackStreamOutputTruncate(false);
        this.setTrackStreamOutputTruncateLines(50);
        this.setSubmitTypes(SubmitType.getDefaultSet());
        this.setFilePath("");
        this.setFileMode(DEFAULT_FILE_MODE);
        this.setPrependTimestamp(true);
    }

    public String getId() {
        return this.fId;
    }

    public String getName() {
        return this.fName;
    }

    public void setName(String label) {
        String oldValue = this.fName;
        this.fName = label;
        this.firePropertyChange("name", oldValue, label);
    }

    public boolean getTrackStreamInfo() {
        return this.fTrackStreamInfo;
    }

    public void setTrackStreamInfo(boolean enable) {
        boolean oldValue = this.fTrackStreamInfo;
        this.fTrackStreamInfo = enable;
        this.firePropertyChange("trackStreamInfo", oldValue, enable);
    }

    public boolean getTrackStreamInput() {
        return this.fTrackStreamInput;
    }

    public void setTrackStreamInput(boolean enable) {
        boolean oldValue = this.fTrackStreamInput;
        this.fTrackStreamInput = enable;
        this.firePropertyChange("trackStreamInput", oldValue, enable);
    }

    public boolean getTrackStreamInputHistoryOnly() {
        return this.fTrackStreamInputHistoryOnly;
    }

    public void setTrackStreamInputHistoryOnly(boolean enable) {
        boolean oldValue = this.fTrackStreamInputHistoryOnly;
        this.fTrackStreamInputHistoryOnly = enable;
        this.firePropertyChange("trackStreamInputHistoryOnly", oldValue, enable);
    }

    public boolean getTrackStreamOutput() {
        return this.fTrackStreamOutput;
    }

    public void setTrackStreamOutput(boolean enable) {
        boolean oldValue = this.fTrackStreamOutput;
        this.fTrackStreamOutput = enable;
        this.firePropertyChange("trackStreamOutput", oldValue, enable);
    }

    public boolean getTrackStreamOutputTruncate() {
        return this.fTrackStreamOutputTruncate;
    }

    public void setTrackStreamOutputTruncate(boolean enable) {
        boolean oldValue = this.fTrackStreamOutputTruncate;
        this.fTrackStreamOutputTruncate = enable;
        this.firePropertyChange("trackStreamOutputTruncate", oldValue, enable);
    }

    public int getTrackStreamOutputTruncateLines() {
        return this.fTrackStreamOutputTruncateLines;
    }

    public void setTrackStreamOutputTruncateLines(int lines) {
        int oldValue = this.fTrackStreamOutputTruncateLines;
        this.fTrackStreamOutputTruncateLines = lines;
        this.firePropertyChange("trackStreamOutputTruncateLines", oldValue, lines);
    }

    public EnumSet<SubmitType> getSubmitTypes() {
        return this.fSubmitTypes;
    }

    public void setSubmitTypes(EnumSet<SubmitType> typesToInclude) {
        EnumSet<SubmitType> oldValue = this.fSubmitTypes;
        this.fSubmitTypes = typesToInclude;
        this.firePropertyChange("submitTypes", oldValue, typesToInclude);
    }

    public String getFilePath() {
        return this.fFilePath;
    }

    public void setFilePath(String path) {
        String oldValue = this.fFilePath;
        this.fFilePath = path;
        this.firePropertyChange("filePath", oldValue, path);
    }

    public int getFileMode() {
        return this.fFileMode;
    }

    public void setFileMode(int mode) {
        int oldValue = this.fFileMode;
        this.fFileMode = mode;
        this.firePropertyChange("fileMode", oldValue, mode);
    }

    public String getFileEncoding() {
        return "UTF-8";
    }

    public boolean getPrependTimestamp() {
        return this.fPrependTimestamp;
    }

    public void setPrependTimestamp(boolean enable) {
        boolean oldValue = this.fPrependTimestamp;
        this.fPrependTimestamp = enable;
        this.firePropertyChange("prependTimestamp", oldValue, enable);
    }

    public int hashCode() {
        return this.fId.hashCode();
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof TrackingConfiguration && this.fId.equals(((TrackingConfiguration)((Object)obj)).fId);
    }
}

