/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.nico.ui.preferences;

import java.util.Collection;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.statet.ecommons.net.resourcemapping.core.IResourceMapping;
import org.eclipse.statet.ecommons.net.resourcemapping.core.IResourceMappingManager;
import org.eclipse.statet.ecommons.net.resourcemapping.core.ResourceMappingUtils;
import org.eclipse.statet.ecommons.preferences.ui.ConfigurationBlock;
import org.eclipse.statet.ecommons.ui.components.ButtonGroup;
import org.eclipse.statet.ecommons.ui.dialogs.DialogUtils;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.viewers.ComparatorViewerComparator;
import org.eclipse.statet.ecommons.ui.viewers.ViewerUtils;
import org.eclipse.statet.internal.nico.core.ResourceMapping;
import org.eclipse.statet.internal.nico.core.ResourceMappingManager;
import org.eclipse.statet.internal.nico.ui.preferences.EditMappingDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

class ResourceMappingConfigurationBlock
extends ConfigurationBlock {
    private TableViewer listViewer;
    private ButtonGroup<ResourceMapping> listButtons;
    private final IObservableList<ResourceMapping> list = new WritableList();
    private ResourceMappingManager manager;

    protected String getHelpContext() {
        return "org.eclipse.statet.nico.ui.resourcemapping";
    }

    protected void createBlockArea(Composite pageComposite) {
        Composite composite = new Composite(pageComposite, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)LayoutUtils.newCompositeGrid((int)2));
        Composite table = this.createTable(composite);
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        this.listButtons = new ButtonGroup<ResourceMapping>(composite){

            protected ResourceMapping edit1(ResourceMapping item, boolean newItem, Object parent) {
                EditMappingDialog dialog = new EditMappingDialog(this.getShell(), item, newItem);
                if (dialog.open() == 0) {
                    return dialog.getResult();
                }
                return null;
            }
        };
        this.listButtons.setLayoutData((Object)new GridData(4, 128, false, true));
        this.listButtons.addAddButton(null);
        this.listButtons.addCopyButton(null);
        this.listButtons.addEditButton(null);
        this.listButtons.addDeleteButton(null);
        this.listButtons.connectTo((StructuredViewer)this.listViewer, this.list, null);
        this.listViewer.setInput(this.list);
        ViewerUtils.scheduleStandardSelection((TableViewer)this.listViewer);
        IResourceMappingManager manager = ResourceMappingUtils.getManager();
        if (manager instanceof ResourceMappingManager) {
            this.manager = (ResourceMappingManager)manager;
        }
        if (this.manager != null) {
            this.list.addAll((Collection)this.manager.getList());
        } else {
            DialogUtils.setEnabled((Control)pageComposite, null, (boolean)false);
        }
        this.updateControls();
    }

    protected Composite createTable(Composite parent) {
        ViewerUtils.TableComposite composite = new ViewerUtils.TableComposite(parent, 67586);
        this.listViewer = composite.viewer;
        composite.table.setHeaderVisible(true);
        composite.table.setLinesVisible(true);
        TableViewerColumn column = new TableViewerColumn(composite.viewer, 0);
        composite.layout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(1));
        column.getColumn().setText("Local");
        column.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                IResourceMapping mapping = (IResourceMapping)cell.getElement();
                IFileStore fileStore = mapping.getFileStore();
                cell.setText(fileStore != null ? fileStore.toString() : "<invalid>");
            }
        });
        column = new TableViewerColumn(composite.viewer, 0);
        composite.layout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(1));
        column.getColumn().setText("Host");
        column.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                IResourceMapping mapping = (IResourceMapping)cell.getElement();
                cell.setText(mapping.getHost());
            }
        });
        column = new TableViewerColumn(composite.viewer, 0);
        composite.layout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(1));
        column.getColumn().setText("Remote");
        column.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                IResourceMapping mapping = (IResourceMapping)cell.getElement();
                IPath path = mapping.getRemotePath();
                cell.setText(path != null ? path.toString() : "<invalid>");
            }
        });
        composite.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        composite.viewer.setComparator((ViewerComparator)new ComparatorViewerComparator(ResourceMappingManager.DEFAULT_COMPARATOR));
        return composite;
    }

    protected void updateControls() {
        this.listButtons.refresh();
    }

    public void performDefaults() {
        if (this.list.isEmpty()) {
            return;
        }
        boolean deleteAll = MessageDialog.openQuestion((Shell)this.getShell(), (String)"Load Defaults", (String)"Delete all mappings?");
        if (deleteAll) {
            this.list.clear();
            this.updateControls();
        }
    }

    public boolean performOk(int flags) {
        if (this.manager != null) {
            this.manager.setMappings(this.list);
        }
        return true;
    }
}

