/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.IFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.docmlet.wikitext.core.markup.WikitextMarkupLanguage;
import org.eclipse.statet.docmlet.wikitext.core.markup.WikitextMarkupLanguageManager1;
import org.eclipse.statet.docmlet.wikitext.core.source.MarkupLanguageDocumentSetupParticipant;
import org.eclipse.statet.docmlet.wikitext.core.source.MarkupLanguagePartitioner;
import org.eclipse.statet.internal.docmlet.wikitext.core.WikitextCorePlugin;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImIdentityList;
import org.eclipse.statet.ltk.core.LTK;
import org.eclipse.statet.ltk.model.core.ISourceUnitManager;
import org.eclipse.statet.ltk.model.core.elements.ISourceUnit;
import org.eclipse.statet.ltk.model.core.elements.IWorkspaceSourceUnit;

public class MarkupConfigTextFileBufferUpdater
implements WikitextMarkupLanguageManager1.MarkupConfigChangedListener {
    private final WikitextMarkupLanguageManager1 markupLanguageManager;
    private final ITextFileBufferManager textFileBufferManager;
    private final ImIdentityList<String> markupModelTypeIds = ImCollections.newIdentityList((Object[])new String[]{"Wikidoc", "WikidocRweave"});
    private final List<String> checkPartitionings = new ArrayList<String>();

    public MarkupConfigTextFileBufferUpdater(WikitextMarkupLanguageManager1 markupLanguageManager) {
        this.markupLanguageManager = markupLanguageManager;
        this.textFileBufferManager = FileBuffers.getTextFileBufferManager();
    }

    @Override
    public void configChanged(Map<String, List<IProject>> languages, IProgressMonitor monitor) throws CoreException {
        SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (int)20);
        SubMonitor m1 = m.newChild(10).setWorkRemaining(12);
        IFileBuffer[] fileBuffers = this.textFileBufferManager.getFileBuffers();
        m.worked(1);
        this.checkFileBuffers(fileBuffers, languages, m1.newChild(8));
        fileBuffers = this.textFileBufferManager.getFileStoreFileBuffers();
        m.worked(1);
        this.checkFileBuffers(fileBuffers, languages, m1.newChild(2));
        m1 = m.newChild(10).setWorkRemaining(10);
        ISourceUnitManager suManager = LTK.getSourceUnitManager();
        List sus = suManager.getOpenSourceUnits(this.markupModelTypeIds, LTK.EDITOR_CONTEXT);
        m1.worked(1);
        m1.setWorkRemaining(sus.size());
        for (ISourceUnit su : sus) {
            this.checkEditSourceUnit(su, languages, m1.newChild(1));
        }
    }

    @Override
    public void configChanged(IFile file, IProgressMonitor monitor) throws CoreException {
        SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (int)20);
        SubMonitor m1 = m.newChild(10).setWorkRemaining(10);
        ITextFileBuffer fileBuffer = this.textFileBufferManager.getTextFileBuffer(file.getFullPath(), LocationKind.IFILE);
        if (fileBuffer != null) {
            this.checkFileBuffer(fileBuffer, file, null);
        }
        m1 = m.newChild(10).setWorkRemaining(10);
        ISourceUnitManager suManager = LTK.getSourceUnitManager();
        List sus = suManager.getOpenSourceUnits(this.markupModelTypeIds, LTK.EDITOR_CONTEXT, (Object)file);
        m1.worked(1);
        m1.setWorkRemaining(sus.size());
        for (ISourceUnit su : sus) {
            this.checkEditSourceUnit(su, null, m1.newChild(1));
        }
    }

    private AbstractDocument getDocument(ITextFileBuffer fileBuffer) {
        IDocument document = fileBuffer.getDocument();
        if (document instanceof AbstractDocument) {
            return (AbstractDocument)document;
        }
        return null;
    }

    private void checkFileBuffers(IFileBuffer[] fileBuffers, Map<String, List<IProject>> languages, SubMonitor m) {
        int i = 0;
        while (i < fileBuffers.length) {
            m.setWorkRemaining(fileBuffers.length - i);
            if (fileBuffers[i] instanceof ITextFileBuffer) {
                this.checkFileBuffer((ITextFileBuffer)fileBuffers[i], null, languages);
                m.worked(1);
            }
            ++i;
        }
    }

    private void checkFileBuffer(ITextFileBuffer fileBuffer, IFile file, Map<String, List<IProject>> languages) {
        AbstractDocument document = this.getDocument(fileBuffer);
        if (document == null) {
            return;
        }
        this.checkPartitionings.clear();
        String[] partitionings = document.getPartitionings();
        int i = 0;
        while (i < partitionings.length) {
            if (document.getDocumentPartitioner(partitionings[i]) instanceof MarkupLanguagePartitioner) {
                this.checkPartitionings.add(partitionings[i]);
            }
            ++i;
        }
        if (this.checkPartitionings.isEmpty()) {
            return;
        }
        if (file == null && fileBuffer.getLocation() != null) {
            file = FileBuffers.getWorkspaceFileAtLocation((IPath)fileBuffer.getLocation(), (boolean)true);
        }
        UpdateRunnable runnable = new UpdateRunnable(file, document, (List<String>)ImCollections.toList(this.checkPartitionings), languages);
        this.textFileBufferManager.execute((Runnable)runnable);
    }

    private void checkEditSourceUnit(ISourceUnit su, Map<String, List<IProject>> languages, SubMonitor m) {
        if (su.isConnected()) {
            su.connect((IProgressMonitor)m);
            try {
                if (su.getModelInfo(null, 0, (IProgressMonitor)m) == null) {
                    return;
                }
                AbstractDocument document = su.getDocument((IProgressMonitor)m);
                WikitextMarkupLanguage currentMarkupLanguage = MarkupLanguageDocumentSetupParticipant.getMarkupLanguage((IDocument)document, su.getDocumentContentInfo().getPartitioning());
                if (currentMarkupLanguage != null && languages != null) {
                    List<IProject> projects = languages.get(currentMarkupLanguage.getName());
                    if (projects == null) {
                        return;
                    }
                    if (!projects.isEmpty() && su instanceof IWorkspaceSourceUnit && !projects.contains(((IWorkspaceSourceUnit)su).getResource().getProject())) {
                        return;
                    }
                }
                su.getModelInfo(null, 0x3000000, (IProgressMonitor)m);
            }
            finally {
                su.disconnect((IProgressMonitor)m);
            }
        }
    }

    private class UpdateRunnable
    implements Runnable {
        private final IFile file;
        private final AbstractDocument document;
        private final List<String> partitionings;
        private final Map<String, List<IProject>> languages;

        public UpdateRunnable(IFile file, AbstractDocument document, List<String> partitionings, Map<String, List<IProject>> languages) {
            this.file = file;
            this.document = document;
            this.partitionings = partitionings;
            this.languages = languages;
        }

        @Override
        public void run() {
            for (String partitioning : this.partitionings) {
                IDocumentPartitioner partitioner = this.document.getDocumentPartitioner(partitioning);
                if (!(partitioner instanceof MarkupLanguagePartitioner)) continue;
                try {
                    MarkupLanguagePartitioner markupPartitioner = (MarkupLanguagePartitioner)partitioner;
                    WikitextMarkupLanguage currentMarkupLanguage = markupPartitioner.getMarkupLanguage();
                    if (this.languages != null && !this.languages.containsKey(currentMarkupLanguage.getName())) continue;
                    WikitextMarkupLanguage newMarkupLanguage = null;
                    newMarkupLanguage = this.file != null ? MarkupConfigTextFileBufferUpdater.this.markupLanguageManager.getLanguage(this.file, currentMarkupLanguage.getName(), true) : MarkupConfigTextFileBufferUpdater.this.markupLanguageManager.getLanguage(currentMarkupLanguage.getName());
                    if (newMarkupLanguage == null) continue;
                    markupPartitioner.setMarkupLanguage(newMarkupLanguage);
                    this.document.setDocumentPartitioner(partitioning, partitioner);
                }
                catch (Exception e) {
                    WikitextCorePlugin.log((IStatus)new Status(4, "org.eclipse.statet.docmlet.wikitext.core", NLS.bind((String)"An error occurred when trying to update the markup configuration of the open document (partitioning= {0}).", (Object)partitioning), (Throwable)e));
                }
            }
        }
    }
}

