/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.content;

import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.ValueDiff;
import org.eclipse.statet.ecommons.ui.components.IIntValueListener;
import org.eclipse.statet.ecommons.ui.components.IntValueEvent;
import org.eclipse.statet.ecommons.ui.components.WaScale;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class IntValue2TextBinding
extends AbstractObservableValue
implements IIntValueListener,
Listener {
    private static IConverter gInt2TextConverter;
    private static IConverter gText2IntConverter;
    private final WaScale fIntWidget;
    private final int fIdx;
    private final Text fTextWidget;
    private boolean fIgnoreChanges;
    private int fLastValue;
    private String fLastText;
    private boolean fCorrect;
    private final IConverter fInt2TextConverter;
    private final IConverter fText2IntConverter;

    static {
        class Access
        extends UpdateValueStrategy {
            Access() {
            }

            public IConverter createConverter(Object fromType, Object toType) {
                return super.createConverter(fromType, toType);
            }
        }
        Access access = new Access();
        gInt2TextConverter = access.createConverter(Integer.TYPE, String.class);
        gText2IntConverter = access.createConverter(String.class, Integer.TYPE);
    }

    public IntValue2TextBinding(WaScale scale, int knobIdx, Text text) {
        this(scale, knobIdx, text, Realm.getDefault(), null, null);
    }

    public IntValue2TextBinding(WaScale scale, int knobIdx, Text text, Realm realm, IConverter int2textConverter, IConverter text2intConverter) {
        super(realm);
        if (scale == null) {
            throw new NullPointerException("scale");
        }
        if (text == null) {
            throw new NullPointerException("text");
        }
        this.fIntWidget = scale;
        this.fIdx = knobIdx;
        this.fTextWidget = text;
        scale.addValueListener(this);
        text.addListener(24, (Listener)this);
        text.addListener(16, (Listener)this);
        this.fLastText = this.fTextWidget.getText();
        if (int2textConverter != null) {
            if (!int2textConverter.getFromType().equals(Integer.TYPE) || !int2textConverter.getToType().equals(String.class)) {
                throw new IllegalArgumentException("int2TextConverter");
            }
        } else {
            int2textConverter = gInt2TextConverter;
        }
        this.fInt2TextConverter = int2textConverter;
        if (text2intConverter != null) {
            if (!text2intConverter.getFromType().equals(String.class) || !text2intConverter.getToType().equals(Integer.TYPE)) {
                throw new IllegalArgumentException("text2IntConverter");
            }
        } else {
            text2intConverter = gText2IntConverter;
        }
        this.fText2IntConverter = text2intConverter;
    }

    @Override
    public void valueAboutToChange(IntValueEvent event) {
        if (event.valueIdx != this.fIdx) {
            return;
        }
        event.newValue = this.checkValue(event.newValue);
    }

    @Override
    public void valueChanged(IntValueEvent event) {
        if (event.valueIdx != this.fIdx) {
            return;
        }
        this.setValue(this.checkValue(event.newValue), false);
    }

    protected void setValue(int value, boolean updateKnob) {
        if (this.fIgnoreChanges) {
            return;
        }
        this.fIgnoreChanges = true;
        try {
            String text = this.int2Text(value);
            this.fTextWidget.setText(text);
            if (updateKnob) {
                this.fIntWidget.setValue(this.fIdx, value);
            }
            this.fCorrect = false;
            this.setLast(value, text);
        }
        finally {
            this.fIgnoreChanges = false;
        }
    }

    protected void setLast(int value, String text) {
        ValueDiff diff = this.fLastValue != value ? Diffs.createValueDiff((Object)this.fLastValue, (Object)value) : null;
        this.fLastValue = value;
        this.fLastText = text;
        if (diff != null) {
            this.fireValueChange(diff);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleEvent(Event event) {
        switch (event.type) {
            case 24: {
                if (this.fIgnoreChanges) {
                    return;
                }
                this.fIgnoreChanges = true;
                try {
                    try {
                        String text = this.fTextWidget.getText();
                        int value = this.text2Int(text);
                        int validValue = this.checkValue(value);
                        this.fIntWidget.setValue(this.fIdx, validValue);
                        if (value == validValue) {
                            this.fCorrect = false;
                            this.setLast(value, text);
                            return;
                        }
                        this.fCorrect = true;
                        this.setLast(validValue, this.int2Text(validValue));
                        return;
                    }
                    catch (IllegalArgumentException e) {
                        this.fCorrect = true;
                        this.fIgnoreChanges = false;
                    }
                    return;
                }
                finally {
                    this.fIgnoreChanges = false;
                }
            }
            case 16: {
                try {
                    if (!this.fCorrect) return;
                    this.fTextWidget.setText(this.fLastText);
                    return;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                return;
            }
        }
    }

    protected int text2Int(String text) {
        return (Integer)this.fText2IntConverter.convert((Object)text);
    }

    protected String int2Text(int value) {
        return (String)this.fInt2TextConverter.convert((Object)value);
    }

    public void setValue(int value) {
        this.setValue(value, true);
    }

    protected int checkValue(int value) {
        return value;
    }

    public Object getValueType() {
        return this.fInt2TextConverter.getFromType();
    }

    protected void doSetValue(Object value) {
        this.setValue(value != null ? (Integer)value : 0, true);
    }

    protected Object doGetValue() {
        return this.fLastValue;
    }

    public static class LowerUpperGroup {
        private final WaScale fScale;
        private final IntValue2TextBinding fLower;
        private final IntValue2TextBinding fUpper;
        private int fMin;
        private int fMax;

        public LowerUpperGroup(WaScale scale, Text lowerText, Text upperText, Realm realm, IConverter int2textConverter, IConverter text2intConverter) {
            this.fScale = scale;
            this.fLower = new IntValue2TextBinding(scale, 0, lowerText, realm, int2textConverter, text2intConverter){

                @Override
                public int checkValue(int value) {
                    if (value > fUpper.fLastValue) {
                        value = fUpper.fLastValue;
                    }
                    return this.checkMinMax(value);
                }
            };
            this.fUpper = new IntValue2TextBinding(scale, 1, upperText, realm, int2textConverter, text2intConverter){

                @Override
                public int checkValue(int value) {
                    if (value < fLower.fLastValue) {
                        value = fLower.fLastValue;
                    }
                    return this.checkMinMax(value);
                }
            };
        }

        public IntValue2TextBinding getLower() {
            return this.fLower;
        }

        public IntValue2TextBinding getUpper() {
            return this.fUpper;
        }

        private int checkMinMax(int value) {
            if (value < this.fMin) {
                return this.fMin;
            }
            if (value > this.fMax) {
                return this.fMax;
            }
            return value;
        }

        public void setMinMax(int min, int max) {
            this.fMin = min;
            this.fMax = max;
            this.fScale.setMinimum(min);
            this.fScale.setMaximum(max);
            this.fScale.setPageIncrement(Math.max(10, (this.fScale.getMaximum() - this.fScale.getMinimum()) / 10));
            this.fLower.setValue(this.fLower.getValue());
            this.fUpper.setValue(this.fUpper.getValue());
        }
    }
}

