/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.painter.layer;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.statet.ecommons.waltable.NatTable;
import org.eclipse.statet.ecommons.waltable.config.IConfigRegistry;
import org.eclipse.statet.ecommons.waltable.coordinate.LRectangle;
import org.eclipse.statet.ecommons.waltable.layer.ILayer;
import org.eclipse.statet.ecommons.waltable.painter.IOverlayPainter;
import org.eclipse.statet.ecommons.waltable.painter.layer.ILayerPainter;
import org.eclipse.statet.ecommons.waltable.swt.SWTUtil;
import org.eclipse.statet.internal.ecommons.waltable.WaLTablePlugin;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class NatLayerPainter
implements ILayerPainter {
    private final NatTable natTable;

    public NatLayerPainter(NatTable natTable) {
        this.natTable = natTable;
    }

    @Override
    public void paintLayer(ILayer natLayer, GC gc, int xOffset, int yOffset, Rectangle pixelRectangle, IConfigRegistry configRegistry) {
        try {
            this.paintBackground(natLayer, gc, xOffset, yOffset, pixelRectangle, configRegistry);
            gc.setForeground(this.natTable.getForeground());
            Rectangle paintRectangle = pixelRectangle.intersection(SWTUtil.toSWT(new LRectangle(xOffset, yOffset, natLayer.getWidth(), natLayer.getHeight())));
            if (!paintRectangle.isEmpty()) {
                this.natTable.getLayer().getLayerPainter().paintLayer(natLayer, gc, xOffset, yOffset, paintRectangle, configRegistry);
            }
            this.paintOverlays(natLayer, gc, xOffset, yOffset, pixelRectangle, configRegistry);
        }
        catch (Exception e) {
            WaLTablePlugin.log((IStatus)new Status(4, "org.eclipse.statet.ecommons.waltable.core", "An error occurred while painting the table.", (Throwable)e));
        }
    }

    protected void paintBackground(ILayer natLayer, GC gc, long xOffset, long yOffset, Rectangle rectangle, IConfigRegistry configRegistry) {
        gc.setBackground(this.natTable.getBackground());
        gc.fillRectangle(rectangle);
    }

    protected void paintOverlays(ILayer natLayer, GC gc, long xOffset, long yOffset, Rectangle rectangle, IConfigRegistry configRegistry) {
        for (IOverlayPainter overlayPainter : this.natTable.getOverlayPainters()) {
            overlayPainter.paintOverlay(gc, this.natTable);
        }
    }

    @Override
    public LRectangle adjustCellBounds(long columnPosition, long rowPosition, LRectangle cellBounds) {
        ILayerPainter layerPainter = this.natTable.getLayer().getLayerPainter();
        return layerPainter.adjustCellBounds(columnPosition, rowPosition, cellBounds);
    }
}

