/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.core.model;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.statet.internal.r.core.RCorePlugin;
import org.eclipse.statet.internal.r.core.builder.RPkgData;
import org.eclipse.statet.internal.r.core.sourcemodel.RModelIndexOrder;
import org.eclipse.statet.internal.r.core.sourcemodel.RModelManager;
import org.eclipse.statet.ltk.model.core.impl.GenericResourceSourceUnit;
import org.eclipse.statet.r.core.RProject;
import org.eclipse.statet.r.core.model.IRModelInfo;
import org.eclipse.statet.r.core.model.IRSourceUnit;

public class RModelIndexUpdate
extends RModelIndexOrder {
    public RModelIndexUpdate(RProject rProject, List<String> modelTypeIds, boolean isFullBuild) {
        super(rProject, modelTypeIds, isFullBuild);
    }

    public void update(RPkgData pkgData) {
        this.pkgData = pkgData;
    }

    public void update(IRSourceUnit sourceUnit, IRModelInfo model) {
        RModelIndexOrder.Result result = this.createResult(sourceUnit, model);
        if (result != null) {
            this.updated.add(result);
        }
    }

    public void remove(IRSourceUnit sourceUnit) {
        if (!this.isFullBuild) {
            this.removed.add(sourceUnit.getId());
        }
    }

    public void remove(IFile file) {
        if (!this.isFullBuild) {
            this.removed.add(GenericResourceSourceUnit.createResourceId((IResource)file));
        }
    }

    public void submit(IProgressMonitor monitor) throws CoreException {
        RModelManager rManager = RCorePlugin.getInstance().getRModelManager();
        rManager.getIndex().update(this, monitor);
    }
}

