/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.core.source;

import org.eclipse.jface.text.IRegion;
import org.eclipse.statet.ecommons.text.BasicHeuristicTokenScanner;
import org.eclipse.statet.ecommons.text.core.sections.DocContentSections;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.r.core.rlang.RTokens;
import org.eclipse.statet.r.core.source.IRDocumentConstants;
import org.eclipse.statet.r.core.source.RChunkHeuristicTokenScanner;

@NonNullByDefault
public class RHeuristicTokenScanner
extends BasicHeuristicTokenScanner {
    public static final int CURLY_BRACKET_TYPE = 0;
    public static final int ROUND_BRACKET_TYPE = 1;
    public static final int SQUARE_BRACKET_TYPE = 2;

    public static int getBracketType(char c) {
        switch (c) {
            case '{': 
            case '}': {
                return 0;
            }
            case '(': 
            case ')': {
                return 1;
            }
            case '[': 
            case ']': {
                return 2;
            }
        }
        throw new IllegalArgumentException();
    }

    public static RHeuristicTokenScanner create(DocContentSections documentContentInfo) {
        return documentContentInfo.getPrimaryType() == "org.eclipse.statet.R" ? new RHeuristicTokenScanner(documentContentInfo) : new RChunkHeuristicTokenScanner(documentContentInfo);
    }

    protected RHeuristicTokenScanner(DocContentSections documentContentInfo) {
        super(documentContentInfo, IRDocumentConstants.R_DEFAULT_CONTENT_CONSTRAINT);
    }

    public @Nullable IRegion findRWord(int position, final boolean isDotSeparator, boolean allowEnd) {
        return this.findRegion(position, new BasicHeuristicTokenScanner.StopCondition(this){

            public boolean stop() {
                return RTokens.isRobustSeparator(RHeuristicTokenScanner.this.ch, isDotSeparator);
            }
        }, true);
    }

    public int[] computeBracketBalance(int backwardOffset, int forwardOffset, int[] initial, int searchType) {
        int[] compute = new int[3];
        BracketBalanceCondition condition = new BracketBalanceCondition();
        int breakType = -1;
        while (--backwardOffset >= 0) {
            if ((backwardOffset = this.scanBackward(backwardOffset, -1, (BasicHeuristicTokenScanner.StopCondition)condition)) == -1) break;
            if (condition.open) {
                int n = condition.type;
                compute[n] = compute[n] + 1;
                if (condition.type == searchType || compute[condition.type] <= 0) continue;
                breakType = condition.type;
                break;
            }
            int n = condition.type;
            compute[n] = compute[n] - 1;
        }
        int bound = this.getDocument().getLength();
        int i = 0;
        while (i < compute.length) {
            if (compute[i] < 0) {
                compute[i] = 0;
            }
            compute[i] = compute[i] + initial[i];
            ++i;
        }
        while (forwardOffset < bound) {
            if ((forwardOffset = this.scanForward(forwardOffset, bound, (BasicHeuristicTokenScanner.StopCondition)condition)) == -1) break;
            if (condition.open) {
                int n = condition.type;
                compute[n] = compute[n] + 1;
            } else {
                int n = condition.type;
                compute[n] = compute[n] - 1;
            }
            if (breakType >= 0 && compute[breakType] == 0) break;
            ++forwardOffset;
        }
        return compute;
    }

    private class BracketBalanceCondition
    extends BasicHeuristicTokenScanner.PartitionBasedCondition {
        private int type;
        private boolean open;

        private BracketBalanceCondition() {
            super((BasicHeuristicTokenScanner)RHeuristicTokenScanner.this);
        }

        protected boolean matchesChar() {
            switch (RHeuristicTokenScanner.this.ch) {
                case '{': {
                    this.type = 0;
                    this.open = true;
                    return true;
                }
                case '}': {
                    this.type = 0;
                    this.open = false;
                    return true;
                }
                case '(': {
                    this.type = 1;
                    this.open = true;
                    return true;
                }
                case ')': {
                    this.type = 1;
                    this.open = false;
                    this.open = false;
                    return true;
                }
                case '[': {
                    this.type = 2;
                    this.open = true;
                    return true;
                }
                case ']': {
                    this.type = 2;
                    this.open = false;
                    return true;
                }
            }
            return false;
        }
    }
}

