/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.core.source;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.statet.ecommons.text.CharacterScannerReader;
import org.eclipse.statet.ecommons.text.core.rules.BufferedDocumentScanner;
import org.eclipse.statet.ecommons.text.core.treepartitioner.TreePartitionNode;
import org.eclipse.statet.ecommons.text.core.treepartitioner.TreePartitionNodeScan;
import org.eclipse.statet.ecommons.text.core.treepartitioner.TreePartitionNodeScanner;
import org.eclipse.statet.ecommons.text.core.treepartitioner.TreePartitionNodeType;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.r.core.source.RPartitionNodeType;

public class RPartitionNodeScanner
implements TreePartitionNodeScanner {
    protected static final int S_DEFAULT = 0;
    protected static final int S_QUOTED_SYMBOL = 1;
    protected static final int S_INFIX_OPERATOR = 2;
    protected static final int S_STRING_S = 3;
    protected static final int S_STRING_D = 4;
    protected static final int S_COMMENT = 5;
    protected static final int S_ROXYGEN = 6;
    protected static final byte LAST_OTHER = 0;
    protected static final byte LAST_EOF = 1;
    protected static final byte LAST_NEWLINE = 2;
    private final boolean isRoxygenEnabled;
    protected final CharacterScannerReader reader = new CharacterScannerReader(new BufferedDocumentScanner(1024));
    private TreePartitionNodeScan scan;
    private TreePartitionNode rootNode;
    private TreePartitionNode node;
    private RPartitionNodeType type;
    protected byte last;

    /*
     * Unable to fully structure code
     */
    public static final @Nullable TreePartitionNode findRRootNode(@Nullable TreePartitionNode node) {
        while (true) {
            block3: {
                if (node == null) {
                    return null;
                }
                if (!(node.getType() instanceof RPartitionNodeType)) break block3;
                rNode = node;
                if (true) ** GOTO lbl12
            }
            node = node.getParent();
        }
        do {
            rNode = parentNode;
lbl12:
            // 2 sources

        } while ((parentNode = rNode.getParent()) != null && parentNode.getType() instanceof RPartitionNodeType);
        return rNode;
    }

    public RPartitionNodeScanner() {
        this.isRoxygenEnabled = true;
    }

    public int getRestartOffset(TreePartitionNode node, IDocument document, int offset) throws BadLocationException {
        return offset;
    }

    public RPartitionNodeType getDefaultRootType() {
        return RPartitionNodeType.DEFAULT_ROOT;
    }

    public void execute(TreePartitionNodeScan scan) {
        this.scan = scan;
        this.rootNode = null;
        this.node = null;
        this.setRange(scan.getStartOffset(), scan.getEndOffset());
        this.init();
        assert (this.rootNode != null && this.node != null);
        this.process();
    }

    protected final TreePartitionNodeScan getScan() {
        return this.scan;
    }

    protected void setRange(int startOffset, int endOffset) {
        this.reader.setRange(this.getScan().getDocument(), startOffset, endOffset - startOffset);
        this.updateLast();
    }

    protected void init() {
        TreePartitionNode beginNode = this.getScan().getBeginNode();
        if (beginNode.getType() instanceof RPartitionNodeType) {
            this.initNode(beginNode, (RPartitionNodeType)beginNode.getType());
        } else {
            this.node = beginNode;
            this.addNode(this.getDefaultRootType(), this.getScan().getStartOffset());
            this.rootNode = this.node;
        }
    }

    protected final TreePartitionNode getRootNode() {
        return this.rootNode;
    }

    private void updateLast() {
        if (this.reader.getOffset() > 0) {
            this.last = 0;
            try {
                char c = this.getScan().getDocument().getChar(this.reader.getOffset() - 1);
                switch (c) {
                    case '\n': 
                    case '\r': {
                        this.last = (byte)2;
                        break;
                    }
                }
            }
            catch (BadLocationException badLocationException) {}
        } else {
            this.last = (byte)2;
        }
    }

    protected final void initNode(TreePartitionNode node, RPartitionNodeType type) {
        if (this.node != null) {
            throw new IllegalStateException();
        }
        this.node = node;
        this.type = type;
        this.rootNode = RPartitionNodeScanner.findRRootNode(node);
    }

    protected final void addNode(RPartitionNodeType type, int offset) {
        this.node = this.scan.add((TreePartitionNodeType)type, this.node, offset, 0);
        this.type = type;
    }

    protected final TreePartitionNode getNode() {
        return this.node;
    }

    protected final void exitNode(int offset, int flags) {
        this.scan.expand(this.node, offset, flags, true);
        this.node = this.node.getParent();
        this.type = (RPartitionNodeType)this.node.getType();
    }

    protected final void exitNode() {
        this.node = this.node.getParent();
        this.type = (RPartitionNodeType)this.node.getType();
    }

    protected final void exitNodesTo(TreePartitionNode stopNode, int offset, int flags) {
        while (this.node != stopNode) {
            this.exitNode(offset, flags);
        }
    }

    private void process() {
        block12: while (true) {
            switch (this.last) {
                case 1: {
                    this.handleEOF(this.type);
                    return;
                }
                case 2: {
                    this.handleNewLine(this.type);
                    break;
                }
            }
            switch (this.type.getScannerState()) {
                case 0: {
                    this.processDefault();
                    continue block12;
                }
                case 1: {
                    this.processQuotedSymbol();
                    continue block12;
                }
                case 2: {
                    this.processInfixOperator();
                    continue block12;
                }
                case 3: {
                    this.processStringS();
                    continue block12;
                }
                case 4: {
                    this.processStringD();
                    continue block12;
                }
                case 5: 
                case 6: {
                    this.processComment();
                    continue block12;
                }
            }
            this.processExt(this.type);
        }
    }

    protected void processDefault() {
        while (true) {
            switch (this.reader.read()) {
                case -1: {
                    this.last = 1;
                    return;
                }
                case 13: {
                    this.reader.read('\n');
                    this.last = (byte)2;
                    return;
                }
                case 10: {
                    this.last = (byte)2;
                    return;
                }
                case 34: {
                    this.addNode(RPartitionNodeType.STRING_D, this.reader.getOffset() - 1);
                    this.last = 0;
                    return;
                }
                case 39: {
                    this.addNode(RPartitionNodeType.STRING_S, this.reader.getOffset() - 1);
                    this.last = 0;
                    return;
                }
                case 96: {
                    this.addNode(RPartitionNodeType.QUOTED_SYMBOL, this.reader.getOffset() - 1);
                    this.last = 0;
                    return;
                }
                case 35: {
                    if (this.isRoxygenEnabled && this.reader.read('\'')) {
                        this.addNode(RPartitionNodeType.ROXYGEN, this.reader.getOffset() - 2);
                        this.last = 0;
                        return;
                    }
                    this.addNode(RPartitionNodeType.COMMENT, this.reader.getOffset() - 1);
                    this.last = 0;
                    return;
                }
                case 37: {
                    this.addNode(RPartitionNodeType.INFIX_OPERATOR, this.reader.getOffset() - 1);
                    this.last = 0;
                    return;
                }
            }
        }
    }

    protected void processInfixOperator() {
        while (true) {
            switch (this.reader.read()) {
                case -1: {
                    this.exitNode(this.reader.getOffset(), 256);
                    this.last = 1;
                    return;
                }
                case 13: {
                    this.exitNode(this.reader.getOffset() - 1, 256);
                    this.reader.read('\n');
                    this.last = (byte)2;
                    return;
                }
                case 10: {
                    this.exitNode(this.reader.getOffset() - 1, 256);
                    this.last = (byte)2;
                    return;
                }
                case 37: {
                    this.exitNode(this.reader.getOffset(), 0);
                    this.last = 0;
                    return;
                }
            }
        }
    }

    private void processBackslash() {
        this.last = 0;
        switch (this.reader.read()) {
            case -1: {
                return;
            }
            case 10: 
            case 13: {
                this.reader.unread();
                return;
            }
        }
    }

    protected void processQuotedSymbol() {
        block7: while (true) {
            switch (this.reader.read()) {
                case -1: {
                    this.exitNode(this.reader.getOffset(), 256);
                    this.last = 1;
                    return;
                }
                case 13: {
                    this.reader.read('\n');
                    this.last = (byte)2;
                    return;
                }
                case 10: {
                    this.last = (byte)2;
                    return;
                }
                case 92: {
                    this.processBackslash();
                    continue block7;
                }
                case 96: {
                    this.exitNode(this.reader.getOffset(), 0);
                    this.last = 0;
                    return;
                }
            }
        }
    }

    protected void processStringD() {
        block7: while (true) {
            switch (this.reader.read()) {
                case -1: {
                    this.exitNode(this.reader.getOffset(), 256);
                    this.last = 1;
                    return;
                }
                case 13: {
                    this.reader.read('\n');
                    this.last = (byte)2;
                    return;
                }
                case 10: {
                    this.last = (byte)2;
                    return;
                }
                case 92: {
                    this.processBackslash();
                    continue block7;
                }
                case 34: {
                    this.exitNode(this.reader.getOffset(), 0);
                    this.last = 0;
                    return;
                }
            }
        }
    }

    protected void processStringS() {
        block7: while (true) {
            switch (this.reader.read()) {
                case -1: {
                    this.exitNode(this.reader.getOffset(), 256);
                    this.last = 1;
                    return;
                }
                case 13: {
                    this.reader.read('\n');
                    this.last = (byte)2;
                    return;
                }
                case 10: {
                    this.last = (byte)2;
                    return;
                }
                case 92: {
                    this.processBackslash();
                    continue block7;
                }
                case 39: {
                    this.exitNode(this.reader.getOffset(), 0);
                    this.last = 0;
                    return;
                }
            }
        }
    }

    protected void processComment() {
        while (true) {
            switch (this.reader.read()) {
                case -1: {
                    this.exitNode(this.reader.getOffset(), 0);
                    this.last = 1;
                    return;
                }
                case 13: {
                    this.exitNode(this.reader.getOffset() - 1, 0);
                    this.reader.read('\n');
                    this.last = (byte)2;
                    return;
                }
                case 10: {
                    this.exitNode(this.reader.getOffset() - 1, 0);
                    this.last = (byte)2;
                    return;
                }
            }
        }
    }

    protected void processExt(RPartitionNodeType type) {
        throw new IllegalStateException("state= " + type.getScannerState());
    }

    protected void handleNewLine(RPartitionNodeType type) {
    }

    protected void handleEOF(RPartitionNodeType type) {
        TreePartitionNode rootNode = this.getRootNode();
        int offset = this.reader.getOffset();
        this.exitNodesTo(rootNode, offset, 256);
        this.scan.expand(rootNode, offset, 256, true);
    }
}

