/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.server.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.runtime.CommonsRuntime;
import org.eclipse.statet.jcommons.runtime.bundle.BundleEntry;
import org.eclipse.statet.jcommons.runtime.bundle.BundleSpec;
import org.eclipse.statet.rj.data.RObject;
import org.eclipse.statet.rj.server.RjsStatus;
import org.eclipse.statet.rj.server.util.RJContext;

@NonNullByDefault
public class ServerUtils {
    public static final String JCOMMONS_UTIL_ID = "org.eclipse.statet.jcommons.util";
    public static final BundleSpec JCOMMONS_UTIL_SPEC = new BundleSpec("org.eclipse.statet.jcommons.util", CommonsRuntime.class);
    public static final String RJ_DATA_ID = "org.eclipse.statet.rj.data";
    public static final BundleSpec RJ_DATA_SPEC = new BundleSpec("org.eclipse.statet.rj.data", RObject.class);
    public static final String RJ_SERVER_ID = "org.eclipse.statet.rj.server";
    public static final BundleSpec RJ_SERVER_SPEC = new BundleSpec("org.eclipse.statet.rj.server", RJContext.class);
    public static final ImList<BundleSpec> MIN_CLASSPATH_SPECS = ImCollections.newList((Object[])new BundleSpec[]{JCOMMONS_UTIL_SPEC, RJ_DATA_SPEC, RJ_SERVER_SPEC});
    public static final ImList<BundleSpec> MIN_RMI_CODEBASE_SPECS = ImCollections.newList((Object)RJ_SERVER_SPEC);
    public static final int[] RJ_VERSION;
    public static final RjsStatus MISSING_ANSWER_STATUS;

    static {
        int[] nArray = new int[3];
        nArray[0] = 4;
        RJ_VERSION = nArray;
        MISSING_ANSWER_STATUS = new RjsStatus(4, 121, "Server error (missing answer).");
    }

    public static ArgKeyValue getArgSubValue(@Nullable String arg) {
        if (arg != null && arg.length() > 0) {
            int idx = arg.indexOf(58);
            if (idx >= 0) {
                return new ArgKeyValue(arg.substring(0, idx), arg.substring(idx + 1));
            }
            return new ArgKeyValue(arg, null);
        }
        return new ArgKeyValue("", null);
    }

    public static ArgKeyValue getArgConfigValue(@Nullable String arg) {
        if (arg != null && arg.length() > 0) {
            int idx = arg.indexOf(61);
            if (idx >= 0) {
                return new ArgKeyValue(arg.substring(0, idx), arg.substring(idx + 1));
            }
            return new ArgKeyValue(arg, null);
        }
        return new ArgKeyValue("", null);
    }

    public static List<String> getArgValueList(@Nullable String arg) {
        if (arg != null && arg.length() > 0) {
            return Arrays.asList(arg.split(","));
        }
        return Collections.emptyList();
    }

    public static void prettyPrint(Map map, StringBuilder sb) {
        String sep = String.valueOf(System.getProperty("line.separator")) + "\t";
        Set entrySet = map.entrySet();
        for (Map.Entry entry : entrySet) {
            sb.append(sep);
            sb.append(entry.getKey());
            sb.append('=');
            Object value = entry.getValue();
            if (value == null) continue;
            sb.append(value);
        }
    }

    public static void prettyPrint(Collection<?> list, StringBuilder sb) {
        String sep = String.valueOf(System.getProperty("line.separator")) + "\t";
        for (Object value : list) {
            sb.append(sep);
            if (value == null) continue;
            sb.append(value);
        }
    }

    public static void prettyPrintVersion(int[] version, StringBuilder sb) {
        if (version == null || version.length == 0) {
            sb.append("<missing>");
        } else {
            sb.append(version[0]);
            int i = 1;
            while (i < version.length) {
                sb.append('.');
                sb.append(version[i]);
                ++i;
            }
        }
    }

    public static String concatJClassPath(Collection<BundleEntry> entries) {
        if (entries.isEmpty()) {
            return "";
        }
        ArrayList<String> uniqueStrings = new ArrayList<String>(entries.size());
        StringBuilder sb = new StringBuilder();
        for (BundleEntry entry : entries) {
            String s = entry.getJClassPathString();
            if (uniqueStrings.contains(s)) continue;
            uniqueStrings.add(s);
            sb.append(s);
            sb.append(File.pathSeparatorChar);
        }
        return sb.substring(0, sb.length() - 1);
    }

    public static String concatRJClassPath(Collection<BundleEntry> entries) {
        if (entries.isEmpty()) {
            return "";
        }
        ArrayList<String> uniqueStrings = new ArrayList<String>(entries.size());
        StringBuilder sb = new StringBuilder();
        for (BundleEntry entry : entries) {
            String s = entry.getJClassPathUrlString();
            if (uniqueStrings.contains(s)) continue;
            uniqueStrings.add(s);
            sb.append(s);
            sb.append(":,:");
        }
        return sb.substring(0, sb.length() - ":,:".length());
    }

    public static String concatCodebase(Collection<BundleEntry> entries) {
        if (entries.isEmpty()) {
            return "";
        }
        ArrayList uniqueStrings = new ArrayList(entries.size());
        StringBuilder sb = new StringBuilder();
        for (BundleEntry entry : entries) {
            String s = entry.getCodebaseString();
            if (s == null || uniqueStrings.contains(s)) continue;
            sb.append(s);
            sb.append(' ');
        }
        return sb.substring(0, sb.length() - 1);
    }

    public static boolean delDir(File dir) {
        String[] children;
        String[] stringArray = children = dir.list();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            String child = stringArray[n2];
            File file = new File(dir, child);
            if (file.isDirectory()) {
                ServerUtils.delDir(file);
            } else {
                file.delete();
            }
            ++n2;
        }
        return dir.delete();
    }

    public static void cleanDir(File dir, String exclude) {
        String[] children;
        String[] stringArray = children = dir.list();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            String child = stringArray[n2];
            if (!child.equals(exclude)) {
                File file = new File(dir, child);
                if (file.isDirectory()) {
                    ServerUtils.delDir(file);
                } else {
                    file.delete();
                }
            }
            ++n2;
        }
    }

    public static class ArgKeyValue {
        private final String key;
        private final @Nullable String value;

        public ArgKeyValue(String key, @Nullable String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public @Nullable String getValue() {
            return this.value;
        }
    }
}

