/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.core.rsource.ast;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.ast.core.AstVisitor;
import org.eclipse.statet.r.core.rlang.RTerminal;
import org.eclipse.statet.r.core.rsource.ast.Expression;
import org.eclipse.statet.r.core.rsource.ast.NodeType;
import org.eclipse.statet.r.core.rsource.ast.RAstNode;
import org.eclipse.statet.r.core.rsource.ast.RAstVisitor;
import org.eclipse.statet.r.core.rsource.ast.Symbol;

@NonNullByDefault
public final class CForLoop
extends RAstNode {
    Symbol varSymbol;
    int condOpenOffset = Integer.MIN_VALUE;
    int inOffset = Integer.MIN_VALUE;
    final Expression condExpr = new Expression();
    int condCloseOffset = Integer.MIN_VALUE;
    final Expression loopExpr = new Expression();

    CForLoop() {
    }

    @Override
    public final NodeType getNodeType() {
        return NodeType.C_FOR;
    }

    @Override
    public final RTerminal getOperator(int index) {
        return RTerminal.FOR;
    }

    @Override
    public final boolean hasChildren() {
        return true;
    }

    @Override
    public final int getChildCount() {
        return 3;
    }

    @Override
    public final RAstNode getChild(int index) {
        switch (index) {
            case 0: {
                return this.varSymbol;
            }
            case 1: {
                return this.condExpr.node;
            }
            case 2: {
                return this.loopExpr.node;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final RAstNode[] getChildren() {
        return new RAstNode[]{this.varSymbol, this.condExpr.node, this.loopExpr.node};
    }

    @Override
    public final int getChildIndex(AstNode child) {
        if (this.varSymbol == child) {
            return 0;
        }
        if (this.condExpr.node == child) {
            return 1;
        }
        if (this.loopExpr.node == child) {
            return 2;
        }
        return -1;
    }

    public final int getCondOpenOffset() {
        return this.condOpenOffset;
    }

    public final Symbol getVarChild() {
        return this.varSymbol;
    }

    public final RAstNode getCondChild() {
        return this.condExpr.node;
    }

    public final int getCondCloseOffset() {
        return this.condCloseOffset;
    }

    public final RAstNode getContChild() {
        return this.loopExpr.node;
    }

    @Override
    public final void acceptInR(RAstVisitor visitor) throws InvocationTargetException {
        visitor.visit(this);
    }

    @Override
    public final void acceptInRChildren(RAstVisitor visitor) throws InvocationTargetException {
        this.varSymbol.acceptInR(visitor);
        this.condExpr.node.acceptInR(visitor);
        this.loopExpr.node.acceptInR(visitor);
    }

    public final void acceptInChildren(AstVisitor visitor) throws InvocationTargetException {
        visitor.visit((AstNode)this.varSymbol);
        visitor.visit((AstNode)this.condExpr.node);
        visitor.visit((AstNode)this.loopExpr.node);
    }

    @Override
    final @Nullable Expression getExpr(RAstNode child) {
        if (this.loopExpr.node == child) {
            return this.loopExpr;
        }
        if (this.condExpr.node == child) {
            return this.condExpr;
        }
        return null;
    }

    @Override
    final @Nullable Expression getLeftExpr() {
        return null;
    }

    @Override
    final Expression getRightExpr() {
        return this.loopExpr;
    }

    @Override
    public final boolean equalsSingle(RAstNode element) {
        return NodeType.C_FOR == element.getNodeType();
    }

    @Override
    final int getMissingExprStatus(Expression expr) {
        if (this.condExpr == expr) {
            return 70483;
        }
        if (this.loopExpr == expr) {
            return 70499;
        }
        throw new IllegalArgumentException();
    }

    @Override
    final void updateEndOffset() {
        this.endOffset = this.loopExpr.node != null ? this.loopExpr.node.endOffset : (this.condCloseOffset != Integer.MIN_VALUE ? this.condCloseOffset + 1 : (this.condExpr.node != null ? this.condExpr.node.endOffset : (this.inOffset != Integer.MIN_VALUE ? this.inOffset + 2 : (this.varSymbol != null ? this.varSymbol.endOffset : (this.condOpenOffset != Integer.MIN_VALUE ? this.condOpenOffset + 1 : this.startOffset + 3)))));
    }
}

