/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.ProcessingContext;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.text.core.BasicTextRegion;

@NonNullByDefault
public final class PotentialBracketRegex {
    private static final String D_QUOTED_TITLE_REGEX = "\"(?:\\\\.|[^\"])*\"";
    private static final String S_QUOTED_TITLE_REGEX = "'(?:\\\\.|[^'])*'";
    private static final String PARENS_TITLE_REGEX = "\\((?:\\\\.|[^\\)])*\\)";
    static final String TITLE_REGEX = "\"(?:\\\\.|[^\"])*\"|'(?:\\\\.|[^'])*'|\\((?:\\\\.|[^\\)])*\\)";
    private static final Pattern END_PATTERN = Pattern.compile("(?:\\s+(\"(?:\\\\.|[^\"])*\"|'(?:\\\\.|[^'])*'|\\((?:\\\\.|[^\\)])*\\)))?\\s*(\\)).*", 32);
    private static final Pattern REFERENCE_DEFINITION_END_PATTERN = Pattern.compile("(?:\\s+(\"(?:\\\\.|[^\"])*\"|'(?:\\\\.|[^'])*'|\\((?:\\\\.|[^\\)])*\\))[ \t]*(?=\n|$))?[ \t]*(\n|$).*", 32);
    private static final String REFERENCE_NAME_REGEX = "(?:\\\\.|[^\\]]){0,1000}";
    private static final Pattern REFERENCE_LABEL_PATTERN = Pattern.compile("(\\[((?:\\\\.|[^\\]]){0,1000})\\]).*", 32);
    private static final Pattern REFERENCE_NAME_PATTERN = Pattern.compile("(?:\\\\.|[^\\]]){0,1000}", 32);
    private final Matcher endMatcher = END_PATTERN.matcher("");
    private final Matcher referenceDefinitionEndMatcher = REFERENCE_DEFINITION_END_PATTERN.matcher("");
    private final Matcher referenceLabelMatcher = REFERENCE_LABEL_PATTERN.matcher("");
    private final Matcher referenceNameMatcher = REFERENCE_NAME_PATTERN.matcher("");

    public Matcher getEndMatcher() {
        return this.endMatcher;
    }

    public Matcher getReferenceDefinitionEndMatcher() {
        return this.referenceDefinitionEndMatcher;
    }

    public Matcher getReferenceLabelMatcher() {
        return this.referenceLabelMatcher;
    }

    public Matcher getReferenceNameMatcher() {
        return this.referenceNameMatcher;
    }

    /*
     * Unable to fully structure code
     */
    public @Nullable LinkDestination readLinkDestination(ProcessingContext context, String text, int offset) {
        block23: {
            beginOffset = offset;
            helper = context.getHelper();
            while (offset < text.length() && helper.isWhitespace(text.charAt(offset))) {
                ++offset;
            }
            if (offset >= text.length()) break block23;
            if (text.charAt(offset) == '<') {
                linkBeginOffset = ++offset;
                while (offset < text.length()) {
                    switch (text.charAt(offset)) {
                        case '\n': 
                        case '\r': 
                        case ' ': {
                            return null;
                        }
                        case '\\': {
                            if (++offset < text.length()) {
                                switch (text.charAt(offset)) {
                                    case '\n': 
                                    case '\r': 
                                    case ' ': {
                                        return null;
                                    }
                                }
                                break;
                            }
                        }
                        case '<': {
                            return null;
                        }
                        case '>': {
                            return new LinkDestination(beginOffset, offset + 1, text.substring(linkBeginOffset, offset));
                        }
                    }
                    ++offset;
                }
                return null;
            }
            linkBeginOffset = offset;
            bracketLevels = 0;
            block20: while (offset < text.length()) {
                switch (text.charAt(offset)) {
                    case '\u0000': 
                    case '\u0001': 
                    case '\u0002': 
                    case '\u0003': 
                    case '\u0004': 
                    case '\u0005': 
                    case '\u0006': 
                    case '\u0007': 
                    case '\b': 
                    case '\t': 
                    case '\n': 
                    case '\u000b': 
                    case '\f': 
                    case '\r': 
                    case '\u000e': 
                    case '\u000f': 
                    case '\u0010': 
                    case '\u0011': 
                    case '\u0012': 
                    case '\u0013': 
                    case '\u0014': 
                    case '\u0015': 
                    case '\u0016': 
                    case '\u0017': 
                    case '\u0018': 
                    case '\u0019': 
                    case '\u001a': 
                    case '\u001b': 
                    case '\u001c': 
                    case '\u001d': 
                    case '\u001e': 
                    case '\u001f': 
                    case ' ': {
                        break block20;
                    }
                    case '\\': {
                        if (++offset >= text.length()) ** GOTO lbl38
                        switch (text.charAt(offset)) {
                            case '\u0000': 
                            case '\u0001': 
                            case '\u0002': 
                            case '\u0003': 
                            case '\u0004': 
                            case '\u0005': 
                            case '\u0006': 
                            case '\u0007': 
                            case '\b': 
                            case '\t': 
                            case '\n': 
                            case '\u000b': 
                            case '\f': 
                            case '\r': 
                            case '\u000e': 
                            case '\u000f': 
                            case '\u0010': 
                            case '\u0011': 
                            case '\u0012': 
                            case '\u0013': 
                            case '\u0014': 
                            case '\u0015': 
                            case '\u0016': 
                            case '\u0017': 
                            case '\u0018': 
                            case '\u0019': 
                            case '\u001a': 
                            case '\u001b': 
                            case '\u001c': 
                            case '\u001d': 
                            case '\u001e': 
                            case '\u001f': 
                            case ' ': {
                                return null;
                            }
                        }
                        ** GOTO lbl43
                    }
lbl38:
                    // 2 sources

                    case '(': {
                        ++bracketLevels;
                        ** GOTO lbl43
                    }
                    case ')': {
                        if (--bracketLevels < 0) break block20;
                    }
lbl43:
                    // 4 sources

                    default: {
                        ++offset;
                    }
                }
            }
            return new LinkDestination(beginOffset, offset, text.substring(linkBeginOffset, offset));
        }
        return null;
    }

    public static class LinkDestination
    extends BasicTextRegion {
        private final String escapedUri;

        public LinkDestination(int startOffset, int endOffset, String escapedUri) {
            super(startOffset, endOffset);
            this.escapedUri = escapedUri;
        }

        public String getEscapedUri() {
            return this.escapedUri;
        }
    }
}

