/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.core.style;

import java.util.List;
import org.eclipse.statet.ecommons.waltable.core.config.ConfigAttribute;
import org.eclipse.statet.ecommons.waltable.core.config.ConfigRegistry;
import org.eclipse.statet.ecommons.waltable.core.config.DisplayMode;
import org.eclipse.statet.ecommons.waltable.core.style.Style;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class RegistryStyle
implements Style {
    private final ConfigRegistry configRegistry;
    private final ConfigAttribute<Style> styleConfigAttribute;
    private final DisplayMode targetDisplayMode;
    private final List<String> configLabels;

    public RegistryStyle(ConfigRegistry configRegistry, ConfigAttribute<Style> styleConfigAttribute, DisplayMode targetDisplayMode, List<String> configLabels) {
        this.configRegistry = configRegistry;
        this.styleConfigAttribute = styleConfigAttribute;
        this.targetDisplayMode = targetDisplayMode;
        this.configLabels = configLabels;
    }

    @Override
    public <T> @Nullable T getAttributeValue(ConfigAttribute<T> configAttribute) {
        @Nullable T configAttributeValue = null;
        for (DisplayMode displayMode : this.configRegistry.getDisplayModeOrdering().getDisplayModeOrdering(this.targetDisplayMode)) {
            for (String configLabel : this.configLabels) {
                Style style = this.configRegistry.getSpecificAttribute(this.styleConfigAttribute, displayMode, configLabel);
                if (style == null || (configAttributeValue = (T)style.getAttributeValue(configAttribute)) == null) continue;
                return configAttributeValue;
            }
            Style cellStyle = this.configRegistry.getSpecificAttribute(this.styleConfigAttribute, displayMode, null);
            if (cellStyle == null || (configAttributeValue = (T)cellStyle.getAttributeValue(configAttribute)) == null) continue;
            return configAttributeValue;
        }
        return null;
    }

    @Override
    public <T> void setAttributeValue(ConfigAttribute<T> configAttribute, @Nullable T value) {
        throw new UnsupportedOperationException();
    }
}

