/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.net.core.ssh;

import java.nio.file.Path;
import java.time.Duration;
import org.eclipse.statet.jcommons.io.FileUtils;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.net.core.RSAccessClientSessionFactory;
import org.eclipse.statet.jcommons.net.core.RemoteTarget;
import org.eclipse.statet.jcommons.net.core.ssh.SshClientSession;
import org.eclipse.statet.jcommons.net.core.ssh.SshTarget;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.StatusException;

@NonNullByDefault
public abstract class BasicSshClientSessionFactory
implements RSAccessClientSessionFactory<SshClientSession> {
    private static final Duration SSH_TIMEOUT_DEFAULT;
    private final @Nullable Duration timeoutDefault = SSH_TIMEOUT_DEFAULT;

    static {
        Duration timeout = null;
        String value = System.getProperty("org.eclipse.statet.jcommons.net.core.ssh.Timeout.millis");
        if (value != null) {
            try {
                timeout = Duration.ofMillis(Integer.parseUnsignedInt(value));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (timeout == null) {
            timeout = Duration.ofSeconds(30L);
        }
        SSH_TIMEOUT_DEFAULT = timeout;
    }

    protected Path getUserHomeDirectory() {
        return FileUtils.getUserHomeDirectory();
    }

    @Override
    public SshClientSession createSession(RemoteTarget target, ProgressMonitor m) throws StatusException {
        ObjectUtils.nonNullAssert(target);
        if (!(target instanceof SshTarget)) {
            throw new IllegalArgumentException("targetType= " + target.getClass().getName());
        }
        SshTarget sshTarget = (SshTarget)target;
        return this.createSession(sshTarget, this.getTimeout(sshTarget), m);
    }

    protected @Nullable Duration getTimeout(SshTarget target) {
        return this.timeoutDefault;
    }

    protected abstract SshClientSession createSession(SshTarget var1, @Nullable Duration var2, ProgressMonitor var3) throws StatusException;
}

