/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.compare;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.contentmergeviewer.IIgnoreWhitespaceContributor;
import org.eclipse.compare.contentmergeviewer.TextMergeViewer;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.statet.ecommons.preferences.ui.SettingsUpdater;
import org.eclipse.statet.ecommons.text.PartitionerDocumentSetupParticipant;
import org.eclipse.statet.ecommons.text.core.PartitionConstraint;
import org.eclipse.statet.ecommons.ui.ISettingsChangedHandler;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.ui.compare.PartitionIgnoreSpaceContributor;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditorViewerConfigurator;
import org.eclipse.statet.ltk.ui.sourceediting.ViewerSourceEditorAdapter;
import org.eclipse.swt.widgets.Composite;

@NonNullByDefault
public abstract class CompareMergeTextViewer
extends TextMergeViewer {
    private final List<TextViewer> textViewers = new ArrayList<TextViewer>();
    private @Nullable PartitionerDocumentSetupParticipant documentSetupParticipant;

    public CompareMergeTextViewer(Composite parent, CompareConfiguration configuration) {
        super(parent, 0x2000000, configuration);
    }

    protected void setupDocument(IDocument document) {
        this.getDocumentSetupParticipant().setup(document);
    }

    protected final PartitionerDocumentSetupParticipant getDocumentSetupParticipant() {
        PartitionerDocumentSetupParticipant documentSetupParticipant = this.documentSetupParticipant;
        if (documentSetupParticipant == null) {
            this.documentSetupParticipant = documentSetupParticipant = this.createDocumentSetupParticipant();
        }
        return documentSetupParticipant;
    }

    protected abstract PartitionerDocumentSetupParticipant createDocumentSetupParticipant();

    protected Optional<IIgnoreWhitespaceContributor> createIgnoreWhitespaceContributor(IDocument document) {
        PartitionConstraint partitionConstraint;
        if (document instanceof IDocumentExtension3 && (partitionConstraint = this.getIgnoreWhitespaceExcludePartitionConstraint()) != null) {
            return Optional.of(new PartitionIgnoreSpaceContributor(document, this.getDocumentSetupParticipant().getPartitioningId(), partitionConstraint));
        }
        return Optional.empty();
    }

    protected @Nullable PartitionConstraint getIgnoreWhitespaceExcludePartitionConstraint() {
        return null;
    }

    protected abstract SourceEditorViewerConfigurator createConfigurator(SourceViewer var1);

    protected void configureTextViewer(TextViewer textViewer) {
        if (textViewer instanceof SourceViewer) {
            SourceViewer sourceViewer = (SourceViewer)textViewer;
            SourceEditorViewerConfigurator configurator = this.createConfigurator(sourceViewer);
            configurator.setTarget(new ViewerSourceEditorAdapter(sourceViewer, configurator));
            new SettingsUpdater((ISettingsChangedHandler)configurator, sourceViewer.getControl());
        } else {
            super.configureTextViewer(textViewer);
        }
        this.textViewers.add(textViewer);
    }
}

