/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting;

import java.util.ArrayList;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.statet.jcommons.collections.CopyOnWriteIdentityListSet;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor;
import org.eclipse.ui.texteditor.IUpdate;

public class StructureSelectionHistory {
    private final SourceEditor sourceEditor;
    private final ArrayList<IRegion> history = new ArrayList();
    private final ISelectionChangedListener selectionListener;
    private int selectionChangeListenerCounter;
    private final CopyOnWriteIdentityListSet<IUpdate> updateActions = new CopyOnWriteIdentityListSet();

    public StructureSelectionHistory(SourceEditor editor) {
        this.sourceEditor = editor;
        this.selectionListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (StructureSelectionHistory.this.selectionChangeListenerCounter == 0) {
                    StructureSelectionHistory.this.flush();
                }
            }
        };
        this.sourceEditor.getViewer().getSelectionProvider().addSelectionChangedListener(this.selectionListener);
    }

    public void addUpdateListener(IUpdate action) {
        this.updateActions.add((Object)((IUpdate)ObjectUtils.nonNullAssert((Object)action)));
    }

    private final void updateState() {
        for (IUpdate action : this.updateActions.toList()) {
            action.update();
        }
    }

    public boolean isEmpty() {
        return this.history.isEmpty();
    }

    public void remember(IRegion range) {
        this.history.add(range);
        this.updateState();
    }

    public IRegion getLast() {
        if (this.isEmpty()) {
            return null;
        }
        IRegion result = this.history.removeLast();
        this.updateState();
        return result;
    }

    public void flush() {
        if (this.history.isEmpty()) {
            return;
        }
        this.history.clear();
        this.updateState();
    }

    public void ignoreSelectionChanges() {
        ++this.selectionChangeListenerCounter;
    }

    public void listenToSelectionChanges() {
        --this.selectionChangeListenerCounter;
    }

    public void dispose() {
        this.sourceEditor.getViewer().getSelectionProvider().removeSelectionChangedListener(this.selectionListener);
    }
}

