/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting.assist;

import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.quickassist.IQuickAssistAssistant;
import org.eclipse.statet.ecommons.preferences.core.EPreferences;
import org.eclipse.statet.ecommons.preferences.core.Preference;
import org.eclipse.statet.ecommons.preferences.core.PreferenceAccess;
import org.eclipse.statet.ecommons.preferences.ui.RGBPref;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.ltk.ui.LtkUIPreferences;
import org.eclipse.statet.ltk.ui.sourceediting.assist.ContentAssist;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

@NonNullByDefault
public class AssistPreferences {
    private static final Preference.BooleanPref CONTENT_ASSIST_AUTO_ACTIVATION_ENABLED_PREF = new Preference.BooleanPref("org.eclipse.statet.ltk.ui/assist", "ContentAssist.AutoActivation.enabled");
    private final String qualifier;
    private final Preference.BooleanPref autoActivationEnabled;
    private final Preference.IntPref autoActivationDelay;
    private final Preference<Boolean> showSubstringMatches;
    private final Preference.BooleanPref autoInsertSingle;
    private final Preference.BooleanPref autoInsertPrefix;
    private final RGBPref informationBackground;
    private final RGBPref informationForeground;

    public AssistPreferences(String prefQualifier) {
        this.qualifier = prefQualifier;
        this.autoActivationEnabled = CONTENT_ASSIST_AUTO_ACTIVATION_ENABLED_PREF;
        this.autoActivationDelay = LtkUIPreferences.CONTENT_ASSIST_AUTO_ACTIVATION_DELAY_PREF;
        this.showSubstringMatches = LtkUIPreferences.CONTENT_ASSIST_SHOW_SUBSTRING_MATCHES_ENABLED_PREF;
        this.autoInsertSingle = new Preference.BooleanPref(prefQualifier, "AutoInsert.Single.enable");
        this.autoInsertPrefix = new Preference.BooleanPref(prefQualifier, "AutoInsert.Prefix.enable");
        this.informationBackground = LtkUIPreferences.CONTEXT_INFO_BACKGROUND_COLOR_PREF;
        this.informationForeground = LtkUIPreferences.CONTEXT_INFO_FOREGROUND_COLOR_PREF;
    }

    public String getGroupId() {
        return this.qualifier;
    }

    public Preference.BooleanPref getAutoActivationEnabledPref() {
        return this.autoActivationEnabled;
    }

    public Preference<Boolean> getShowSubstringMatchesPref() {
        return this.showSubstringMatches;
    }

    public Preference.BooleanPref getAutoInsertSinglePref() {
        return this.autoInsertSingle;
    }

    public Preference.BooleanPref getAutoInsertPrefixPref() {
        return this.autoInsertPrefix;
    }

    public void configure(ContentAssistant assistant) {
        PreferenceAccess prefs = EPreferences.getInstancePrefs();
        assistant.enableAutoActivation(((Boolean)prefs.getPreferenceValue((Preference)this.autoActivationEnabled)).booleanValue());
        assistant.setAutoActivationDelay(((Integer)prefs.getPreferenceValue((Preference)this.autoActivationDelay)).intValue());
        assistant.enableAutoInsert(((Boolean)prefs.getPreferenceValue((Preference)this.autoInsertSingle)).booleanValue());
        assistant.enablePrefixCompletion(((Boolean)prefs.getPreferenceValue((Preference)this.autoInsertPrefix)).booleanValue());
        Color color = new Color((RGB)prefs.getPreferenceValue((Preference)this.informationForeground));
        assistant.setContextInformationPopupForeground(color);
        assistant.setContextSelectorForeground(color);
        color = new Color((RGB)prefs.getPreferenceValue((Preference)this.informationBackground));
        assistant.setContextInformationPopupBackground(color);
        assistant.setContextSelectorBackground(color);
        if (assistant instanceof ContentAssist) {
            ContentAssist assist = (ContentAssist)assistant;
            assist.setShowSubstringMatches((Boolean)prefs.getPreferenceValue(this.showSubstringMatches));
        }
    }

    public void configure(IQuickAssistAssistant assistant) {
    }
}

