/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting.assist;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension5;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension6;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.statet.ecommons.text.ui.DefaultBrowserInformationInput;
import org.eclipse.statet.ecommons.ui.workbench.WorkbenchUIUtils;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.text.core.BasicTextRegion;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.ui.sourceediting.CommandAccess;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistInvocationContext;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistProposal;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

@NonNullByDefault
public abstract class BasicAssistProposal<TContext extends AssistInvocationContext>
implements AssistProposal,
CommandAccess,
ICompletionProposalExtension5,
ICompletionProposalExtension6 {
    private final TContext context;
    private final String commandId;
    private final String label;
    private final @Nullable String description;
    private final int relevance;
    private @Nullable ApplyData applyData;

    protected static StyledString addAcceleratorStyled(String message, @Nullable KeySequence binding) {
        StyledString styledString = new StyledString(message);
        if (binding != null) {
            styledString.append(" (", StyledString.QUALIFIER_STYLER);
            styledString.append(binding.format(), StyledString.QUALIFIER_STYLER);
            styledString.append(')', StyledString.QUALIFIER_STYLER);
        }
        return styledString;
    }

    public BasicAssistProposal(ProposalParameters<TContext> parameters) {
        this.context = parameters.context;
        this.commandId = parameters.commandId;
        this.label = parameters.label;
        this.description = parameters.description;
        this.relevance = parameters.relevance;
    }

    protected BasicAssistProposal(TContext invocationContext, String commandId, String label, @Nullable String description) {
        this.context = (AssistInvocationContext)ObjectUtils.nonNullAssert(invocationContext);
        this.commandId = (String)ObjectUtils.nonNullAssert((Object)commandId);
        this.label = label;
        this.description = description;
        this.relevance = 0;
    }

    @Override
    public final String getCommandId() {
        return this.commandId;
    }

    protected final TContext getInvocationContext() {
        return this.context;
    }

    protected final ApplyData getApplyData() {
        ApplyData applyData = this.applyData;
        if (applyData == null) {
            this.applyData = applyData = this.createApplyData();
        }
        return applyData;
    }

    protected ApplyData createApplyData() {
        return new ApplyData();
    }

    @Override
    public int getRelevance() {
        return this.relevance;
    }

    @Override
    public String getSortingString() {
        return this.label;
    }

    public @Nullable Image getImage() {
        return null;
    }

    public String getDisplayString() {
        return this.label;
    }

    public StyledString getStyledDisplayString() {
        return BasicAssistProposal.addAcceleratorStyled(this.getDisplayString(), this.commandId != "NO_COMMAND" ? WorkbenchUIUtils.getBestKeyBinding((String)this.commandId) : null);
    }

    public boolean validate(IDocument document, int offset, @Nullable DocumentEvent event) {
        return false;
    }

    public @Nullable String getAdditionalProposalInfo() {
        return this.description;
    }

    public @Nullable Object getAdditionalProposalInfo(IProgressMonitor monitor) {
        String description = this.description;
        if (description == null) {
            return null;
        }
        return new DefaultBrowserInformationInput(this.getDisplayString(), description, 1);
    }

    @Override
    public void apply(IDocument document) {
        throw new UnsupportedOperationException();
    }

    public @Nullable Point getSelection(IDocument document) {
        TextRegion selection;
        ApplyData applyData = this.applyData;
        if (applyData != null && (selection = applyData.getSelection()) != null) {
            return new Point(selection.getStartOffset(), selection.getLength());
        }
        return null;
    }

    public @Nullable IContextInformation getContextInformation() {
        return null;
    }

    protected static class ApplyData {
        private @Nullable TextRegion selectionToSet;
        private @Nullable IContextInformation contextInformation;

        public void setSelection(TextRegion region) {
            this.selectionToSet = region;
        }

        public void setSelection(int offset) {
            this.selectionToSet = new BasicTextRegion(offset, offset);
        }

        public void setSelection(int offset, int length) {
            assert (length >= 0);
            this.selectionToSet = new BasicTextRegion(offset, offset + length);
        }

        public void clearSelection() {
            this.selectionToSet = null;
        }

        public @Nullable TextRegion getSelection() {
            return this.selectionToSet;
        }

        public void setContextInformation(IContextInformation info) {
            this.contextInformation = info;
        }

        public @Nullable IContextInformation getContextInformation() {
            return this.contextInformation;
        }
    }

    public static class ProposalParameters<TContext extends AssistInvocationContext> {
        public final TContext context;
        public final String commandId;
        public final String label;
        public final @Nullable String description;
        public int relevance;

        public ProposalParameters(TContext context, String commandId, String label, @Nullable String description, int relevance) {
            this.context = (AssistInvocationContext)ObjectUtils.nonNullAssert(context);
            this.commandId = (String)ObjectUtils.nonNullAssert((Object)commandId);
            this.label = (String)ObjectUtils.nonNullAssert((Object)label);
            this.description = description;
            this.relevance = relevance;
        }
    }
}

