/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting.assist;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.ui.LtkUI;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.TextEditToolSynchronizer;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistInvocationContext;
import org.eclipse.statet.ltk.ui.sourceediting.assist.BasicAssistProposal;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;

@NonNullByDefault
public abstract class LinkedNamesAssistProposal<TContext extends AssistInvocationContext>
extends BasicAssistProposal<TContext> {
    private @Nullable String valueSuggestion;

    public LinkedNamesAssistProposal(BasicAssistProposal.ProposalParameters<TContext> parameters) {
        super(parameters);
    }

    @Override
    public Image getImage() {
        return LtkUI.getUIResources().getImage("org.eclipse.statet.ltk/images/tool/assist-LinkedRename");
    }

    @Override
    public boolean validate(IDocument document, int offset, @Nullable DocumentEvent event) {
        return false;
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        try {
            TextEditToolSynchronizer synchronizer;
            Point selection = viewer.getSelectedRange();
            int selectionStartOffset = selection.x;
            int selectionEndOffset = selection.x + selection.y;
            IDocument document = viewer.getDocument();
            if (document == null) {
                return;
            }
            LinkedModeModel model = new LinkedModeModel();
            LinkedPositionGroup group = new LinkedPositionGroup();
            this.collectPositions(document, group);
            if (group.isEmpty()) {
                return;
            }
            model.addGroup(group);
            model.forceInstall();
            SourceEditor editor = ((AssistInvocationContext)this.getInvocationContext()).getEditor();
            if (editor != null && (synchronizer = editor.getTextEditToolSynchronizer()) != null) {
                synchronizer.install(model);
            }
            EditorLinkedModeUI ui = new EditorLinkedModeUI(model, viewer);
            ui.setExitPolicy((LinkedModeUI.IExitPolicy)new DeleteBlockingExitPolicy(document));
            ui.setExitPosition(viewer, offset, 0, -1);
            ui.enter();
            String valueSuggestion = this.valueSuggestion;
            LinkedPosition position0 = group.getPositions()[0];
            if (valueSuggestion != null) {
                document.replace(position0.getOffset(), position0.getLength(), valueSuggestion);
                selectionStartOffset = position0.getOffset();
                selectionEndOffset = selectionStartOffset + valueSuggestion.length();
            } else {
                int positionEndOffset = position0.getOffset() + position0.getLength();
                if (selectionStartOffset < position0.getOffset()) {
                    selectionStartOffset = position0.getOffset();
                } else if (selectionStartOffset > positionEndOffset) {
                    selectionStartOffset = positionEndOffset;
                }
                if (selectionEndOffset < selectionStartOffset) {
                    selectionEndOffset = selectionStartOffset;
                } else if (selectionEndOffset > positionEndOffset) {
                    selectionEndOffset = positionEndOffset;
                }
            }
            viewer.setSelectedRange(selectionStartOffset, selectionEndOffset - selectionStartOffset);
        }
        catch (BadLocationException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.ltk.ui", -1, "Error initializing linked rename.", (Throwable)e));
        }
    }

    protected abstract void collectPositions(IDocument var1, LinkedPositionGroup var2) throws BadLocationException;

    protected int addPosition(LinkedPositionGroup group, IDocument document, @Nullable Position position, int idx) throws BadLocationException {
        if (position != null) {
            group.addPosition(new LinkedPosition(document, position.getOffset(), position.getLength(), idx));
            return idx + 1;
        }
        return idx;
    }

    protected int addPosition(LinkedPositionGroup group, IDocument document, @Nullable TextRegion position, int idx) throws BadLocationException {
        if (position != null) {
            group.addPosition(new LinkedPosition(document, position.getStartOffset(), position.getLength(), idx));
            return idx + 1;
        }
        return idx;
    }

    public static class DeleteBlockingExitPolicy
    implements LinkedModeUI.IExitPolicy {
        private final IDocument document;

        public DeleteBlockingExitPolicy(IDocument document) {
            this.document = document;
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
         @Nullable LinkedModeUI.ExitFlags doExit(LinkedModeModel model, VerifyEvent event, int offset, int length) {
            switch (event.character) {
                case '\b': {
                    LinkedPosition position = model.findPosition(new LinkedPosition(this.document, offset, 0, -1));
                    if (position != null && offset <= position.getOffset() && length == 0) {
                        event.doit = false;
                    }
                    return null;
                }
                case '\u007f': {
                    LinkedPosition position = model.findPosition(new LinkedPosition(this.document, offset, 0, -1));
                    if (position != null && offset >= position.getOffset() + position.getLength() && length == 0) {
                        event.doit = false;
                    }
                    return null;
                }
            }
            return null;
        }
    }
}

