/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.nico.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.statet.ecommons.ts.ui.workbench.WorkbenchToolRegistryListener;
import org.eclipse.statet.ecommons.ts.ui.workbench.WorkbenchToolSessionData;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.internal.nico.ui.NicoUIPlugin;
import org.eclipse.statet.internal.nico.ui.ToolRegistry;
import org.eclipse.statet.jcommons.collections.CopyOnWriteIdentityListSet;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.ts.core.ActiveToolListener;
import org.eclipse.statet.jcommons.ts.core.Tool;
import org.eclipse.statet.jcommons.ts.core.ToolProvider;
import org.eclipse.statet.nico.core.runtime.ToolProcess;
import org.eclipse.statet.nico.ui.NicoUITools;
import org.eclipse.statet.nico.ui.console.NIConsole;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.progress.WorkbenchJob;
import org.eclipse.ui.statushandlers.StatusManager;

@NonNullByDefault
class PageRegistry
implements IDebugEventSetListener,
IDebugContextListener,
ToolProvider {
    static final String SHOW_CONSOLE_JOB_NAME = "Show NIConsole";
    private final IWorkbenchPage page;
    private boolean isClosed;
    private @Nullable ToolProcess activeProcess;
    private @Nullable NIConsole activeConsole;
    private final CopyOnWriteIdentityListSet<Object> listeners;
    private final ShowConsoleViewJob showConsoleViewJob = new ShowConsoleViewJob(100);
    private final OnConsoleChangedJob consoleUpdateJob = new OnConsoleChangedJob();
    private final OnToolTerminatedJob terminatedJob = new OnToolTerminatedJob();

    PageRegistry(IWorkbenchPage page, Set<WorkbenchToolRegistryListener> initial) {
        this.page = page;
        this.listeners = new CopyOnWriteIdentityListSet(initial);
        DebugUITools.getDebugContextManager().getContextService(this.page.getWorkbenchWindow()).addDebugContextListener((IDebugContextListener)this);
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
    }

    public synchronized void dispose() {
        this.isClosed = true;
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
        DebugUITools.getDebugContextManager().getContextService(this.page.getWorkbenchWindow()).removeDebugContextListener((IDebugContextListener)this);
        this.showConsoleViewJob.cancel();
        this.consoleUpdateJob.cancel();
        this.terminatedJob.cancel();
        this.listeners.clear();
        this.activeProcess = null;
        this.activeConsole = null;
    }

    public void debugContextChanged(DebugContextEvent event) {
        IStructuredSelection sel;
        ISelection selection = event.getContext();
        if (selection instanceof IStructuredSelection && (sel = (IStructuredSelection)selection).size() == 1) {
            NIConsole console;
            IProcess process;
            Object element = sel.getFirstElement();
            ToolProcess tool = null;
            if (element instanceof IAdaptable && (process = (IProcess)((IAdaptable)element).getAdapter(IProcess.class)) instanceof ToolProcess) {
                tool = (ToolProcess)process;
            }
            if (tool == null && element instanceof ILaunch) {
                IProcess[] processes = ((ILaunch)element).getProcesses();
                int i = 0;
                while (i < processes.length) {
                    if (processes[i] instanceof ToolProcess) {
                        tool = (ToolProcess)processes[i];
                        break;
                    }
                    ++i;
                }
            }
            if (tool != null && (console = NicoUITools.getConsole(tool)) != null) {
                this.showConsole(console, false);
            }
        }
    }

    public void handleDebugEvents(@NonNull DebugEvent[] events) {
        ToolProcess tool = this.activeProcess;
        if (tool == null) {
            return;
        }
        DebugEvent[] debugEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            DebugEvent event = debugEventArray[n2];
            if (event.getSource() == tool && event.getKind() == 8) {
                this.terminatedJob.scheduleTerminated(tool);
            }
            ++n2;
        }
    }

    void addListener(WorkbenchToolRegistryListener listener) {
        this.listeners.add((Object)listener);
        if (this.isClosed) {
            this.listeners.clear();
        }
    }

    void removeListener(WorkbenchToolRegistryListener listener) {
        this.listeners.remove((Object)listener);
    }

    public IWorkbenchPage getPage() {
        return this.page;
    }

    public synchronized @Nullable ToolProcess getActiveProcess() {
        return this.activeProcess;
    }

    public synchronized WorkbenchToolSessionData createSessionInfo() {
        return new WorkbenchToolSessionData((Tool)this.activeProcess, (Object)this.activeConsole, this.page, null);
    }

    public @Nullable IConsoleView getConsoleView(NIConsole console) {
        if (this.isClosed) {
            return null;
        }
        return this.searchView(console);
    }

    void handleConsolesRemoved(List<ToolProcess> tools) {
        this.consoleUpdateJob.scheduleRemoved(tools);
    }

    void handleActiveConsoleChanged(NIConsole console, @Nullable IViewPart source) {
        this.consoleUpdateJob.scheduleActivated((NIConsole)((Object)ObjectUtils.nonNullAssert((Object)((Object)console))), source);
    }

    void showConsole(NIConsole console, boolean activate) {
        this.showConsoleViewJob.schedule((NIConsole)((Object)ObjectUtils.nonNullAssert((Object)((Object)console))), activate);
    }

    void showConsoleExplicitly(NIConsole console, final boolean pin) {
        this.showConsoleViewJob.cancel();
        new ShowConsoleViewJob(this, 0){

            @Override
            protected void finish(IConsoleView view) {
                if (pin) {
                    view.setPinned(true);
                }
            }
        }.schedule(console, true);
    }

    private void notifyActiveToolSessionChanged(@Nullable IViewPart source) {
        WorkbenchToolSessionData sessionData = new WorkbenchToolSessionData((Tool)this.activeProcess, (Object)this.activeConsole, this.page, source);
        if (ToolRegistry.DEBUG) {
            System.out.println("[tool registry] tool session activated: " + sessionData.toString());
        }
        ActiveToolListener.ActiveToolEvent toolEvent = new ActiveToolListener.ActiveToolEvent(1, sessionData.getTool());
        for (Object listener : this.listeners) {
            try {
                if (listener instanceof WorkbenchToolRegistryListener) {
                    ((WorkbenchToolRegistryListener)listener).toolSessionActivated(sessionData);
                    continue;
                }
                if (!(listener instanceof ActiveToolListener)) continue;
                ((ActiveToolListener)listener).onToolChanged(toolEvent);
            }
            catch (Exception e) {
                StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.nico.ui", -1, "An error occurred when handling tool activation.", (Throwable)e));
            }
        }
    }

    private void notifyToolTerminated() {
        WorkbenchToolSessionData sessionData = new WorkbenchToolSessionData((Tool)this.activeProcess, (Object)this.activeConsole, this.page, null);
        if (ToolRegistry.DEBUG) {
            System.out.println("[tool registry] activate tool terminated: " + sessionData.toString());
        }
        ActiveToolListener.ActiveToolEvent toolEvent = new ActiveToolListener.ActiveToolEvent(2, sessionData.getTool());
        for (Object listener : this.listeners) {
            try {
                if (listener instanceof WorkbenchToolRegistryListener) {
                    ((WorkbenchToolRegistryListener)listener).toolTerminated(sessionData);
                    continue;
                }
                if (!(listener instanceof ActiveToolListener)) continue;
                ((ActiveToolListener)listener).onToolChanged(toolEvent);
            }
            catch (Exception e) {
                StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.nico.ui", -1, "An error occurred when handling tool termination.", (Throwable)e));
            }
        }
    }

    private List<IConsoleView> getConsoleViews() {
        IViewReference[] allReferences;
        ArrayList<IConsoleView> consoleViews = new ArrayList<IConsoleView>();
        IViewReference[] iViewReferenceArray = allReferences = this.page.getViewReferences();
        int n = allReferences.length;
        int n2 = 0;
        while (n2 < n) {
            IViewPart view;
            IViewReference reference = iViewReferenceArray[n2];
            if (reference.getId().equals("org.eclipse.ui.console.ConsoleView") && (view = reference.getView(true)) != null) {
                IConsoleView consoleView = (IConsoleView)view;
                if (!consoleView.isPinned()) {
                    consoleViews.add(consoleView);
                } else if (consoleView.getConsole() instanceof NIConsole) {
                    consoleViews.add(0, consoleView);
                }
            }
            ++n2;
        }
        return consoleViews;
    }

    private @Nullable NIConsole searchConsole(List<ToolProcess> exclude) {
        IConsole console;
        NIConsole nico = null;
        IWorkbenchPart part = this.page.getActivePart();
        if (part instanceof IConsoleView && (console = ((IConsoleView)part).getConsole()) instanceof NIConsole && !exclude.contains((nico = (NIConsole)console).getProcess())) {
            return nico;
        }
        List<IConsoleView> consoleViews = this.getConsoleViews();
        NIConsole secondChoice = null;
        for (IConsoleView view : consoleViews) {
            IConsole console2 = view.getConsole();
            if (!(console2 instanceof NIConsole) || exclude.contains((nico = (NIConsole)console2).getProcess())) continue;
            if (this.page.isPartVisible((IWorkbenchPart)view)) {
                return nico;
            }
            if (secondChoice != null) continue;
            secondChoice = nico;
        }
        return secondChoice;
    }

    private @Nullable IConsoleView searchView(NIConsole console) {
        List<IConsoleView> views = this.getConsoleViews();
        IConsoleView[] preferedView = new IConsoleView[10];
        for (IConsoleView view : views) {
            IConsole consoleInView = view.getConsole();
            if (consoleInView == console) {
                if (this.page.isPartVisible((IWorkbenchPart)view)) {
                    preferedView[view.isPinned() ? 0 : 1] = view;
                    continue;
                }
                preferedView[view.isPinned() ? 2 : 3] = view;
                continue;
            }
            if (consoleInView == null) {
                if (this.page.isPartVisible((IWorkbenchPart)view)) {
                    preferedView[4] = view;
                    continue;
                }
                preferedView[5] = view;
                continue;
            }
            if (view.isPinned()) continue;
            String secId = view.getViewSite().getSecondaryId();
            if (secId != null && secId.startsWith(console.getType())) {
                preferedView[6] = view;
                continue;
            }
            if (this.page.isPartVisible((IWorkbenchPart)view)) {
                preferedView[7] = view;
                continue;
            }
            preferedView[8] = view;
        }
        int i = 0;
        while (i < preferedView.length) {
            if (preferedView[i] != null) {
                return preferedView[i];
            }
            ++i;
        }
        return null;
    }

    public @Nullable Tool getTool() {
        return this.activeProcess;
    }

    public void addToolListener(ActiveToolListener listener) {
        this.listeners.add(ObjectUtils.nonNullAssert((Object)listener));
        if (this.isClosed) {
            this.listeners.clear();
        }
    }

    public void removeToolListener(ActiveToolListener listener) {
        this.listeners.remove((Object)listener);
    }

    private class OnConsoleChangedJob
    extends Job
    implements ISchedulingRule {
        private volatile @Nullable NIConsole console;
        private volatile @Nullable IViewPart source;
        private volatile @Nullable List<ToolProcess> exclude;

        public OnConsoleChangedJob() {
            super("NicoUI Registry - On Console Changed");
            this.setSystem(true);
            this.setPriority(20);
        }

        public boolean belongsTo(Object family) {
            return family == PageRegistry.this;
        }

        public boolean contains(ISchedulingRule rule) {
            return false;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            if (rule instanceof Job) {
                return ((Job)rule).belongsTo((Object)PageRegistry.this);
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void scheduleActivated(NIConsole console, @Nullable IViewPart source) {
            PageRegistry pageRegistry = PageRegistry.this;
            synchronized (pageRegistry) {
                List<ToolProcess> exclude = this.exclude;
                if (console != null && exclude != null && exclude.contains(console.getProcess())) {
                    return;
                }
                this.cancel();
                this.console = console;
                this.source = source;
                this.schedule(50L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void scheduleRemoved(List<ToolProcess> exclude) {
            PageRegistry pageRegistry = PageRegistry.this;
            synchronized (pageRegistry) {
                NIConsole console = this.console;
                if (console != null && exclude.contains(console.getProcess())) {
                    this.console = null;
                } else if (PageRegistry.this.activeProcess == null && !exclude.contains(PageRegistry.this.activeProcess)) {
                    return;
                }
                this.cancel();
                this.exclude = exclude;
                this.schedule(200L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            IViewPart source;
            if (PageRegistry.this.isClosed) {
                return Status.OK_STATUS;
            }
            NIConsole console = this.console;
            List<ToolProcess> exclude = this.exclude;
            if (console == null) {
                AtomicReference<@Nullable V> ref = new AtomicReference();
                UIAccess.getDisplay((Shell)PageRegistry.this.page.getWorkbenchWindow().getShell()).syncExec(() -> ref.set(PageRegistry.this.searchConsole(exclude != null ? exclude : Collections.emptyList())));
                console = (NIConsole)((Object)ref.get());
            }
            PageRegistry pageRegistry = PageRegistry.this;
            synchronized (pageRegistry) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                if (this.console == console) {
                    this.console = null;
                    this.exclude = null;
                }
                if (console == PageRegistry.this.activeConsole || console == null && PageRegistry.this.activeConsole == null) {
                    return Status.OK_STATUS;
                }
                PageRegistry.this.activeProcess = console != null ? console.getProcess() : null;
                PageRegistry.this.activeConsole = console;
                source = this.source;
            }
            PageRegistry.this.notifyActiveToolSessionChanged(source);
            return Status.OK_STATUS;
        }
    }

    private class OnToolTerminatedJob
    extends Job
    implements ISchedulingRule {
        private volatile @Nullable ToolProcess tool;

        public OnToolTerminatedJob() {
            super("NicoUI Registry - On Tool Terminated");
            this.setSystem(true);
            this.setPriority(20);
        }

        public boolean belongsTo(Object family) {
            return family == PageRegistry.this;
        }

        public boolean contains(ISchedulingRule rule) {
            return false;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            if (rule instanceof Job) {
                return ((Job)rule).belongsTo((Object)PageRegistry.this);
            }
            return false;
        }

        public void scheduleTerminated(ToolProcess tool) {
            this.tool = tool;
            this.schedule(0L);
        }

        public synchronized IStatus run(IProgressMonitor monitor) {
            ToolProcess tool = this.tool;
            this.tool = null;
            if (PageRegistry.this.getActiveProcess() == tool) {
                PageRegistry.this.notifyToolTerminated();
            }
            return Status.OK_STATUS;
        }
    }

    private class ShowConsoleViewJob
    extends WorkbenchJob {
        private final int delay;
        private volatile @Nullable NIConsole consoleToShow;
        private volatile boolean activate;

        public ShowConsoleViewJob(int delay) {
            super(PageRegistry.SHOW_CONSOLE_JOB_NAME);
            this.setSystem(true);
            this.setPriority(20);
            this.delay = delay;
        }

        public void schedule(NIConsole console, boolean activate) {
            this.cancel();
            this.consoleToShow = console;
            this.activate = activate;
            this.schedule(this.delay);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            NIConsole console = this.consoleToShow;
            if (PageRegistry.this.isClosed || console == null) {
                return Status.CANCEL_STATUS;
            }
            try {
                IWorkbenchPart activePart = PageRegistry.this.page.getActivePart();
                if (activePart instanceof IConsoleView && console == ((IConsoleView)activePart).getConsole()) {
                    ((IConsoleView)activePart).setFocus();
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                IConsoleView view = PageRegistry.this.searchView(console);
                IStatus iStatus = this.showInView(view, monitor);
                return iStatus;
            }
            catch (PartInitException e) {
                NicoUIPlugin.logError(100, "Error of unexpected type occured, when showing a console view.", e);
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            finally {
                this.consoleToShow = null;
            }
        }

        private IStatus showInView(@Nullable IConsoleView view, IProgressMonitor monitor) throws PartInitException {
            NIConsole console = this.consoleToShow;
            boolean activate = this.activate;
            if (console == null || PageRegistry.this.isClosed || monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            if (view == null) {
                String secId = console.getType() + System.currentTimeMillis();
                view = (IConsoleView)PageRegistry.this.page.showView("org.eclipse.ui.console.ConsoleView", secId, 3);
            }
            view.display((IConsole)console);
            if (activate) {
                PageRegistry.this.page.activate((IWorkbenchPart)view);
            } else {
                PageRegistry.this.page.bringToTop((IWorkbenchPart)view);
            }
            this.finish(view);
            return Status.OK_STATUS;
        }

        protected void finish(IConsoleView view) {
        }
    }
}

