/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.debug.core.model;

import org.eclipse.debug.core.DebugException;
import org.eclipse.statet.internal.r.debug.core.model.BasicRElementVariable;
import org.eclipse.statet.internal.r.debug.core.model.RElementVariableValue;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.r.core.data.CombinedRElement;
import org.eclipse.statet.r.core.model.RFunctionSpec;
import org.eclipse.statet.r.core.model.rlang.RLangMethod;

@NonNullByDefault
public class RFunctionValue
extends RElementVariableValue<CombinedRElement> {
    public RFunctionValue(BasicRElementVariable variable) {
        super(variable);
    }

    @Override
    public String getValueString() throws DebugException {
        if (this.element instanceof RLangMethod) {
            RLangMethod lang = (RLangMethod)this.element;
            StringBuilder sb = new StringBuilder();
            RFunctionSpec fSpec = lang.getFunctionSpec();
            sb.append("function(");
            if (fSpec == null) {
                sb.append("<unknown>");
            } else if (fSpec.getParamCount() > 0) {
                this.append(sb, fSpec.getParam(0));
                int i = 1;
                while (i < fSpec.getParamCount()) {
                    sb.append(", ");
                    this.append(sb, fSpec.getParam(i));
                    ++i;
                }
            }
            sb.append(")");
            return sb.toString();
        }
        return super.getValueString();
    }

    private void append(StringBuilder sb, RFunctionSpec.Parameter parameter) {
        String name = parameter.getName();
        if (name != null) {
            sb.append(name);
        }
    }
}

