/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.data.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.rj.data.RJIO;
import org.eclipse.statet.rj.data.impl.AbstractCharacterStore;
import org.eclipse.statet.rj.data.impl.ExternalizableRStore;

@NonNullByDefault
public class RCharacter32Utf8Store
extends AbstractCharacterStore
implements ExternalizableRStore,
Externalizable {
    private int length;
    private byte[] @Nullable [] charValues;

    public RCharacter32Utf8Store() {
        this.length = 0;
        this.charValues = EMPTY_BYTE_2dARRAY;
    }

    public RCharacter32Utf8Store(int length, byte @Nullable [] initialValue) {
        this.length = length;
        this.charValues = new byte[length][];
        if (initialValue != null) {
            Arrays.fill((Object[])this.charValues, initialValue);
        }
    }

    public RCharacter32Utf8Store(int length, @Nullable String initialValue) {
        this(length, initialValue != null ? initialValue.getBytes() : null);
    }

    public RCharacter32Utf8Store(int length) {
        this(length, EMPTY_BYTE_ARRAY);
    }

    protected RCharacter32Utf8Store(byte[] @Nullable [] charValues) {
        this.length = charValues.length;
        this.charValues = charValues;
    }

    public RCharacter32Utf8Store(@Nullable String[] values, int startIndex, int endIndex) {
        int length = endIndex - startIndex;
        byte[][] utf8Values = new byte[length][];
        int i = 0;
        while (i < length) {
            String s = values[i];
            if (s != null) {
                utf8Values[i] = s.getBytes(StandardCharsets.UTF_8);
            }
            ++i;
        }
        this.length = length;
        this.charValues = utf8Values;
    }

    public RCharacter32Utf8Store(@Nullable String[] values) {
        this(values, 0, values.length);
    }

    public RCharacter32Utf8Store(byte[] @Nullable [] values, int startIndex, int endIndex) {
        this.length = endIndex - startIndex;
        this.charValues = (byte[][])ObjectUtils.nonNullAssert((Object)values);
    }

    public RCharacter32Utf8Store(RJIO io, int length) throws IOException {
        this.length = length;
        this.charValues = new byte[length][];
        io.readStringDataUtf8(this.charValues, length);
    }

    @Override
    public void writeExternal(RJIO io) throws IOException {
        io.writeStringDataUtf8(this.charValues, this.length);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.length = in.readInt();
        this.charValues = new byte[this.length][];
        int i = 0;
        while (i < this.length) {
            int l = in.readInt();
            if (l >= 0) {
                char[] c = new char[l];
                int j = 0;
                while (j < l) {
                    c[j] = in.readChar();
                    ++j;
                }
                this.charValues[i] = new String(c).getBytes(StandardCharsets.UTF_8);
            }
            ++i;
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.length);
        int i = 0;
        while (i < this.length) {
            byte[] value = this.charValues[i];
            if (value != null) {
                String s = new String(value, StandardCharsets.UTF_8);
                out.writeInt(s.length());
                out.writeChars(s);
            } else {
                out.writeInt(-1);
            }
            ++i;
        }
    }

    protected final byte[] @Nullable [] getCharValuesUtf8Array() {
        return this.charValues;
    }

    @Override
    protected final boolean isStructOnly() {
        return false;
    }

    public final int length() {
        return this.length;
    }

    @Override
    public final long getLength() {
        return this.length;
    }

    @Override
    public boolean isNA(int idx) {
        return this.charValues[idx] == null;
    }

    @Override
    public boolean isNA(long idx) {
        if (idx < 0L || idx >= (long)this.length) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        return this.charValues[(int)idx] == null;
    }

    @Override
    public void setNA(int idx) {
        this.charValues[idx] = null;
    }

    @Override
    public void setNA(long idx) {
        if (idx < 0L || idx >= (long)this.length) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        this.charValues[(int)idx] = null;
    }

    @Override
    public boolean isMissing(int idx) {
        return this.charValues[idx] == null;
    }

    @Override
    public boolean isMissing(long idx) {
        if (idx < 0L || idx >= (long)this.length) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        return this.charValues[(int)idx] == null;
    }

    @Override
    public String getChar(int idx) {
        return new String(this.charValues[idx], StandardCharsets.UTF_8);
    }

    @Override
    public String getChar(long idx) {
        if (idx < 0L || idx >= (long)this.length) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        return new String(this.charValues[(int)idx], StandardCharsets.UTF_8);
    }

    @Override
    public void setChar(int idx, String value) {
        this.charValues[idx] = value.getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public void setChar(long idx, String value) {
        if (idx < 0L || idx >= (long)this.length) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        this.charValues[(int)idx] = value.getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public @Nullable String get(int idx) {
        if (idx < 0 || idx >= this.length) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        byte[] value = this.charValues[idx];
        return value != null ? new String(value, StandardCharsets.UTF_8) : null;
    }

    @Override
    public @Nullable String get(long idx) {
        if (idx < 0L || idx >= (long)this.length) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        byte[] value = this.charValues[(int)idx];
        return value != null ? new String(value, StandardCharsets.UTF_8) : null;
    }

    @Override
    public @Nullable String[] toArray() {
        int length = this.length;
        byte[][] values = this.charValues;
        String[] array = new String[length];
        int i = 0;
        while (i < length) {
            byte[] value = values[i];
            if (value != null) {
                array[i] = new String(value, StandardCharsets.UTF_8);
            }
            ++i;
        }
        return array;
    }

    @Override
    public long indexOfNA(long fromIdx) {
        if (fromIdx >= Integer.MAX_VALUE) {
            return -1L;
        }
        if (fromIdx < 0L) {
            fromIdx = 0L;
        }
        int l = this.length;
        byte[][] values = this.charValues;
        int i = (int)fromIdx;
        while (i < l) {
            if (values[i] == null) {
                return i;
            }
            ++i;
        }
        return -1L;
    }

    public int indexOfNA(int fromIdx) {
        if (fromIdx < 0) {
            fromIdx = 0;
        }
        int l = this.length;
        byte[][] values = this.charValues;
        int i = fromIdx;
        while (i < l) {
            if (values[i] == null) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public long indexOf(String character, long fromIdx) {
        int l = this.length;
        if (fromIdx >= (long)l) {
            return -1L;
        }
        if (fromIdx < 0L) {
            fromIdx = 0L;
        }
        byte[] bytes = character.getBytes(StandardCharsets.UTF_8);
        byte[][] values = this.charValues;
        int i = (int)fromIdx;
        while (i < l) {
            if (Arrays.equals(values[i], bytes)) {
                return i;
            }
            ++i;
        }
        return -1L;
    }

    public int indexOf(String character, int fromIdx) {
        int l = this.length;
        if (fromIdx >= l) {
            return -1;
        }
        if (fromIdx < 0) {
            fromIdx = 0;
        }
        byte[] bytes = character.getBytes(StandardCharsets.UTF_8);
        byte[][] values = this.charValues;
        while (fromIdx < l) {
            if (Arrays.equals(values[fromIdx], bytes)) {
                return fromIdx;
            }
            ++fromIdx;
        }
        return -1;
    }
}

