/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.selection.core;

import java.util.List;
import org.eclipse.statet.ecommons.waltable.core.command.AbstractLayerCommandHandler;
import org.eclipse.statet.ecommons.waltable.core.coordinate.LRange;
import org.eclipse.statet.ecommons.waltable.core.coordinate.LRangeList;
import org.eclipse.statet.ecommons.waltable.core.coordinate.LRectangle;
import org.eclipse.statet.ecommons.waltable.core.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.selection.core.DimSelectionEvent;
import org.eclipse.statet.ecommons.waltable.selection.core.SelectDimPositionsCommand;
import org.eclipse.statet.ecommons.waltable.selection.core.SelectionLayer;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;

@NonNullByDefault
public class SelectDimPositionsCommandHandler
extends AbstractLayerCommandHandler<SelectDimPositionsCommand> {
    private final SelectionLayer selectionLayer;

    public SelectDimPositionsCommandHandler(SelectionLayer selectionLayer) {
        this.selectionLayer = selectionLayer;
    }

    @Override
    public Class<SelectDimPositionsCommand> getCommandClass() {
        return SelectDimPositionsCommand.class;
    }

    @Override
    protected boolean doCommand(SelectDimPositionsCommand command) {
        if (command.getOrientation() == Orientation.HORIZONTAL) {
            this.toggleOrSelectColumn(LRangeList.toRangeList(command.getPositions()), command.getOrthogonalPosition(), command.getSelectionFlags(), command.getPositionToReveal());
        } else {
            this.toggleOrSelectRows(command.getOrthogonalPosition(), LRangeList.toRangeList(command.getPositions()), command.getSelectionFlags(), command.getPositionToReveal());
        }
        return true;
    }

    protected void toggleOrSelectColumn(LRangeList columnPositions, long rowPosition, int selectionFlags, long columnPositionToReveal) {
        long singleColumnPosition;
        if ((selectionFlags & 0x60000) == 262144 && columnPositions.values().size() == 1L && this.selectionLayer.isColumnPositionFullySelected(singleColumnPosition = columnPositions.values().first())) {
            LRectangle columnRegion = new LRectangle(singleColumnPosition, 0L, 1L, this.selectionLayer.getRowCount());
            this.selectionLayer.clearSelection(columnRegion);
            this.selectionLayer.fireLayerEvent(new DimSelectionEvent(this.selectionLayer, Orientation.HORIZONTAL, singleColumnPosition, columnPositionToReveal == singleColumnPosition));
            return;
        }
        this.selectColumn(columnPositions, rowPosition, selectionFlags, columnPositionToReveal);
    }

    protected void selectColumn(LRangeList columnPositions, long rowPosition, int selectionFlags, long columnPositionToReveal) {
        long rowCount = this.selectionLayer.getRowCount();
        long lastPosition = Long.MIN_VALUE;
        if ((selectionFlags & 0x60000) == 0) {
            this.selectionLayer.clearSelections();
        }
        if (!(columnPositions.isEmpty() || (selectionFlags & 0x20000) != 0 && columnPositions.values().size() > 1L)) {
            if (this.selectionLayer.getSelectionModel().isMultipleSelectionAllowed() && (selectionFlags & 0x20000) != 0 && this.selectionLayer.lastSelectedRegion != null && this.selectionLayer.selectionAnchor.columnPosition >= 0L) {
                if ((selectionFlags & 0x40000) != 0) {
                    this.selectionLayer.lastSelectedRegion = new LRectangle(0L, 0L, 0L, 0L);
                }
                long position = columnPositions.values().first();
                this.selectionLayer.lastSelectedRegion.x = Math.min(this.selectionLayer.selectionAnchor.columnPosition, position);
                this.selectionLayer.lastSelectedRegion.width = Math.abs(this.selectionLayer.selectionAnchor.columnPosition - position) + 1L;
                this.selectionLayer.lastSelectedRegion.y = 0L;
                this.selectionLayer.lastSelectedRegion.height = rowCount;
                lastPosition = position;
                this.selectionLayer.addSelection(this.selectionLayer.lastSelectedRegion);
            } else {
                for (LRange lRange : columnPositions) {
                    if (lRange.contains(columnPositionToReveal)) {
                        lastPosition = columnPositionToReveal;
                    }
                    this.selectionLayer.addSelection(new LRectangle(lRange.start, 0L, lRange.size(), rowCount));
                }
                if (lastPosition == Long.MIN_VALUE) {
                    lastPosition = columnPositions.values().last();
                }
                this.selectionLayer.selectionAnchor.columnPosition = lastPosition;
                this.selectionLayer.selectionAnchor.rowPosition = rowPosition;
            }
        }
        if (lastPosition >= 0L) {
            this.selectionLayer.lastSelectedCell.columnPosition = lastPosition;
            this.selectionLayer.lastSelectedCell.rowPosition = rowCount - 1L;
        }
        this.selectionLayer.fireLayerEvent(new DimSelectionEvent(this.selectionLayer, Orientation.HORIZONTAL, (List<LRange>)columnPositions, columnPositionToReveal));
    }

    protected void toggleOrSelectRows(long columnPosition, LRangeList rowPositions, int selectionFlags, long rowPositionToShow) {
        long singleRowPosition;
        if ((selectionFlags & 0x60000) == 262144 && rowPositions.values().size() == 1L && this.selectionLayer.isRowPositionFullySelected(singleRowPosition = rowPositions.values().first())) {
            LRectangle columnRegion = new LRectangle(0L, singleRowPosition, this.selectionLayer.getColumnCount(), 1L);
            this.selectionLayer.clearSelection(columnRegion);
            this.selectionLayer.fireLayerEvent(new DimSelectionEvent(this.selectionLayer, Orientation.VERTICAL, singleRowPosition, false));
            return;
        }
        this.selectRows(columnPosition, rowPositions, selectionFlags, rowPositionToShow);
    }

    protected void selectRows(long columnPosition, LRangeList rowPositions, int selectionFlags, long rowPositionToShow) {
        LRangeList changedRowRanges = new LRangeList();
        long columnCount = this.selectionLayer.getColumnCount();
        long lastPosition = Long.MIN_VALUE;
        if ((selectionFlags & 0x60000) == 0) {
            changedRowRanges.addAll(this.selectionLayer.getSelectedRowPositions());
            this.selectionLayer.clearSelections();
        }
        if (!(rowPositions.isEmpty() || (selectionFlags & 0x20000) != 0 && rowPositions.values().size() > 1L)) {
            if (this.selectionLayer.getSelectionModel().isMultipleSelectionAllowed() && (selectionFlags & 0x20000) != 0 && this.selectionLayer.lastSelectedRegion != null && this.selectionLayer.selectionAnchor.columnPosition >= 0L) {
                if ((selectionFlags & 0x40000) != 0) {
                    this.selectionLayer.lastSelectedRegion = new LRectangle(0L, 0L, 0L, 0L);
                }
                long position = rowPositions.values().first();
                this.selectionLayer.lastSelectedRegion.x = 0L;
                this.selectionLayer.lastSelectedRegion.width = columnCount;
                this.selectionLayer.lastSelectedRegion.y = Math.min(this.selectionLayer.selectionAnchor.rowPosition, position);
                this.selectionLayer.lastSelectedRegion.height = Math.abs(this.selectionLayer.selectionAnchor.rowPosition - position) + 1L;
                lastPosition = position;
                this.selectionLayer.addSelection(this.selectionLayer.lastSelectedRegion);
                changedRowRanges.add(new LRange(this.selectionLayer.lastSelectedRegion.y, this.selectionLayer.lastSelectedRegion.y + this.selectionLayer.lastSelectedRegion.height));
            } else {
                for (LRange lRange : rowPositions) {
                    if (lRange.contains(rowPositionToShow)) {
                        lastPosition = rowPositionToShow;
                    }
                    this.selectionLayer.addSelection(new LRectangle(0L, lRange.start, columnCount, lRange.size()));
                    changedRowRanges.add(lRange);
                }
                if (lastPosition == Long.MIN_VALUE) {
                    lastPosition = rowPositions.values().last();
                }
                this.selectionLayer.selectionAnchor.columnPosition = columnPosition;
                this.selectionLayer.selectionAnchor.rowPosition = lastPosition;
            }
        }
        if (lastPosition >= 0L) {
            this.selectionLayer.lastSelectedCell.columnPosition = columnCount - 1L;
            this.selectionLayer.lastSelectedCell.rowPosition = lastPosition;
        }
        this.selectionLayer.fireLayerEvent(new DimSelectionEvent(this.selectionLayer, Orientation.VERTICAL, (List<LRange>)changedRowRanges, rowPositionToShow));
    }
}

