/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.core.refactoring;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.statet.ecommons.text.IIndentSettings;
import org.eclipse.statet.ecommons.text.IndentUtil;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.jcommons.text.core.input.StringParserInput;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.r.core.RCodeStyleSettings;
import org.eclipse.statet.r.core.RCore;
import org.eclipse.statet.r.core.RCoreAccess;
import org.eclipse.statet.r.core.refactoring.RRefactoringAdapter;
import org.eclipse.statet.r.core.source.RTerminal;
import org.eclipse.statet.r.core.source.ast.Group;
import org.eclipse.statet.r.core.source.ast.NodeType;
import org.eclipse.statet.r.core.source.ast.RAstNode;
import org.eclipse.statet.r.core.source.ast.RParser;
import org.eclipse.statet.r.core.source.util.RHeuristicTokenScanner;
import org.eclipse.statet.r.core.source.util.RSourceIndenter;
import org.eclipse.statet.rj.util.RCodeBuilder;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

@NonNullByDefault
public final class RSourceCodeModifyUtil
extends RCodeBuilder {
    private final RRefactoringAdapter adapter;
    private final SourceUnit sourceUnit;
    private final RCoreAccess coreAccess;
    private final AbstractDocument sourceDocument;
    private final RCodeStyleSettings codeStyle;
    private final String lineSeparator;
    private @Nullable RHeuristicTokenScanner scanner;
    private @Nullable IndentUtil indentUtil;
    private @Nullable RSourceIndenter indenter;
    private final ArrayList<TextEdit> edits = new ArrayList();

    public RSourceCodeModifyUtil(RRefactoringAdapter adapter, SourceUnit sourceUnit, SubMonitor m) {
        this.adapter = adapter;
        this.sourceUnit = sourceUnit;
        this.coreAccess = RCore.getContextAccess((IAdaptable)sourceUnit);
        this.sourceDocument = sourceUnit.getDocument((IProgressMonitor)m);
        this.codeStyle = this.coreAccess.getRCodeStyle();
        this.lineSeparator = this.sourceDocument.getDefaultLineDelimiter();
    }

    public RCoreAccess getCoreAccess() {
        return this.coreAccess;
    }

    public AbstractDocument getSourceDocument() {
        return this.sourceDocument;
    }

    public RCodeStyleSettings getCodeStyle() {
        return this.codeStyle;
    }

    public RHeuristicTokenScanner getScanner() {
        RHeuristicTokenScanner scanner = this.scanner;
        if (scanner == null) {
            this.scanner = scanner = this.adapter.getScanner(this.sourceUnit);
        }
        scanner.configure((IDocument)this.sourceDocument);
        return scanner;
    }

    protected IndentUtil getIndentUtil() {
        IndentUtil indentUtil = this.indentUtil;
        if (indentUtil == null) {
            this.indentUtil = indentUtil = new IndentUtil((IDocument)this.sourceDocument, (IIndentSettings)this.codeStyle);
        }
        return indentUtil;
    }

    protected RSourceIndenter getSourceIndenter() {
        RSourceIndenter indenter = this.indenter;
        if (indenter == null) {
            this.indenter = indenter = new RSourceIndenter(this.getScanner(), this.coreAccess);
        }
        return indenter;
    }

    protected String getSource(int startOffset, int endOffset) throws BadLocationException {
        return this.sourceDocument.get(startOffset, endOffset - startOffset);
    }

    protected String getSource(TextRegion node) throws BadLocationException {
        return this.sourceDocument.get(node.getStartOffset(), node.getLength());
    }

    public RSourceCodeModifyUtil clear() {
        this.edits.clear();
        super.clear();
        return this;
    }

    public void clearCodeBuffer() {
        this.sb.setLength(0);
    }

    public void appendTrim(int startOffset, int endOffset) throws BadLocationException {
        RHeuristicTokenScanner scanner = this.getScanner();
        startOffset = scanner.expandAnyMSpaceForward(startOffset, endOffset);
        endOffset = scanner.expandAnyMSpaceBackward(endOffset, startOffset);
        this.sb.append(this.getSource(startOffset, endOffset));
    }

    public void appendTrim(TextRegion region) throws BadLocationException {
        this.appendTrim(region.getStartOffset(), region.getEndOffset());
    }

    public void appendUnwrapGroup(RAstNode node) throws BadLocationException {
        if (node.getNodeType() == NodeType.GROUP) {
            Group group = (Group)node;
            int closeOffset = group.getGroupCloseOffset();
            this.appendTrim(group.getStartOffset() + 1, closeOffset != Integer.MIN_VALUE ? closeOffset : group.getEndOffset());
        } else {
            this.appendTrim((TextRegion)node);
        }
    }

    public void appendLineSeparator() {
        this.sb.append(this.lineSeparator);
    }

    public void appendGroup(String code) {
        this.sb.append('(');
        this.append(code);
        this.sb.append(')');
    }

    public void appendGroup(RAstNode node) throws BadLocationException {
        this.sb.append('(');
        this.appendTrim((TextRegion)node);
        this.sb.append(')');
    }

    public void append(String code, boolean wrapInGroup) throws BadLocationException {
        if (wrapInGroup) {
            this.appendGroup(code);
        } else {
            this.append(code);
        }
    }

    public void append(RAstNode node, boolean wrapInGroup) throws BadLocationException {
        if (wrapInGroup) {
            this.appendGroup(node);
        } else {
            this.appendTrim((TextRegion)node);
        }
    }

    public void appendFDefBodyBlock(int startOffset, int endOffset) throws BadLocationException {
        if (this.codeStyle.getNewlineFDefBodyBlockBefore()) {
            this.sb.append(this.lineSeparator);
        } else {
            this.sb.append(' ');
        }
        this.sb.append('{');
        this.sb.append(this.lineSeparator);
        this.appendTrim(startOffset, endOffset);
        this.sb.append(this.lineSeparator);
        this.sb.append('}');
    }

    public void appendFlowControlBody(RAstNode node, boolean wrapInBlock) throws BadLocationException {
        if (wrapInBlock) {
            if (this.codeStyle.getNewlineFlowControlBodyBlockBefore()) {
                this.sb.append(this.lineSeparator);
            } else {
                this.sb.append(' ');
            }
            this.sb.append('{');
            this.sb.append(this.lineSeparator);
            this.appendUnwrapGroup(node);
            this.sb.append(this.lineSeparator);
            this.sb.append('}');
        } else {
            this.sb.append(' ');
            this.appendTrim((TextRegion)node);
        }
    }

    public void appendOperator(RTerminal op) {
        switch (op) {
            case ARROW_LEFT_S: {
                if (this.codeStyle.getWhitespaceAssignBefore()) {
                    this.sb.append(' ');
                }
                this.sb.append("<-");
                if (this.codeStyle.getWhitespaceAssignAfter()) {
                    this.sb.append(' ');
                }
                return;
            }
            case ARROW_LEFT_D: {
                if (this.codeStyle.getWhitespaceAssignBefore()) {
                    this.sb.append(' ');
                }
                this.sb.append("<<-");
                if (this.codeStyle.getWhitespaceAssignAfter()) {
                    this.sb.append(' ');
                }
                return;
            }
            case ARROW_RIGHT_S: {
                if (this.codeStyle.getWhitespaceAssignAfter()) {
                    this.sb.append(' ');
                }
                this.sb.append("->");
                if (this.codeStyle.getWhitespaceAssignBefore()) {
                    this.sb.append(' ');
                }
                return;
            }
            case ARROW_RIGHT_D: {
                if (this.codeStyle.getWhitespaceAssignAfter()) {
                    this.sb.append(' ');
                }
                this.sb.append("->>");
                if (this.codeStyle.getWhitespaceAssignBefore()) {
                    this.sb.append(' ');
                }
                return;
            }
            case PIPE_RIGHT: {
                if (this.codeStyle.getWhitespacePipeBefore()) {
                    this.sb.append(' ');
                }
                this.sb.append("|>");
                if (this.codeStyle.getWhitespacePipeAfter()) {
                    this.sb.append(' ');
                }
                return;
            }
        }
        this.appendOperator(op.text);
    }

    public void appendArgAssign() {
        this.append(this.codeStyle.getArgAssignString());
    }

    public void appendOperator(String s) {
        if (this.codeStyle.getWhitespaceOtherOpBefore()) {
            this.sb.append(' ');
        }
        this.sb.append(s);
        if (this.codeStyle.getWhitespaceOtherOpAfter()) {
            this.sb.append(' ');
        }
    }

    public int prepareInsertBefore(int offset) throws BadLocationException, CoreException {
        int line;
        IndentUtil indentUtil = this.getIndentUtil();
        int[] lineIndent = indentUtil.getLineIndent(line = this.sourceDocument.getLineOfOffset(offset), false);
        if (lineIndent[1] == offset) {
            this.sb.insert(0, indentUtil.createIndentString(lineIndent[0]));
            this.sb.append(this.lineSeparator);
            return this.sourceDocument.getLineOffset(line);
        }
        this.sb.append("; ");
        return offset;
    }

    public void correctIndent(int changeOffset, int baseOffset) throws BadLocationException, CoreException {
        IndentUtil indentUtil = this.getIndentUtil();
        int column = indentUtil.getColumn(baseOffset);
        String initialIndent = indentUtil.createIndentString(column);
        StringBuilder prefix = new StringBuilder();
        prefix.append(initialIndent).append("1").append(this.lineSeparator);
        int changeLine0 = 1;
        if (baseOffset < changeOffset) {
            prefix.append(initialIndent);
            prefix.append(this.sourceDocument.get(baseOffset, changeOffset - baseOffset));
            changeLine0 += this.sourceDocument.getNumberOfLines(baseOffset, changeOffset - baseOffset);
        }
        this.sb.insert(0, prefix);
        String text = this.sb.toString();
        Document tempDoc = new Document(text);
        StringParserInput parseInput = new StringParserInput(text);
        RParser rParser = new RParser(1);
        TextEdit edits = this.getSourceIndenter().getIndentEdits((AbstractDocument)tempDoc, rParser.parseSourceUnit(parseInput.init()), 0, changeLine0, tempDoc.getNumberOfLines() - 1);
        edits.apply((IDocument)tempDoc, 0);
        this.sb.replace(0, this.sb.length(), tempDoc.get(prefix.length(), tempDoc.getLength() - prefix.length()));
    }

    public void correctIndent(int changeOffset) throws BadLocationException, CoreException {
        this.correctIndent(changeOffset, changeOffset);
    }

    public InsertEdit createInsertEdit(int offset) {
        return new InsertEdit(offset, this.sb.toString());
    }

    public ReplaceEdit createReplaceEdit(int startOffset, int endOffset) {
        return new ReplaceEdit(startOffset, endOffset - startOffset, this.sb.toString());
    }

    public ReplaceEdit createReplaceEdit(TextRegion region) {
        return new ReplaceEdit(region.getStartOffset(), region.getLength(), this.sb.toString());
    }

    public DeleteEdit createDeleteEdit(int startOffset, int endOffset) {
        return new DeleteEdit(startOffset, endOffset - startOffset);
    }

    public DeleteEdit createDeleteEdit(TextRegion region) {
        return new DeleteEdit(region.getStartOffset(), region.getLength());
    }

    public void addInsertEdit(int offset) {
        this.edits.add((TextEdit)this.createInsertEdit(offset));
    }

    public void addReplaceEdit(int startOffset, int endOffset) {
        this.edits.add((TextEdit)this.createReplaceEdit(startOffset, endOffset));
    }

    public void addReplaceEdit(TextRegion region) {
        this.edits.add((TextEdit)this.createReplaceEdit(region));
    }

    public void addDeleteEdit(int startOffset, int endOffset) {
        this.edits.add((TextEdit)this.createDeleteEdit(startOffset, endOffset));
    }

    public void addDeleteEdit(TextRegion region) {
        this.edits.add((TextEdit)this.createDeleteEdit(region));
    }

    public void addUnwrapGroupEdits(Group group) throws BadLocationException {
        RHeuristicTokenScanner scanner = this.getScanner();
        this.addDeleteEdit(group.getStartOffset(), scanner.expandAnySSpaceForward(group.getStartOffset() + 1, group.getEndOffset()));
        int closeOffset = group.getGroupCloseOffset();
        if (closeOffset != Integer.MIN_VALUE) {
            this.edits.add((TextEdit)new DeleteEdit(closeOffset, 1));
        }
    }

    public void addWrapInGroupEdits(RAstNode node) throws BadLocationException {
        this.edits.add((TextEdit)new InsertEdit(node.getStartOffset(), "("));
        this.edits.add((TextEdit)new InsertEdit(node.getEndOffset(), ")"));
    }

    public void addInverseConditionEdits(RAstNode node) throws BadLocationException {
        switch (node.getNodeType()) {
            case NOT: {
                this.edits.add((TextEdit)new DeleteEdit(node.getStartOffset(), 1));
                RAstNode inner = node.getChild(0);
                if (inner.getNodeType() == NodeType.GROUP) {
                    this.addUnwrapGroupEdits((Group)inner);
                }
                return;
            }
            case RELATIONAL: {
                super.clear();
                RTerminal newOperator = switch (node.getOperator(0)) {
                    case RTerminal.REL_NE -> RTerminal.REL_EQ;
                    case RTerminal.REL_EQ -> RTerminal.REL_NE;
                    case RTerminal.REL_LT -> RTerminal.REL_GE;
                    case RTerminal.REL_LE -> RTerminal.REL_GT;
                    case RTerminal.REL_GT -> RTerminal.REL_LE;
                    case RTerminal.REL_GE -> RTerminal.REL_LT;
                    default -> throw new RuntimeException();
                };
                int startOffset = node.getChild(0).getEndOffset();
                int endOffset = node.getChild(1).getStartOffset();
                if (this.codeStyle.getWhitespaceOtherOpBefore()) {
                    this.sb.append(' ');
                }
                this.sb.append(newOperator.text);
                if (this.codeStyle.getWhitespaceOtherOpAfter()) {
                    this.sb.append(' ');
                }
                this.addReplaceEdit(startOffset, endOffset);
                return;
            }
        }
        this.edits.add((TextEdit)new InsertEdit(node.getStartOffset(), "!"));
        if (node.getNodeType().opPrec > NodeType.NOT.opPrec) {
            this.addWrapInGroupEdits(node);
        }
    }

    public List<TextEdit> getEdits() {
        return this.edits;
    }
}

