/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.core.source.util;

import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.statet.ecommons.text.IndentUtil;
import org.eclipse.statet.r.core.RCodeStyleSettings;
import org.eclipse.statet.r.core.source.ast.CIfElse;
import org.eclipse.statet.r.core.source.ast.NodeType;
import org.eclipse.statet.r.core.source.ast.RAstNode;

class ScopeFactory {
    private static final int POOL_SIZE = 50;
    private final int levelMult;
    private final int wrappedCol;
    private final int blockCol;
    private Scope scope;
    private final Scope[] pool = new Scope[50];
    private int poolPointer = 0;
    private final IndentUtil util;
    private final RCodeStyleSettings style;
    private final AbstractDocument doc;
    private final IndentStrategy FIX_STRAT = new FixStrategy();
    private final IndentStrategy FIRSTLINE_STRAT = new FirstLineStrategy();

    public ScopeFactory(IndentUtil util, RCodeStyleSettings style, AbstractDocument doc) {
        this.util = util;
        this.style = style;
        this.doc = doc;
        this.levelMult = this.util.getLevelColumns();
        this.wrappedCol = this.style.getIndentWrappedCommandDepth() * this.levelMult;
        this.blockCol = this.style.getIndentBlockDepth() * this.levelMult;
    }

    private final void initNew(int offset, int line, RAstNode node, IndentStrategy strat, int baseColumn) {
        Scope scope;
        if (this.poolPointer < 50) {
            if (this.pool[this.poolPointer] == null) {
                this.pool[this.poolPointer] = new Scope();
            }
            scope = this.pool[this.poolPointer];
        } else {
            scope = new Scope();
        }
        ++this.poolPointer;
        scope.parent = this.scope;
        scope.baseColumn = baseColumn;
        scope.strategy = strat;
        scope.startLine = line;
        scope.commandNode = node;
        this.scope = scope;
    }

    public final Scope createDummy() {
        this.initNew(0, 0, null, null, 0);
        return this.scope;
    }

    public final void createSourceScope(int offset, RAstNode node) throws BadLocationException {
        int line = this.doc.getLineOfOffset(offset);
        this.initNew(offset, line, node, this.FIX_STRAT, 0);
    }

    public final void createBlockScope(int offset, RAstNode node) throws BadLocationException {
        int line = this.doc.getLineOfOffset(offset);
        switch (node.getRParent().getNodeType()) {
            case C_IF: 
            case C_FOR: 
            case C_WHILE: 
            case F_DEF: {
                if (node.getRParent().getChild(0) == node) break;
            }
            case C_REPEAT: {
                this.initNew(node.getStartOffset(), line, node, this.FIX_STRAT, this.scope.parent.baseColumn);
                return;
            }
        }
        this.initNew(node.getStartOffset(), line, node, this.FIX_STRAT, this.scope.getIndent(line));
    }

    public final void createCommonExprScope(int offset, RAstNode node) throws BadLocationException {
        int line = this.doc.getLineOfOffset(offset);
        this.initNew(offset, line, node, this.FIRSTLINE_STRAT, this.scope.getIndent(line));
    }

    public final void createGroupContScope(int offset, RAstNode node) throws BadLocationException {
        int line = this.doc.getLineOfOffset(offset);
        this.initNew(offset, line, node, this.FIX_STRAT, this.scope.getIndent(line + 1) + this.style.getIndentGroupDepth() * this.levelMult);
    }

    public final void createControlScope(int offset, RAstNode node) throws BadLocationException {
        int line = this.doc.getLineOfOffset(offset);
        this.initNew(offset, line, node, this.FIX_STRAT, this.scope.getIndent(line));
        boolean compact = true;
        if (compact && node.getNodeType() == NodeType.C_IF && ((CIfElse)node).hasElse()) {
            compact = false;
        }
        if (!this.useParent(compact, false, node)) {
            this.scope.baseColumn = this.scope.parent.getIndent(line + 1);
        }
    }

    public final void createControlCondScope(int offset, RAstNode node) throws BadLocationException {
        int line = this.doc.getLineOfOffset(offset);
        this.initNew(offset, line, node, this.FIRSTLINE_STRAT, this.scope.getIndent(line));
    }

    public final void createControlContScope(int offset, RAstNode node) throws BadLocationException {
        int line = this.doc.getLineOfOffset(offset);
        this.initNew(offset, line, node, this.FIRSTLINE_STRAT, this.scope.getIndent(line) + this.blockCol);
    }

    public final void createFCallScope(int offset, RAstNode node) throws BadLocationException {
        int line = this.doc.getLineOfOffset(offset);
        this.initNew(offset, line, node, this.FIX_STRAT, this.scope.getIndent(line));
        if (!this.useParent(true, true, node)) {
            this.scope.baseColumn = this.scope.parent.getIndent(line + 1);
        }
    }

    public final void createFDefScope(int offset, RAstNode node) throws BadLocationException {
        int line = this.doc.getLineOfOffset(offset);
        this.initNew(offset, line, node, this.FIX_STRAT, this.scope.getIndent(line));
    }

    public final void createFDeflistScope(int offset, RAstNode node) throws BadLocationException {
        int line = this.doc.getLineOfOffset(offset);
        this.initNew(offset, line, node, this.FIX_STRAT, this.scope.getIndent(line) + this.wrappedCol);
    }

    public final void createArglistScope(int offset, RAstNode node) throws BadLocationException {
        int line = this.doc.getLineOfOffset(offset);
        this.initNew(offset, line, node, this.FIX_STRAT, this.scope.getIndent(line) + this.wrappedCol);
    }

    public final void leaveScope() {
        this.scope = this.scope.parent;
        --this.poolPointer;
    }

    private final boolean useParent(boolean compact, boolean onlyAssignments, RAstNode node) throws BadLocationException {
        if (this.scope.parent.commandNode == node) {
            return true;
        }
        if (compact && this.scope.startLine == this.scope.parent.startLine && this.sameLine(this.scope.commandNode.getEndOffset(), this.scope.parent.commandNode.getEndOffset())) {
            return true;
        }
        if (onlyAssignments) {
            block4: while (true) {
                node = node.getRParent();
                switch (node.getNodeType()) {
                    case A_RIGHT: 
                    case A_EQUALS: 
                    case A_LEFT: 
                    case A_COLON: {
                        continue block4;
                    }
                    case SOURCELINES: 
                    case BLOCK: 
                    case SUB_INDEXED_ARG: 
                    case C_IF: 
                    case C_FOR: 
                    case C_WHILE: 
                    case C_REPEAT: 
                    case F_DEF_ARG: 
                    case F_CALL_ARG: {
                        return true;
                    }
                }
                break;
            }
        }
        return false;
    }

    private final boolean sameLine(int offset1, int offset2) throws BadLocationException {
        return offset1 == offset2 || this.doc.getLineOfOffset(offset1) == this.doc.getLineOfOffset(offset2);
    }

    public final void updateEnterBrackets() {
        this.scope.baseColumn += this.blockCol;
    }

    public final void updateLeaveBrackets() {
        this.scope.baseColumn -= this.blockCol;
    }

    public final void updateEnterFDefBody() throws BadLocationException {
        if (this.useParent(true, true, this.scope.commandNode)) {
            this.scope.baseColumn = this.scope.parent.baseColumn;
        }
    }

    public final int getIndent(int line) {
        return this.scope.getIndent(line);
    }

    private class FirstLineStrategy
    implements IndentStrategy {
        private FirstLineStrategy() {
        }

        @Override
        public int getIndent(Scope scope, int line) {
            if (line <= scope.startLine) {
                return scope.baseColumn;
            }
            return scope.baseColumn + ScopeFactory.this.wrappedCol;
        }
    }

    private class FixStrategy
    implements IndentStrategy {
        private FixStrategy() {
        }

        @Override
        public int getIndent(Scope scope, int line) {
            return scope.baseColumn;
        }
    }

    private static interface IndentStrategy {
        public int getIndent(Scope var1, int var2);
    }

    public static final class Scope {
        int baseColumn;
        int startLine;
        RAstNode commandNode;
        Scope parent;
        IndentStrategy strategy;

        int getIndent(int line) {
            return this.strategy.getIndent(this, line);
        }
    }
}

