/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.redocs.wikitext.r.ui.sourceediting;

import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.statet.docmlet.tex.ui.sourceediting.LtxSourceViewerConfiguration;
import org.eclipse.statet.docmlet.wikitext.core.WikitextCoreAccess;
import org.eclipse.statet.docmlet.wikitext.ui.sourceediting.WikidocSourceViewerConfiguration;
import org.eclipse.statet.ecommons.preferences.core.Preference;
import org.eclipse.statet.ecommons.templates.TemplateVariableProcessor;
import org.eclipse.statet.ecommons.text.core.PartitionConstraint;
import org.eclipse.statet.ecommons.text.core.sections.DocContentSections;
import org.eclipse.statet.ecommons.text.core.treepartitioner.TreePartition;
import org.eclipse.statet.ecommons.text.core.treepartitioner.TreePartitionNode;
import org.eclipse.statet.ecommons.text.core.treepartitioner.TreePartitionNodeType;
import org.eclipse.statet.ecommons.text.core.treepartitioner.TreePartitionUtils;
import org.eclipse.statet.ecommons.text.ui.presentation.SingleTokenScanner;
import org.eclipse.statet.ecommons.text.ui.presentation.TextStyleManager;
import org.eclipse.statet.internal.redocs.wikitext.r.RedocsWikitextRPlugin;
import org.eclipse.statet.internal.redocs.wikitext.r.ui.sourceediting.DocRQuickOutlineInformationProvider;
import org.eclipse.statet.internal.redocs.wikitext.r.ui.sourceediting.RChunkTemplateCompletionComputer;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.text.core.CharPairMatcher;
import org.eclipse.statet.ltk.ui.LtkUIPreferences;
import org.eclipse.statet.ltk.ui.sourceediting.EcoReconciler2;
import org.eclipse.statet.ltk.ui.sourceediting.MultiContentSectionSourceViewerConfiguration;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor1;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditorViewerConfiguration;
import org.eclipse.statet.ltk.ui.sourceediting.assist.ContentAssist;
import org.eclipse.statet.ltk.ui.sourceediting.assist.ContentAssistCategory;
import org.eclipse.statet.ltk.ui.sourceediting.assist.ContentAssistProcessor;
import org.eclipse.statet.r.core.RCoreAccess;
import org.eclipse.statet.r.core.source.doc.RPartitionNodeType;
import org.eclipse.statet.r.core.source.util.RHeuristicTokenScanner;
import org.eclipse.statet.r.ui.editors.RSourceEditor;
import org.eclipse.statet.r.ui.sourceediting.RAutoEditStrategy;
import org.eclipse.statet.r.ui.sourceediting.RSourceViewerConfiguration;
import org.eclipse.statet.r.ui.text.r.RDoubleClickStrategy;
import org.eclipse.statet.redocs.wikitext.r.core.source.WikidocRweaveBracketPairMatcher;
import org.eclipse.statet.redocs.wikitext.r.core.source.doc.WikidocRweaveDocumentContentInfo;
import org.eclipse.statet.redocs.wikitext.r.core.source.doc.WikitextRweaveDocumentConstants;
import org.eclipse.statet.redocs.wikitext.r.ui.editors.WikidocRweaveEditor;
import org.eclipse.statet.redocs.wikitext.r.ui.sourceediting.WikitextRweaveEditingSettings;
import org.eclipse.statet.yaml.core.YamlCoreAccess;
import org.eclipse.statet.yaml.ui.sourceediting.YamlSourceViewerConfiguration;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.spelling.SpellingReconcileStrategy;
import org.eclipse.ui.texteditor.spelling.SpellingService;

public class WikidocRweaveSourceViewerConfiguration
extends MultiContentSectionSourceViewerConfiguration {
    private static final String[] CONTENT_TYPES = (String[])WikitextRweaveDocumentConstants.WIKIDOC_R_CONTENT_TYPES.toArray((Object[])new String[WikitextRweaveDocumentConstants.WIKIDOC_R_CONTENT_TYPES.size()]);
    private final WikidocConfiguration docConfig;
    private final YamlChunkConfiguration yamlConfig;
    private final LtxSourceViewerConfiguration ltxConfig;
    private final RChunkConfiguration rConfig;
    private ITextDoubleClickStrategy rDoubleClickStrategy;

    public WikidocRweaveSourceViewerConfiguration(int flags) {
        this(flags, null, null, null, null);
    }

    public WikidocRweaveSourceViewerConfiguration(int flags, WikidocRweaveEditor sourceEditor, WikitextCoreAccess wikitextCoreAccess, RCoreAccess rCoreAccess, IPreferenceStore preferenceStore) {
        super((DocContentSections)WikidocRweaveDocumentContentInfo.INSTANCE, flags, (SourceEditor)sourceEditor);
        this.docConfig = new WikidocConfiguration((DocContentSections)WikidocRweaveDocumentContentInfo.INSTANCE, flags, (SourceEditor)sourceEditor, wikitextCoreAccess, preferenceStore);
        this.yamlConfig = new YamlChunkConfiguration((DocContentSections)WikidocRweaveDocumentContentInfo.INSTANCE, flags & 0xFF, (SourceEditor)sourceEditor, wikitextCoreAccess, preferenceStore);
        this.ltxConfig = new LtxSourceViewerConfiguration((DocContentSections)WikidocRweaveDocumentContentInfo.INSTANCE, flags & 0xFF, (SourceEditor)sourceEditor, null, null, null);
        this.rConfig = new RChunkConfiguration((DocContentSections)WikidocRweaveDocumentContentInfo.INSTANCE, flags & 0xFF, (RSourceEditor)sourceEditor, rCoreAccess, preferenceStore);
        this.registerConfig("org.eclipse.statet.Wikidoc", (SourceEditorViewerConfiguration)this.docConfig);
        this.registerConfig("org.eclipse.statet.Yaml", (SourceEditorViewerConfiguration)this.yamlConfig);
        this.registerConfig("org.eclipse.statet.Ltx", (SourceEditorViewerConfiguration)this.ltxConfig);
        this.registerConfig("org.eclipse.statet.R", (SourceEditorViewerConfiguration)this.rConfig);
        this.setup(preferenceStore != null ? preferenceStore : RedocsWikitextRPlugin.getInstance().getEditorPreferenceStore(), LtkUIPreferences.getEditorDecorationPreferences(), LtkUIPreferences.getAssistPreferences());
    }

    protected void initScanners() {
        TextStyleManager<TextAttribute> textStyles = this.rConfig.getTextStyles();
        this.addScanner("RweaveChunk.Base", (ITokenScanner)new SingleTokenScanner(textStyles, "text_R_rUndefined"));
    }

    protected ITokenScanner getScanner(String contentType) {
        if (contentType == "RweaveChunk.Control") {
            return this.rConfig.getScanner("R.Default");
        }
        if (contentType == "RweaveChunk.Comment") {
            return this.rConfig.getScanner("R.Comment");
        }
        return super.getScanner(contentType);
    }

    protected void setCoreAccess(WikitextCoreAccess wikitextCoreAccess, RCoreAccess rCoreAccess) {
        this.docConfig.setCoreAccess(wikitextCoreAccess);
        this.rConfig.setCoreAccess(rCoreAccess);
        this.yamlConfig.setCoreAccess(null, wikitextCoreAccess);
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return CONTENT_TYPES;
    }

    protected void initPresentationReconciler(PresentationReconciler reconciler) {
        super.initPresentationReconciler(reconciler);
        for (String contentType : WikitextRweaveDocumentConstants.RCHUNK_CONTENT_TYPES) {
            ITokenScanner scanner = this.getScanner(contentType);
            if (scanner == null) continue;
            DefaultDamagerRepairer dr = new DefaultDamagerRepairer(scanner);
            reconciler.setDamager((IPresentationDamager)dr, contentType);
            reconciler.setRepairer((IPresentationRepairer)dr, contentType);
        }
    }

    public CharPairMatcher createPairMatcher() {
        return new WikidocRweaveBracketPairMatcher();
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        switch (WikidocRweaveDocumentContentInfo.INSTANCE.getTypeByPartition(contentType)) {
            case "org.eclipse.statet.Wikidoc": {
                return this.docConfig.getDoubleClickStrategy(sourceViewer, contentType);
            }
            case "org.eclipse.statet.R": 
            case "org.eclipse.statet.WikitextR-ChunkControl": {
                if (this.rDoubleClickStrategy == null) {
                    RHeuristicTokenScanner scanner = RHeuristicTokenScanner.create((DocContentSections)this.getDocumentContentInfo());
                    this.rDoubleClickStrategy = new RDoubleClickStrategy(scanner, (CharPairMatcher)WikidocRweaveBracketPairMatcher.createRChunkPairMatcher(scanner));
                }
                return this.rDoubleClickStrategy;
            }
        }
        return null;
    }

    protected IReconcilingStrategy getSpellingStrategy(ISourceViewer sourceViewer) {
        if (!((Boolean)this.rConfig.getRCoreAccess().getPrefs().getPreferenceValue((Preference)WikitextRweaveEditingSettings.WIKIDOC_SPELLCHECK_ENABLED_PREF)).booleanValue() || !this.fPreferenceStore.getBoolean("spellingEnabled")) {
            return null;
        }
        SpellingService spellingService = EditorsUI.getSpellingService();
        if (spellingService.getActiveSpellingEngineDescriptor(this.fPreferenceStore) == null) {
            return null;
        }
        return new SpellingReconcileStrategy(sourceViewer, spellingService);
    }

    protected void initContentAssist(ContentAssist assistant) {
        super.initContentAssist(assistant);
        RChunkTemplateCompletionComputer chunkComputer = new RChunkTemplateCompletionComputer();
        ContentAssistProcessor wikitextProcessor = (ContentAssistProcessor)assistant.getContentAssistProcessor("Wikitext.Default");
        wikitextProcessor.addCategory(new ContentAssistCategory("Wikitext.Default", (List)ImCollections.newList((Object)((Object)chunkComputer))));
        ContentAssistProcessor controlProcessor = new ContentAssistProcessor(assistant, "RweaveChunk.Base", RedocsWikitextRPlugin.getInstance().getWikidocRweaveEditorContentAssistRegistry(), this.getSourceEditor());
        controlProcessor.addCategory(new ContentAssistCategory("RweaveChunk.Base", (List)ImCollections.newList((Object)((Object)chunkComputer))));
        assistant.setContentAssistProcessor((IContentAssistProcessor)controlProcessor, "RweaveChunk.Base");
        assistant.setContentAssistProcessor((IContentAssistProcessor)controlProcessor, "RweaveChunk.Control");
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        IReconcilingStrategy spellingStrategy;
        SourceEditor editor = this.getSourceEditor();
        if (!(editor instanceof SourceEditor1)) {
            return null;
        }
        EcoReconciler2 reconciler = (EcoReconciler2)this.docConfig.getReconciler(sourceViewer);
        if (reconciler != null && (spellingStrategy = this.getSpellingStrategy(sourceViewer)) != null) {
            reconciler.addReconcilingStrategy(spellingStrategy);
        }
        return reconciler;
    }

    protected IInformationProvider getQuickInformationProvider(ISourceViewer sourceViewer, int operation) {
        SourceEditor editor = this.getSourceEditor();
        if (editor == null) {
            return null;
        }
        switch (operation) {
            case 51: {
                return new DocRQuickOutlineInformationProvider(editor, operation);
            }
        }
        return null;
    }

    private static class RChunkAutoEditStrategy
    extends RAutoEditStrategy {
        public RChunkAutoEditStrategy(RCoreAccess coreAccess, SourceEditor sourceEditor) {
            super(coreAccess, sourceEditor);
        }

        protected TextRegion getValidRange(int offset, TreePartition partition, int c) {
            switch (WikidocRweaveDocumentContentInfo.INSTANCE.getTypeByPartition(partition.getType())) {
                case "org.eclipse.statet.R": {
                    return TreePartitionUtils.searchNodeUp((TreePartitionNode)partition.getTreeNode(), (TreePartitionNodeType)RPartitionNodeType.DEFAULT_ROOT);
                }
                case "org.eclipse.statet.WikitextR-ChunkControl": {
                    switch (c) {
                        case 34: 
                        case 37: 
                        case 39: 
                        case 40: 
                        case 91: 
                        case 123: {
                            return TreePartitionUtils.searchPartitionRegion((TreePartition)partition, (PartitionConstraint)WikitextRweaveDocumentConstants.RCHUNK_PARTITION_CONSTRAINT);
                        }
                    }
                    return null;
                }
            }
            return null;
        }
    }

    private static class RChunkConfiguration
    extends RSourceViewerConfiguration {
        public RChunkConfiguration(DocContentSections documentContentInfo, int flags, RSourceEditor sourceEditor, RCoreAccess coreAccess, IPreferenceStore preferenceStore) {
            super(documentContentInfo, flags, sourceEditor, coreAccess, preferenceStore, null);
        }

        protected void setCoreAccess(RCoreAccess access) {
            super.setCoreAccess(access);
        }

        protected TextStyleManager<TextAttribute> getTextStyles() {
            return super.getTextStyles();
        }

        protected ITokenScanner getScanner(String contentType) {
            return super.getScanner(contentType);
        }

        protected RAutoEditStrategy createRAutoEditStrategy() {
            return new RChunkAutoEditStrategy(this.getRCoreAccess(), (SourceEditor)this.getSourceEditor());
        }
    }

    private static class WikidocConfiguration
    extends WikidocSourceViewerConfiguration {
        public WikidocConfiguration(DocContentSections documentContentInfo, int flags, SourceEditor editor, WikitextCoreAccess wikitextCoreAccess, IPreferenceStore preferenceStore) {
            super(documentContentInfo, flags, editor, wikitextCoreAccess, preferenceStore);
        }

        protected void setCoreAccess(WikitextCoreAccess access) {
            super.setCoreAccess(access);
        }

        protected TemplateVariableProcessor getTemplateVariableProcessor() {
            return super.getTemplateVariableProcessor();
        }
    }

    private static class YamlChunkConfiguration
    extends YamlSourceViewerConfiguration {
        public YamlChunkConfiguration(DocContentSections documentContentInfo, int flags, SourceEditor sourceEditor, @Nullable WikitextCoreAccess wikitextCoreAccess, IPreferenceStore preferenceStore) {
            super(documentContentInfo, flags, sourceEditor, null, wikitextCoreAccess != null ? wikitextCoreAccess.getPrefs() : null, preferenceStore, null);
        }

        protected void setCoreAccess(@Nullable YamlCoreAccess access, @Nullable WikitextCoreAccess wikitextCoreAccess) {
            super.setCoreAccess(access, wikitextCoreAccess != null ? wikitextCoreAccess.getPrefs() : null);
        }
    }
}

