/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting;

import org.eclipse.jface.text.quickassist.IQuickFixableAnnotation;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationPresentation;
import org.eclipse.jface.text.source.ImageUtilities;
import org.eclipse.statet.internal.ltk.ui.sourceediting.AnnotationPresentationConfig;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.core.Ltk;
import org.eclipse.statet.ltk.issues.core.IssueTypeSet;
import org.eclipse.statet.ltk.issues.core.Problem;
import org.eclipse.statet.ltk.ui.sourceediting.SourceIssueAnnotation;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;

@NonNullByDefault
public class SourceIssueEditorAnnotation
extends Annotation
implements SourceIssueAnnotation<Problem>,
IAnnotationPresentation,
IQuickFixableAnnotation {
    static final AnnotationPresentationConfig ERROR_CONFIG = new AnnotationPresentationConfig("org.eclipse.ui.workbench.texteditor.error", 1, "org.eclipse.statet.ltk/images/obj/Error", "org.eclipse.statet.ltk/images/obj/Error.away");
    static final AnnotationPresentationConfig WARNING_CONFIG = new AnnotationPresentationConfig("org.eclipse.ui.workbench.texteditor.warning", 1, "org.eclipse.statet.ltk/images/obj/Warning", "org.eclipse.statet.ltk/images/obj/Warning.away");
    static final AnnotationPresentationConfig INFO_CONFIG = new AnnotationPresentationConfig("org.eclipse.ui.workbench.texteditor.info", 1, "org.eclipse.statet.ltk/images/obj/Info", "org.eclipse.statet.ltk/images/obj/Info.away");
    static final AnnotationPresentationConfig FALLBACK_CONFIG = new AnnotationPresentationConfig(null, Integer.MIN_VALUE, null, null);
    private final IssueTypeSet.IssueCategory<Problem> issueCategory;
    private final Problem issue;
    private boolean isQuickFixable = false;
    private boolean isQuickFixableStateSet = false;
    private final AnnotationPresentationConfig presentationConfig;
    private ImList<Annotation> overlaidAnnotations = ImCollections.emptyList();

    static AnnotationPresentationConfig getProblemPresentationConfig(int severity) {
        switch (severity) {
            case 2: {
                return ERROR_CONFIG;
            }
            case 1: {
                return WARNING_CONFIG;
            }
            case 0: {
                return INFO_CONFIG;
            }
        }
        return FALLBACK_CONFIG;
    }

    static AnnotationPresentationConfig getIssuePresentationConfig(IssueTypeSet.IssueCategory<?> issueCategory, String type) {
        IssueTypeSet.ProblemTypes problemTypes;
        if (issueCategory instanceof IssueTypeSet.ProblemCategory && (problemTypes = ((IssueTypeSet.ProblemCategory)issueCategory).getTypes(Ltk.EDITOR_CONTEXT)) != null) {
            return SourceIssueEditorAnnotation.getProblemPresentationConfig(problemTypes.getSeverity(type));
        }
        return FALLBACK_CONFIG;
    }

    public SourceIssueEditorAnnotation(IssueTypeSet.IssueCategory<Problem> issueCategory, String type, Problem issue) {
        super(type, false, null);
        this.issueCategory = issueCategory;
        this.issue = issue;
        this.presentationConfig = SourceIssueEditorAnnotation.getProblemPresentationConfig(issue.getSeverity());
    }

    @Override
    public IssueTypeSet.IssueCategory<Problem> getIssueCategory() {
        return this.issueCategory;
    }

    public String getText() {
        return this.issue.getMessage();
    }

    public Problem getIssue() {
        return this.issue;
    }

    public int getLayer() {
        return this.presentationConfig.getLevel();
    }

    public void paint(GC gc, Canvas canvas, Rectangle bounds) {
        Image image = this.presentationConfig.getImage();
        if (image != null) {
            ImageUtilities.drawImage((Image)image, (GC)gc, (Canvas)canvas, (Rectangle)bounds, (int)0x1000000, (int)128);
        }
    }

    public void setQuickFixable(boolean state) {
        this.isQuickFixable = state;
        this.isQuickFixableStateSet = true;
    }

    public boolean isQuickFixableStateSet() {
        return this.isQuickFixableStateSet;
    }

    public boolean isQuickFixable() {
        return this.isQuickFixable;
    }

    @Override
    public @Nullable SourceIssueAnnotation<Problem> getOverlay() {
        return null;
    }

    @Override
    public ImList<Annotation> getOverlaidAnnotations() {
        return this.overlaidAnnotations;
    }

    public void addOverlaidAnnotation(Annotation annotation) {
        this.overlaidAnnotations = ImCollections.addElement(this.overlaidAnnotations, (Object)annotation);
    }

    public void removeOverlaidAnnotation(Annotation annotation) {
        this.overlaidAnnotations = ImCollections.removeElement(this.overlaidAnnotations, (Object)annotation);
    }
}

