/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.buildpath.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.statet.ecommons.databinding.jface.DataBindingSupport;
import org.eclipse.statet.ecommons.ui.components.ButtonGroup;
import org.eclipse.statet.ecommons.ui.components.DataAdapter;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.internal.ltk.buildpath.ui.Messages;
import org.eclipse.statet.jcommons.collections.ImCollection;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImIdentitySet;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.ltk.buildpath.core.BuildpathElementType;
import org.eclipse.statet.ltk.buildpath.ui.BuildpathListElement;
import org.eclipse.statet.ltk.buildpath.ui.BuildpathListElementAttribute;
import org.eclipse.statet.ltk.buildpath.ui.BuildpathsUIDescription;
import org.eclipse.statet.ltk.buildpath.ui.wizards.EditFilterWizard;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public class SourceContainerComponent
implements ButtonGroup.IActions<Object> {
    private static final ImIdentitySet<String> FILTER_NO = ImCollections.emptyIdentitySet();
    private static final ImIdentitySet<String> FILTER_OUTPUT = ImCollections.newIdentitySet((Object)"Output.path");
    private static final Object[] NO_CHILDREN = new Object[0];
    private final WritableList<BuildpathListElement> buildpathList;
    private final BuildpathElementType type;
    private final BuildpathsUIDescription uiDescription;
    private IProject project;
    private final WritableList<BuildpathListElement> containerList = new WritableList();
    private final Set<BuildpathListElement> changedContainers = new HashSet<BuildpathListElement>();
    private final IObservableValue<String> outputPathValue;
    private final IObservableValue<Boolean> outputByContainerValue;
    private Control control;
    private TreeViewer containerListViewer;
    private ButtonGroup<Object> containerListButtons;
    private Text outputPathControl;
    private Button outputByFolderControl;

    public SourceContainerComponent(WritableList<BuildpathListElement> buildpathList, BuildpathElementType sourceType, BuildpathElementType outputType, BuildpathsUIDescription uiDescription) {
        this.buildpathList = buildpathList;
        this.type = sourceType;
        this.uiDescription = uiDescription;
        this.outputPathValue = outputType != null ? new WritableValue(null, String.class) : null;
        this.outputByContainerValue = outputType != null && this.type.isAttributeBuiltin("Output.path") ? new WritableValue((Object)false, Boolean.TYPE) : null;
    }

    public void init(IProject project) {
        this.project = project;
        if (Display.getCurrent() != null) {
            this.updateTargets(true);
        } else {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    SourceContainerComponent.this.updateTargets(true);
                }
            });
        }
    }

    private Shell getShell() {
        if (this.control != null) {
            return this.control.getShell();
        }
        return UIAccess.getActiveWorkbenchShell((boolean)true);
    }

    public Control create(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)LayoutUtils.newCompositeGrid((int)2));
        Label label = new Label(composite, 0);
        label.setText(Messages.SourceContainers_SourceFolders_label);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        TreeViewer viewer = new TreeViewer(composite, 2818);
        TreeContentProvider contentProvider = new TreeContentProvider();
        viewer.setContentProvider((IContentProvider)contentProvider);
        viewer.setComparator((ViewerComparator)this.uiDescription.createListElementComparator());
        viewer.setLabelProvider((IBaseLabelProvider)this.uiDescription.createListLabelProvider());
        viewer.setInput(this.containerList);
        GridData gd = new GridData(4, 4, true, true);
        gd.heightHint = LayoutUtils.hintHeight((Tree)viewer.getTree(), (int)8);
        gd.widthHint = LayoutUtils.hintWidth((Tree)viewer.getTree(), (int)60);
        viewer.getControl().setLayoutData((Object)gd);
        this.containerListViewer = viewer;
        ButtonGroup buttonGroup = new ButtonGroup(composite, (ButtonGroup.IActions)this, false);
        buttonGroup.addAddButton((ButtonGroup.SelectionHandler)new ButtonGroup.AddHandler(){

            public void update(IStructuredSelection selection) {
                this.setEnabled(SourceContainerComponent.this.uiDescription.getAllowAdd(SourceContainerComponent.this.project, SourceContainerComponent.this.type));
            }
        });
        buttonGroup.addEditButton(null);
        buttonGroup.addDeleteButton(null);
        buttonGroup.connectTo((StructuredViewer)viewer, (DataAdapter)new ListElementDataAdapter(contentProvider));
        buttonGroup.setLayoutData((Object)new GridData(4, 4, false, true));
        this.containerListButtons = buttonGroup;
        if (this.outputPathValue != null) {
            label = new Label(composite, 0);
            label.setText(Messages.SourceContainers_OutputFolder_label);
            label.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
            Text text = new Text(composite, 2052);
            text.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
            this.outputPathControl = text;
            Button button = new Button(composite, 8);
            button.setText(Messages.SourceContainers_OutputFolder_Choose_label);
            if (this.outputByContainerValue != null) {
                Button button2 = new Button(composite, 32);
                button2.setText(Messages.SourceContainers_OutputBySourceFolders_label);
                button2.setSelection(false);
                button2.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
                this.outputByFolderControl = button2;
            }
        }
        this.control = composite;
        return this.control;
    }

    public void bind(DataBindingSupport db) {
        if (this.outputPathValue != null) {
            db.getContext().bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.outputPathControl), this.outputPathValue);
            if (this.outputByContainerValue != null) {
                db.getContext().bindValue((IObservableValue)WidgetProperties.buttonSelection().observe((Widget)this.outputByFolderControl), this.outputByContainerValue);
                this.outputByContainerValue.addValueChangeListener((IValueChangeListener)new IValueChangeListener<Boolean>(){

                    public void handleValueChange(ValueChangeEvent<? extends Boolean> event) {
                        if (!((Boolean)event.diff.getNewValue()).booleanValue()) {
                            for (Object object : SourceContainerComponent.this.containerList) {
                                BuildpathListElement element = (BuildpathListElement)object;
                                BuildpathListElementAttribute attribute = element.setAttribute("Output.path", null);
                                if (attribute == null) continue;
                                SourceContainerComponent.this.changedContainers.add(element);
                            }
                            SourceContainerComponent.this.containerListButtons.refresh();
                        }
                    }
                });
            }
        }
        this.updateExpandStates();
    }

    private void updateTargets(boolean reset) {
        if (UIAccess.isOkToUse((Control)this.control)) {
            if (reset) {
                this.containerListViewer.collapseAll();
            }
            this.containerList.clear();
            this.changedContainers.clear();
            ArrayList<BuildpathListElement> folders = new ArrayList<BuildpathListElement>();
            boolean outputLocationByFolder = false;
            for (BuildpathListElement element : this.buildpathList) {
                if (!this.isElement(element)) continue;
                folders.add(element);
                outputLocationByFolder |= element.getAttributeValue("Output.path") != null;
            }
            this.containerList.addAll(folders);
            this.containerListButtons.refresh();
            this.updateExpandStates();
            if (this.outputByContainerValue != null) {
                this.outputByContainerValue.setValue((Object)outputLocationByFolder);
            }
        }
    }

    private void updateBuildpathList() {
        ArrayList<BuildpathListElement> workingList = new ArrayList<BuildpathListElement>((Collection<BuildpathListElement>)this.containerList);
        int idx = 0;
        while (idx < this.buildpathList.size()) {
            BuildpathListElement element = (BuildpathListElement)this.buildpathList.get(idx);
            if (this.isElement(element)) {
                if (workingList.remove(element)) {
                    if (this.changedContainers.remove(element)) {
                        this.buildpathList.set(idx, (Object)element);
                    }
                    ++idx;
                    continue;
                }
                this.buildpathList.remove(idx);
                continue;
            }
            ++idx;
        }
        if (!workingList.isEmpty()) {
            this.buildpathList.addAll(workingList);
        }
        this.changedContainers.clear();
    }

    private void updateExpandStates() {
        int i = 0;
        while (i < this.containerList.size()) {
            BuildpathListElement element = (BuildpathListElement)this.containerList.get(i);
            List inclusionPatterns = (List)element.getAttributeValue("Filter.inclusions");
            List exclusionPatterns = (List)element.getAttributeValue("Filter.exclusions");
            IPath outputFolder = (IPath)element.getAttributeValue("Output.path");
            if (!inclusionPatterns.isEmpty() || !exclusionPatterns.isEmpty() || outputFolder != null) {
                this.containerListViewer.expandToLevel((Object)element, 1);
            }
            ++i;
        }
    }

    protected boolean isElement(BuildpathListElement element) {
        return element.getType() == this.type;
    }

    public void setFocus() {
        this.containerListViewer.getTree().setFocus();
    }

    public List<Object> getSelection() {
        return ImCollections.toList((Collection)((StructuredSelection)this.containerListViewer.getSelection()).toList());
    }

    public void setSelection(List<BuildpathListElement> elements, boolean expand) {
        this.containerListViewer.setSelection((ISelection)new StructuredSelection(elements));
        if (expand) {
            for (BuildpathListElement element : elements) {
                this.containerListViewer.expandToLevel((Object)element, 1);
            }
        }
    }

    public Object edit(int command, Object item, Object parent) {
        if (command == 1) {
            throw new UnsupportedOperationException();
        }
        if (item instanceof BuildpathListElement) {
            return this.editElement((BuildpathListElement)item);
        }
        if (item instanceof BuildpathListElementAttribute) {
            return this.editAttribute((BuildpathListElementAttribute)item);
        }
        throw new IllegalStateException();
    }

    public void updateState(IStructuredSelection selection) {
    }

    private BuildpathListElement editElement(BuildpathListElement element) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    private BuildpathListElementAttribute editAttribute(BuildpathListElementAttribute attribute) {
        switch (attribute.getName()) {
            case "Filter.exclusions": 
            case "Filter.inclusions": {
                EditFilterWizard wizard = new EditFilterWizard((ImList<BuildpathListElement>)ImCollections.toList(this.containerList), attribute.getParent(), this.uiDescription);
                WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
                dialog.create();
                wizard.setFocus(attribute.getName());
                if (dialog.open() == 0) {
                    this.containerListButtons.refresh(null);
                    this.changedContainers.add(attribute.getParent());
                    this.updateBuildpathList();
                }
                return null;
            }
        }
        throw new UnsupportedOperationException("Not yet implemented");
    }

    private class ListElementDataAdapter
    extends DataAdapter.TreeAdapter<Object> {
        public ListElementDataAdapter(ITreeContentProvider contentProvider) {
            super(contentProvider, null);
        }

        public boolean isModifyAllowed(Object element) {
            if (element instanceof BuildpathListElement) {
                BuildpathListElement listElement = (BuildpathListElement)element;
                if (listElement.getType().getName() == "Source" && listElement.getPath().equals((Object)SourceContainerComponent.this.project.getFullPath())) {
                    return false;
                }
                return SourceContainerComponent.this.uiDescription.getAllowEdit(listElement);
            }
            if (element instanceof BuildpathListElementAttribute) {
                BuildpathListElementAttribute attribute = (BuildpathListElementAttribute)element;
                if (attribute.isBuiltin()) {
                    return SourceContainerComponent.this.uiDescription.getAllowEdit(attribute);
                }
                return false;
            }
            return false;
        }

        public boolean isDeleteAllowed(Object element) {
            block10: {
                block11: {
                    block12: {
                        if (element instanceof BuildpathListElement) {
                            BuildpathListElement listElement = (BuildpathListElement)element;
                            return SourceContainerComponent.this.uiDescription.getAllowEdit(listElement);
                        }
                        if (!(element instanceof BuildpathListElementAttribute)) break block10;
                        BuildpathListElementAttribute attribute = (BuildpathListElementAttribute)element;
                        if (!SourceContainerComponent.this.uiDescription.getAllowEdit(attribute)) break block11;
                        if (!attribute.isBuiltin()) break block12;
                        switch (attribute.getName()) {
                            case "Filter.exclusions": 
                            case "Filter.inclusions": {
                                return !((List)attribute.getValue()).isEmpty();
                            }
                        }
                        return attribute.getValue() != null;
                    }
                    return true;
                }
                return false;
            }
            return false;
        }

        public void delete(List<? extends Object> elements) {
            for (Object object : elements) {
                block11: {
                    if (object instanceof BuildpathListElement) {
                        BuildpathListElement element = (BuildpathListElement)object;
                        SourceContainerComponent.this.containerList.remove((Object)element);
                        continue;
                    }
                    if (!(object instanceof BuildpathListElementAttribute)) continue;
                    BuildpathListElementAttribute attribute = (BuildpathListElementAttribute)object;
                    String key = attribute.getName();
                    if (!attribute.isBuiltin()) break block11;
                    attribute.getParent().setAttribute(key, switch (attribute.getName()) {
                        case "Filter.exclusions", "Filter.inclusions" -> ImCollections.emptyList();
                        default -> null;
                    });
                    SourceContainerComponent.this.changedContainers.add(attribute.getParent());
                    continue;
                }
                throw new UnsupportedOperationException("Not yet implemented");
            }
            SourceContainerComponent.this.updateBuildpathList();
        }
    }

    private class TreeContentProvider
    implements ITreeContentProvider {
        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return SourceContainerComponent.this.containerList.toArray();
        }

        public Object getParent(Object element) {
            if (element instanceof BuildpathListElementAttribute) {
                return ((BuildpathListElementAttribute)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof BuildpathListElement;
        }

        private boolean isFilterOutputAttribute() {
            return SourceContainerComponent.this.outputByContainerValue == null || (Boolean)SourceContainerComponent.this.outputByContainerValue.getValue() == false;
        }

        public Object[] getChildren(Object element) {
            if (element instanceof BuildpathListElement) {
                ImIdentitySet<String> filter = this.isFilterOutputAttribute() ? FILTER_OUTPUT : FILTER_NO;
                return ((BuildpathListElement)element).getFilteredChildren((ImCollection<String>)filter).toArray();
            }
            return NO_CHILDREN;
        }
    }
}

