/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.drda;

import org.apache.derby.impl.drda.DDMWriter;

final class DRDAString {
    private byte[] buffer = new byte[0];
    private final DDMWriter writer;
    private boolean modified;
    private String cachedString;

    DRDAString(DDMWriter w) {
        this.writer = w;
        this.cachedString = null;
    }

    private boolean equalTo(byte[] buf, int offset, int size) {
        int len = this.buffer.length;
        if (len != size) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (this.buffer[i] == buf[i + offset]) continue;
            return false;
        }
        return true;
    }

    public void setBytes(byte[] src, int offset, int size) {
        if (this.equalTo(src, offset, size)) {
            this.modified = false;
            return;
        }
        if (this.buffer.length != size) {
            this.buffer = new byte[size];
        }
        System.arraycopy(src, offset, this.buffer, 0, size);
        this.modified = true;
        this.cachedString = null;
    }

    public boolean wasModified() {
        return this.modified;
    }

    public String toString() {
        if (this.cachedString == null) {
            this.cachedString = this.writer.getCurrentCcsidManager().convertToJavaString(this.buffer);
        }
        return this.cachedString;
    }

    public int length() {
        return this.buffer.length;
    }

    public byte[] getBytes() {
        return this.buffer;
    }
}

