/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.resources.core.util;

import java.util.Arrays;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;

@NonNullByDefault
public class MarkerUpdate {
    private final IMarker marker;
    private @NonNull String[] names;
    private @Nullable Object[] values;
    private int n;

    public MarkerUpdate(IMarker marker, int initialCapacity) {
        this.marker = (IMarker)ObjectUtils.nonNullAssert((Object)marker);
        this.names = new String[initialCapacity];
        this.values = new Object[initialCapacity];
        this.n = 0;
    }

    public IMarker getMarker() {
        return this.marker;
    }

    private void ensureCapacity(int n) {
        if (n <= this.names.length) {
            return;
        }
        int l = Math.max(n, this.names.length + 8);
        this.names = Arrays.copyOf(this.names, l);
        this.values = Arrays.copyOf(this.values, l);
    }

    public void setAttribute(String name, @Nullable Object value) {
        int idx = this.n++;
        this.ensureCapacity(idx + 1);
        this.names[idx] = (String)ObjectUtils.nonNullAssert((Object)name);
        this.values[idx] = value;
    }

    public void setAttribute(String name, int value) {
        this.setAttribute(name, (Object)value);
    }

    public void setAttribute(String name, boolean value) {
        this.setAttribute(name, (Object)value);
    }

    public void removeAttribute(String name) {
        this.setAttribute(name, null);
    }

    public void apply() throws CoreException {
        int n = this.n;
        if (n == 0) {
            return;
        }
        String[] names = this.names;
        Object[] values = this.values;
        if (n != names.length) {
            names = Arrays.copyOf(names, n);
            values = Arrays.copyOf(values, n);
        }
        this.marker.setAttributes(names, values);
    }
}

