/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.components;

import org.eclipse.statet.ecommons.ui.components.IObjValueListener;
import org.eclipse.statet.ecommons.ui.components.IObjValueWidget;
import org.eclipse.statet.ecommons.ui.components.ObjValueEvent;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.jcommons.collections.CopyOnWriteIdentityListSet;
import org.eclipse.statet.jcommons.graphic.core.ColorDef;
import org.eclipse.statet.jcommons.graphic.core.RGBColorDef;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

@NonNullByDefault
public class AlphaSelector
extends Canvas
implements IObjValueWidget<Float> {
    private static final ColorDef DEFAULT_BASE = new RGBColorDef(0, 0, 0);
    private static final int INITIAL = 1;
    private int size = 8 + LayoutUtils.defaultHSpacing() * 30;
    private Float value = Float.valueOf(1.0f);
    private int flags = 1;
    private final CopyOnWriteIdentityListSet<IObjValueListener<Float>> valueListeners = new CopyOnWriteIdentityListSet();
    private ColorDef baseColor = DEFAULT_BASE;
    private Color backgroundColor;

    public AlphaSelector(Composite parent, Color backgroundColor) {
        super(parent, 0x20000000);
        this.backgroundColor = backgroundColor;
        SWTListener listener = new SWTListener();
        this.addPaintListener(listener);
        this.addListener(3, listener);
        this.addListener(4, listener);
        this.addListener(5, listener);
        this.addListener(12, listener);
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void setBaseColor(ColorDef color) {
        this.baseColor = color != null ? color : DEFAULT_BASE;
        this.redraw();
    }

    private boolean doSetValue(Float newValue, int time, int flags) {
        Float oldValue = this.value;
        if (oldValue.equals(newValue) && (flags | this.flags & 1) == 0) {
            return false;
        }
        this.value = newValue;
        ObjValueEvent<Float> event = new ObjValueEvent<Float>(this, time, 0, oldValue, newValue, flags);
        for (IObjValueListener listener : this.valueListeners.toList()) {
            event.newValue = newValue;
            listener.valueChanged(event);
        }
        if (!this.isDisposed()) {
            this.redraw();
        }
        return true;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        int width = 2 + Math.round((float)this.size * 0.15f);
        int height = 2 + this.size;
        int border = this.getBorderWidth();
        return new Point(width += border * 2, height += border * 2);
    }

    @Override
    public Control getControl() {
        return this;
    }

    @Override
    public Class<Float> getValueType() {
        return Float.class;
    }

    @Override
    public void addValueListener(IObjValueListener<Float> listener) {
        this.valueListeners.add((Object)((IObjValueListener)ObjectUtils.nonNullAssert(listener)));
    }

    @Override
    public void removeValueListener(IObjValueListener<Float> listener) {
        this.valueListeners.remove(listener);
    }

    @Override
    public Float getValue(int idx) {
        if (idx != 0) {
            throw new IllegalArgumentException("idx: " + idx);
        }
        return this.value;
    }

    @Override
    public void setValue(int idx, Float value) {
        if (idx != 0) {
            throw new IllegalArgumentException("idx: " + idx);
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        this.doSetValue(value, 0, 0);
    }

    private static final class Data {
        private final int size;
        private final float factor;
        private final Color backgroundColor;
        private final ColorDef baseColor;
        private final int alphaX0;
        private final int alphaX1;
        private final int y0;
        private final int y1;

        public Data(int size, Color backgroundColor, ColorDef baseColor) {
            this.size = size;
            this.backgroundColor = backgroundColor;
            this.baseColor = baseColor;
            this.factor = size - 1;
            this.alphaX0 = 1;
            this.alphaX1 = this.alphaX0 + Math.round((float)size * 0.15f);
            this.y0 = 1;
            this.y1 = this.y0 + size;
        }

        public int alpha_y_255(int y) {
            int v = 255 - Math.round((float)(y - this.y0) / this.factor * 255.0f);
            if (v <= 0) {
                return 0;
            }
            if (v >= 255) {
                return 255;
            }
            return v;
        }

        public int alpha_255_y(int v) {
            return this.y0 + Math.round((float)v / 255.0f * this.factor);
        }

        public float alpha_y_01(int y) {
            float v = 1.0f - (float)(y - this.y0) / this.factor;
            if (v <= 0.0f) {
                return 0.0f;
            }
            if (v >= 1.0f) {
                return 1.0f;
            }
            return v;
        }

        public int alpha_01_y(float v) {
            return this.y0 + Math.round((1.0f - v) * this.factor);
        }

        public int getBaseMax() {
            return Math.max(this.baseColor.getRed(), Math.max(this.baseColor.getGreen(), this.baseColor.getBlue()));
        }

        public Image createImage(Display display) {
            Image image = new Image((Device)display, this.alphaX1 + 1, this.y1 + 1);
            GC gc = new GC((Drawable)image);
            try {
                gc.setAdvanced(false);
                gc.setBackground(this.backgroundColor);
                gc.fillRectangle(0, 0, image.getImageData().width, image.getImageData().height);
                if (this.baseColor.equalsRGB(DEFAULT_BASE)) {
                    int x1 = this.alphaX1 - 1;
                    int y = this.y0;
                    while (y < this.y1) {
                        int alpha255 = 255 - this.alpha_y_255(y);
                        gc.setForeground(new Color(alpha255, alpha255, alpha255));
                        gc.drawLine(this.alphaX0, y, x1, y);
                        ++y;
                    }
                } else {
                    int x1 = this.alphaX1 - 1;
                    int y = this.y0;
                    while (y < this.y1) {
                        int alpha255 = this.alpha_y_255(y);
                        int white = 255 - alpha255;
                        gc.setForeground(new Color(white + this.baseColor.getRed() * alpha255 / 255, white + this.baseColor.getGreen() * alpha255 / 255, white + this.baseColor.getBlue() * alpha255 / 255));
                        gc.drawLine(this.alphaX0, y, x1, y);
                        ++y;
                    }
                }
            }
            finally {
                gc.dispose();
            }
            return image;
        }
    }

    private class SWTListener
    implements PaintListener,
    Listener {
        private static final int TRACK_ALPHA = 1;
        private @Nullable Data data;
        private @Nullable Image image;
        private int mouseState;

        private SWTListener() {
        }

        public void handleEvent(Event event) {
            Data data = this.data;
            switch (event.type) {
                case 3: {
                    if (data != null && event.y >= data.y0 && event.y < data.y1 && event.x >= data.alphaX0 && event.x < data.alphaX1) {
                        AlphaSelector.this.doSetValue(Float.valueOf(data.alpha_y_01(event.y)), event.time, 0);
                        this.mouseState = 1;
                    }
                    return;
                }
                case 4: {
                    this.mouseState = 0;
                    return;
                }
                case 5: {
                    if (data != null) {
                        switch (this.mouseState) {
                            case 1: {
                                AlphaSelector.this.doSetValue(Float.valueOf(data.alpha_y_01(event.y)), event.time, 0);
                            }
                        }
                    }
                    return;
                }
                case 12: {
                    if (this.image == null) break;
                    this.image.dispose();
                    this.image = null;
                }
            }
        }

        private int computeSize(int width, int height) {
            width = Math.round((float)width / 0.15f);
            return Math.min(width - 2, height - 2);
        }

        public void paintControl(PaintEvent e) {
            Rectangle clientArea = AlphaSelector.this.getClientArea();
            int size = this.computeSize(clientArea.width, clientArea.height);
            if (AlphaSelector.this.size > 0 && AlphaSelector.this.size < size) {
                size = AlphaSelector.this.size;
            }
            Data data = this.data;
            Image image = this.image;
            if (data == null || data.size != size || !data.baseColor.equalsRGB(AlphaSelector.this.baseColor)) {
                if (image != null) {
                    this.image = null;
                    image.dispose();
                    image = null;
                }
                this.data = data = new Data(size, AlphaSelector.this.backgroundColor, AlphaSelector.this.baseColor);
            }
            GC gc = e.gc;
            gc.setAdvanced(false);
            gc.setBackground(AlphaSelector.this.backgroundColor);
            gc.fillRectangle(clientArea);
            if (image != null) {
                image.dispose();
                image = null;
            }
            this.image = image = data.createImage(e.display);
            gc.drawImage(image, 0, 0);
            gc.setLineWidth(1);
            gc.setAdvanced(true);
            gc.setAntialias(1);
            float alpha = AlphaSelector.this.value.floatValue();
            int y = data.alpha_01_y(alpha);
            gc.setForeground(e.display.getSystemColor(2));
            gc.drawLine(data.alphaX0 - 1, y, data.alphaX1, y);
            if (255.0f * (1.0f - alpha) + (float)data.getBaseMax() * alpha < 127.0f) {
                gc.setForeground(e.display.getSystemColor(1));
                gc.drawLine(data.alphaX0, y, data.alphaX1 - 1, y);
            }
        }
    }
}

