/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.export.excel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.statet.ecommons.waltable.config.CellConfigAttributes;
import org.eclipse.statet.ecommons.waltable.core.config.ConfigRegistry;
import org.eclipse.statet.ecommons.waltable.core.config.DisplayMode;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerCell;
import org.eclipse.statet.ecommons.waltable.core.style.CellStyling;
import org.eclipse.statet.ecommons.waltable.core.style.RegistryStyle;
import org.eclipse.statet.ecommons.waltable.export.FileOutputStreamProvider;
import org.eclipse.statet.ecommons.waltable.export.ILayerExporter;
import org.eclipse.statet.ecommons.waltable.export.IOutputStreamProvider;
import org.eclipse.statet.internal.ecommons.waltable.WaLTablePlugin;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Shell;

public class ExcelExporter
implements ILayerExporter {
    private static final String EXCEL_HEADER_FILE = "excelExportHeader.txt";
    private final IOutputStreamProvider outputStreamProvider;

    public ExcelExporter() {
        this(new FileOutputStreamProvider("table_export.xls", new String[]{"Excel Workbok (*.xls)"}, new String[]{"*.xls"}));
    }

    public ExcelExporter(IOutputStreamProvider outputStreamProvider) {
        this.outputStreamProvider = outputStreamProvider;
    }

    @Override
    public OutputStream getOutputStream(Shell shell) {
        return this.outputStreamProvider.getOutputStream(shell);
    }

    @Override
    public void exportBegin(OutputStream outputStream) throws IOException {
    }

    @Override
    public void exportEnd(OutputStream outputStream) throws IOException {
    }

    @Override
    public void exportLayerBegin(OutputStream outputStream, String layerName) throws IOException {
        this.writeHeader(outputStream);
        outputStream.write(this.asBytes("<body><table border='1'>"));
    }

    private void writeHeader(OutputStream outputStream) throws IOException {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream headerStream = this.getClass().getResourceAsStream(EXCEL_HEADER_FILE);){
                int c;
                while ((c = headerStream.read()) != -1) {
                    outputStream.write(c);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            WaLTablePlugin.log((IStatus)new Status(4, "org.eclipse.statet.ecommons.waltable.core", "Excel Exporter failed: " + e.getMessage(), (Throwable)e));
        }
    }

    @Override
    public void exportLayerEnd(OutputStream outputStream, String layerName) throws IOException {
        outputStream.write(this.asBytes("</table></body></html>"));
    }

    @Override
    public void exportRowBegin(OutputStream outputStream, long rowPosition) throws IOException {
        outputStream.write(this.asBytes("<tr>\n"));
    }

    @Override
    public void exportRowEnd(OutputStream outputStream, long rowPosition) throws IOException {
        outputStream.write(this.asBytes("</tr>\n"));
    }

    @Override
    public void exportCell(OutputStream outputStream, Object exportDisplayValue, LayerCell cell, ConfigRegistry configRegistry) throws IOException {
        String htmlText;
        RegistryStyle cellStyle = new RegistryStyle(configRegistry, CellConfigAttributes.CELL_STYLE, DisplayMode.NORMAL, cell.getLabels().getLabels());
        Color fg = cellStyle.getAttributeValue(CellStyling.FOREGROUND_COLOR);
        Color bg = cellStyle.getAttributeValue(CellStyling.BACKGROUND_COLOR);
        Font font = cellStyle.getAttributeValue(CellStyling.FONT);
        Object htmlAttributes = String.format("style='color: %s; background-color: %s; %s;'", this.getColorInCSSFormat(fg), this.getColorInCSSFormat(bg), this.getFontInCSSFormat(font));
        String string = htmlText = exportDisplayValue != null ? exportDisplayValue.toString() : "";
        if (htmlText.startsWith(" ")) {
            htmlAttributes = (String)htmlAttributes + " x:str=\"'" + htmlText + "\";";
            htmlText = htmlText.replaceFirst("^(\\ *)", "<span style='mso-spacerun:yes'>$1</span>");
        }
        outputStream.write(this.asBytes(String.format("\t<td %s>%s</td>\n", htmlAttributes, htmlText)));
    }

    private byte[] asBytes(String string) {
        return string.getBytes();
    }

    private String getFontInCSSFormat(Font font) {
        FontData fontData = font.getFontData()[0];
        String fontName = fontData.getName();
        int fontStyle = fontData.getStyle();
        String[] HTML_STYLES = new String[]{"NORMAL", "BOLD", "ITALIC"};
        return String.format("font: %s; font-family: %s", fontStyle <= 2 ? HTML_STYLES[fontStyle] : HTML_STYLES[0], fontName);
    }

    private String getColorInCSSFormat(Color color) {
        return String.format("rgb(%d,%d,%d)", color.getRed(), color.getGreen(), color.getBlue());
    }

    @Override
    public Object getResult() {
        return this.outputStreamProvider.getResult();
    }
}

