/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.eutils.autorun;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.ui.statushandlers.StatusManager;

@NonNullByDefault
public class AutoRunner
extends Job {
    private final String key;
    private final String mode;

    public AutoRunner(String key, String mode) {
        super("Auto Run");
        this.key = (String)ObjectUtils.nonNullAssert((Object)key);
        this.mode = (String)ObjectUtils.nonNullAssert((Object)mode);
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            ILaunchConfiguration config = DebugPlugin.getDefault().getLaunchManager().getLaunchConfiguration(this.key);
            if (config == null) {
                Status status = new Status(2, "org.eclipse.statet.eutils.autorun", 101, "The configured launch configuration for Auto Run could not be loaded.", null);
                StatusManager.getManager().handle((IStatus)status);
                return Status.OK_STATUS;
            }
            config.launch(this.mode, monitor, false, true);
        }
        catch (CoreException e) {
            Status status = new Status(4, "org.eclipse.statet.eutils.autorun", 102, "An error occured when starting the launch configuration by Auto Run.", (Throwable)e);
            return status;
        }
        return Status.OK_STATUS;
    }
}

