/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.jcommons.collections;

import java.util.NoSuchElementException;
import java.util.Spliterators;
import java.util.stream.LongStream;
import java.util.stream.StreamSupport;
import org.eclipse.statet.internal.jcommons.collections.AbstractImLongList;
import org.eclipse.statet.internal.jcommons.collections.ArrayUtils;
import org.eclipse.statet.jcommons.collections.LongList;
import org.eclipse.statet.jcommons.collections.LongListIterator;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;

@NonNullByDefault
public class ImLongEmptyList
extends AbstractImLongList {
    public static final ImLongEmptyList INSTANCE = new ImLongEmptyList();
    private final LongListIterator iterator = new AbstractImLongList.AbstractImLongListIter(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public int nextIndex() {
            return 0;
        }

        @Override
        public long nextLong() {
            throw new NoSuchElementException();
        }

        @Override
        public Long next() {
            throw new NoSuchElementException();
        }

        @Override
        public long nextLongElse(long elseLong) {
            return elseLong;
        }

        @Override
        public boolean hasPrevious() {
            return false;
        }

        @Override
        public int previousIndex() {
            return -1;
        }

        @Override
        public long previousLong() {
            throw new NoSuchElementException();
        }

        @Override
        public Long previous() {
            throw new NoSuchElementException();
        }
    };

    @Override
    public int size() {
        return 0;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public boolean contains(long e) {
        return false;
    }

    @Override
    public long getAt(int index) {
        throw new IndexOutOfBoundsException("index= " + index);
    }

    @Override
    public long getFirst() {
        throw new NoSuchElementException();
    }

    @Override
    public long getLast() {
        throw new NoSuchElementException();
    }

    @Override
    public int indexOf(long e) {
        return -1;
    }

    @Override
    public int lastIndexOf(long e) {
        return -1;
    }

    @Override
    public LongListIterator iterator() {
        return this.iterator;
    }

    @Override
    public LongListIterator listIterator(int index) {
        if (index != 0) {
            throw new IndexOutOfBoundsException("index= " + index);
        }
        return this.iterator;
    }

    @Override
    public LongStream stream() {
        return StreamSupport.longStream(Spliterators.emptyLongSpliterator(), false);
    }

    @Override
    public long[] toArray() {
        return ArrayUtils.EMPTY_LONG;
    }

    @Override
    public void toArray(long[] array) {
        ObjectUtils.nonNullAssert(array);
    }

    @Override
    public void copyTo(int srcIndex, long[] dest, int destIndex, int length) {
        assert (false);
    }

    @Override
    public void copyTo(long[] dest, int destIndex) {
    }

    public int hashCode() {
        return 7;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof LongList) {
            LongList other = (LongList)obj;
            return other.isEmpty();
        }
        return false;
    }

    public String toString() {
        return "[]";
    }
}

