/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.core.model.rpkg.ast;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.statet.dsl.dcf.core.source.ast.Field;
import org.eclipse.statet.internal.r.core.model.rpkg.Messages;
import org.eclipse.statet.internal.r.core.model.rpkg.ast.RPkgSpecAstNode;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.ast.core.AstVisitor;
import org.eclipse.statet.ltk.ast.core.util.AbstractAstProblemReporter;
import org.eclipse.statet.ltk.core.source.SourceContent;
import org.eclipse.statet.ltk.issues.core.IssueRequestor;

@NonNullByDefault
public class RPkgSpecValueProblemReporter
extends AbstractAstProblemReporter {
    private final Visitor visitor = new Visitor();
    private @Nullable Field currentField;

    public RPkgSpecValueProblemReporter() {
        super("RPkg.Descr");
    }

    protected void clear() {
        super.clear();
        this.currentField = null;
    }

    public void run(RPkgSpecAstNode node, SourceContent content, IssueRequestor requestor) {
        try {
            try {
                this.init(content, requestor);
                this.detectField(node);
                node.accept(this.visitor);
                this.flush();
            }
            catch (InvocationTargetException | OperationCanceledException throwable) {
                this.clear();
            }
        }
        finally {
            this.clear();
        }
    }

    public void run(List<RPkgSpecAstNode> nodes, SourceContent content, IssueRequestor requestor) {
        if (nodes.isEmpty()) {
            return;
        }
        try {
            try {
                this.init(content, requestor);
                for (RPkgSpecAstNode node : nodes) {
                    this.detectField(node);
                    node.accept(this.visitor);
                }
                this.flush();
            }
            catch (InvocationTargetException | OperationCanceledException throwable) {
                this.clear();
            }
        }
        finally {
            this.clear();
        }
    }

    private void detectField(RPkgSpecAstNode node) {
        AstNode parent = node.getParent();
        parent = parent != null ? parent.getParent() : null;
        this.currentField = parent instanceof Field ? (Field)parent : null;
    }

    protected String getFieldName() {
        String name = null;
        Field field = this.currentField;
        if (field != null) {
            name = field.getKey().getText();
        }
        return name != null && !name.isEmpty() ? name : "?";
    }

    protected void handleCommonCodes(RPkgSpecAstNode node, int code) throws BadLocationException, InvocationTargetException {
        switch (code & 0x700FFF) {
            case 4196905: {
                this.addProblem(2, code, this.getMessageBuilder().bind(Messages.Descr_FieldValueInvalid_TokenUnknown_message, (Object)this.getFieldName(), (Object)this.getMessageUtil().getFullQuoteText((AstNode)node)), node.getStartOffset(), node.getEndOffset());
                return;
            }
        }
        super.handleCommonCodes((AstNode)node, code);
    }

    private class Visitor
    implements AstVisitor {
        private Visitor() {
        }

        public void visit(AstNode node) throws InvocationTargetException {
            int code = node.getStatusCode() & 0xFFFFFF;
            if (RPkgSpecValueProblemReporter.this.requiredCheck(code) && node instanceof RPkgSpecAstNode) {
                RPkgSpecAstNode specAstNode = (RPkgSpecAstNode)node;
                try {
                    block1 : switch (specAstNode.getNodeType()) {
                        case SPEC_ADDITION: {
                            switch (code & 0x700FFF) {
                                case 4196897: {
                                    RPkgSpecValueProblemReporter.this.addProblem(2, code, RPkgSpecValueProblemReporter.this.getMessageBuilder().bind(Messages.Descr_FieldValueInvalid_BundleSpec, (Object)RPkgSpecValueProblemReporter.this.getFieldName(), (Object)Messages.BundleSpec_Detail_AdditionNotClosed_message), node.getEndOffset() - 1, node.getEndOffset() + 1);
                                    break block1;
                                }
                                case 4196899: {
                                    RPkgSpecValueProblemReporter.this.addProblem(2, code, RPkgSpecValueProblemReporter.this.getMessageBuilder().bind(Messages.Descr_FieldValueInvalid_BundleSpec, (Object)RPkgSpecValueProblemReporter.this.getFieldName(), (Object)Messages.BundleSpec_Detail_VersionConstraint_OpMissing_message), node.getStartOffset() + 1, node.getEndOffset() - 1);
                                    break block1;
                                }
                                case 4196901: {
                                    RPkgSpecValueProblemReporter.this.addProblem(2, code, RPkgSpecValueProblemReporter.this.getMessageBuilder().bind(Messages.Descr_FieldValueInvalid_BundleSpec, (Object)RPkgSpecValueProblemReporter.this.getFieldName(), (Object)Messages.BundleSpec_Detail_VersionConstraint_VersionInvalid_message), node.getStartOffset() + 1, node.getEndOffset() - 1);
                                    break block1;
                                }
                                case 4196896: {
                                    RPkgSpecValueProblemReporter.this.addProblem(2, code, RPkgSpecValueProblemReporter.this.getMessageBuilder().bind(Messages.Descr_FieldValueInvalid_BundleSpec, (Object)RPkgSpecValueProblemReporter.this.getFieldName(), (Object)Messages.BundleSpec_Detail_VersionConstraint_Invalid_message), node.getStartOffset() + 1, node.getEndOffset() - 1);
                                    break block1;
                                }
                            }
                        }
                        default: {
                            RPkgSpecValueProblemReporter.this.handleCommonCodes(specAstNode, code);
                            break;
                        }
                    }
                }
                catch (BadLocationException e) {
                    throw new InvocationTargetException(e);
                }
            }
            node.acceptInChildren((AstVisitor)this);
        }
    }
}

